/* @license GPL-2.0-or-later https://www.drupal.org/licensing/faq */
(function(Drupal,drupalSettings){'use strict';Drupal.behaviors.quantityInput={attach:function(context,settings){once('quantity-input','.quantity-input-wrapper',context).forEach(function(wrapper){const input=wrapper.querySelector('.quantity-input');const minusBtn=wrapper.querySelector('.quantity-btn--minus');const plusBtn=wrapper.querySelector('.quantity-btn--plus');if(!input||(!minusBtn&&!plusBtn))return;const step=parseInt(input.getAttribute('step'))||1;const min=parseInt(input.getAttribute('min'))||0;const max=parseInt(input.getAttribute('max'))||999999999;function updateButtonStates(){const currentValue=parseInt(input.value)||0;if(minusBtn)minusBtn.disabled=currentValue<=min;if(plusBtn)plusBtn.disabled=currentValue>=max;}function increment(){const currentValue=parseInt(input.value)||0;const newValue=Math.min(currentValue+step,max);if(newValue!==currentValue){input.value=newValue;updateButtonStates();triggerChangeEvent();}}function decrement(){const currentValue=parseInt(input.value)||0;const newValue=Math.max(currentValue-step,min);if(newValue!==currentValue){input.value=newValue;updateButtonStates();triggerChangeEvent();}}function triggerChangeEvent(){const event=new Event('change',{bubbles:true});input.dispatchEvent(event);const inputEvent=new Event('input',{bubbles:true});input.dispatchEvent(inputEvent);}function validateInput(){let value=parseInt(input.value);if(isNaN(value))value=min;else if(value<min)value=min;else{if(value>max)value=max;}if(value!==parseInt(input.value))input.value=value;updateButtonStates();}if(plusBtn)plusBtn.addEventListener('click',function(e){e.preventDefault();increment();});if(minusBtn)minusBtn.addEventListener('click',function(e){e.preventDefault();decrement();});input.addEventListener('input',function(){updateButtonStates();});input.addEventListener('blur',function(){validateInput();triggerChangeEvent();});input.addEventListener('keydown',function(e){if(e.key==='ArrowUp'){e.preventDefault();increment();}else{if(e.key==='ArrowDown'){e.preventDefault();decrement();}}});input.addEventListener('wheel',function(e){e.preventDefault();if(e.deltaY<0)increment();else decrement();});updateButtonStates();const form=input.closest('form');if(form)form.addEventListener('submit',function(){validateInput();});});}};})(Drupal,drupalSettings);;
