/* @license GPL-2.0-or-later https://www.drupal.org/licensing/faq */
(function($,Drupal,drupalSettings){Drupal.elementIsVisible=function(elem){return !!(elem.offsetWidth||elem.offsetHeight||elem.getClientRects().length);};Drupal.elementIsHidden=function(elem){return !Drupal.elementIsVisible(elem);};let showWeight=JSON.parse(localStorage.getItem('Drupal.tableDrag.showWeight'));Drupal.behaviors.tableDrag={attach(context,settings){function initTableDrag(table,base){if(table.length)Drupal.tableDrag[base]=new Drupal.tableDrag(table[0],settings.tableDrag[base]);}Object.keys(settings.tableDrag||{}).forEach((base)=>{initTableDrag($(once('tabledrag',`#${base}`,context)),base);});}};Drupal.tableDrag=function(table,tableSettings){const self=this;const $table=$(table);this.$table=$(table);this.table=table;this.tableSettings=tableSettings;this.dragObject=null;this.rowObject=null;this.oldRowElement=null;this.oldY=null;this.changed=false;this.maxDepth=0;this.rtl=window.getComputedStyle(this.table).direction==='rtl'?-1:1;this.striping=$(this.table).data('striping')===1;this.scrollSettings={amount:4,interval:50,trigger:70};this.scrollInterval=null;this.scrollY=0;this.windowHeight=0;this.$toggleWeightButton=null;this.indentEnabled=false;this.changedRowIds=Drupal.tableDrag[table.id]?Drupal.tableDrag[table.id].changedRowIds:new Set();Object.keys(tableSettings||{}).forEach((group)=>{Object.keys(tableSettings[group]||{}).forEach((n)=>{if(tableSettings[group][n].relationship==='parent')this.indentEnabled=true;if(tableSettings[group][n].limit>0)this.maxDepth=tableSettings[group][n].limit;});});this.dragOrientation=this.indentEnabled?'drag':'drag-y';if(this.indentEnabled){const countNestableRows=$table.find('> tr.draggable, > tbody > tr.draggable').not('.tabledrag-leaf').length;if(countNestableRows===0)this.dragOrientation='drag-y';this.indentCount=1;const indent=Drupal.theme('tableDragIndentation');const testRow=$('<tr></tr>').addClass('draggable').appendTo(table);const testCell=$('<td></td>').appendTo(testRow).prepend(indent).prepend(indent);const $indentation=testCell.find('.js-indentation');this.indentAmount=$indentation.get(1).offsetLeft-$indentation.get(0).offsetLeft;testRow.remove();}$table.find('> tr.draggable, > tbody > tr.draggable').each(function(){self.makeDraggable(this);});const $toggleWeightWrapper=$(Drupal.theme('tableDragToggle'));this.$toggleWeightButton=$toggleWeightWrapper.find('[data-drupal-selector="tabledrag-toggle-weight"]');this.$toggleWeightButton.on('click',function(e){e.preventDefault();this.toggleColumns();}.bind(this));if($table.parent('.gin-table-scroll-wrapper').length>0)$table.parent('.gin-table-scroll-wrapper').before($toggleWeightWrapper);else $table.before($toggleWeightWrapper);self.initColumns();$(document).on('touchmove',(event)=>self.dragRow(event.originalEvent.touches[0],self));$(document).on('touchend',(event)=>self.dropRow(event.originalEvent.touches[0],self));$(document).on('mousemove pointermove',(event)=>self.dragRow(event,self));$(document).on('mouseup pointerup',(event)=>self.dropRow(event,self));$(window).on('storage',function(e){if(e.originalEvent.key==='Drupal.tableDrag.showWeight'){showWeight=JSON.parse(e.originalEvent.newValue);this.displayColumns(showWeight);}}.bind(this));this.changedRowIds.forEach((changedRowId)=>{const rowObject=new self.row(document.getElementById(changedRowId),'',self.indentEnabled,self.maxDepth,true);rowObject.markChanged();});};Drupal.tableDrag.prototype.initColumns=function(){const $table=this.$table;let hidden;let cell;let columnIndex;Object.keys(this.tableSettings||{}).forEach((group)=>{Object.keys(this.tableSettings[group]).some((tableSetting)=>{const field=$table.find(`.${this.tableSettings[group][tableSetting].target}`).eq(0);if(field.length&&this.tableSettings[group][tableSetting].hidden){hidden=this.tableSettings[group][tableSetting].hidden;cell=field.closest('td');return true;}return false;});if(hidden&&cell[0]){columnIndex=cell.parent().find('> td').index(cell.get(0))+1;$table.find('> thead > tr, > tbody > tr, > tr').each(this.addColspanClass(columnIndex));}});this.displayColumns(showWeight);};Drupal.tableDrag.prototype.addColspanClass=function(columnIndex){return function(){const $row=$(this);let index=columnIndex;const cells=$row.children();let cell;cells.each(function(n){if(n<index&&this.colSpan&&this.colSpan>1)index-=this.colSpan-1;});if(index>0){cell=cells.filter(`:nth-child(${index})`);if(cell[0].colSpan&&cell[0].colSpan>1)cell.addClass('tabledrag-has-colspan');else cell.addClass('tabledrag-hide');}};};Drupal.tableDrag.prototype.displayColumns=function(displayWeight){if(displayWeight)this.showColumns();else this.hideColumns();this.$toggleWeightButton.html(Drupal.theme('toggleButtonContent',displayWeight));$(once.filter('tabledrag','table')).trigger('columnschange',!!displayWeight);};Drupal.tableDrag.prototype.toggleColumns=function(){showWeight=!showWeight;this.displayColumns(showWeight);if(showWeight)localStorage.setItem('Drupal.tableDrag.showWeight',showWeight);else localStorage.removeItem('Drupal.tableDrag.showWeight');};Drupal.tableDrag.prototype.hideColumns=function(){const $tables=$(once.filter('tabledrag','table'));$tables.find('.tabledrag-hide').each(function(){this.style.display='none';});$tables.find('.tabledrag-handle').each(function(){this.style.display='';});$tables.find('.tabledrag-has-colspan').each(function(){this.colSpan-=1;});};Drupal.tableDrag.prototype.showColumns=function(){const $tables=$(once.filter('tabledrag','table'));$tables.find('.tabledrag-hide').each(function(){this.style.display='';});$tables.find('.tabledrag-handle').each(function(){this.style.display='none';});$tables.find('.tabledrag-has-colspan').each(function(){this.colSpan+=1;});};Drupal.tableDrag.prototype.rowSettings=function(group,row){const field=$(row).find(`.${group}`);const tableSettingsGroup=this.tableSettings[group];return Object.keys(tableSettingsGroup).map((delta)=>{const targetClass=tableSettingsGroup[delta].target;let rowSettings;if(field[0].matches(`.${targetClass}`)){rowSettings={};Object.keys(tableSettingsGroup[delta]).forEach((n)=>{rowSettings[n]=tableSettingsGroup[delta][n];});}return rowSettings;}).filter((rowSetting)=>rowSetting)[0];};Drupal.tableDrag.prototype.makeDraggable=function(item){const self=this;const $item=$(item);$item.find('td:first-of-type').find('a').addClass('menu-item__link');const $handle=$(Drupal.theme('tableDragHandle',this.dragOrientation));if(this.dragOrientation==='drag-y')$handle.addClass('tabledrag-handle-y');const $indentationLast=$item.find('td:first-of-type').find('.js-indentation').eq(-1);if($indentationLast.length){$indentationLast.after($handle);self.indentCount=Math.max($item.find('.js-indentation').length,self.indentCount);}else $item.find('td').eq(0).prepend($handle);$handle.on('mousedown touchstart pointerdown',(event)=>{event.preventDefault();if(event.originalEvent.type==='touchstart')event=event.originalEvent.touches[0];self.dragStart(event,self,item);});$handle.on('click',(e)=>{e.preventDefault();});$handle.on('focus',()=>{self.safeBlur=true;});$handle.on('blur',(event)=>{if(self.rowObject&&self.safeBlur)self.dropRow(event,self);});$handle.on('keydown',(event)=>{if(event.keyCode!==9&&!self.rowObject)self.rowObject=new self.row(item,'keyboard',self.indentEnabled,self.maxDepth,true);let keyChange=false;let groupHeight;switch(event.keyCode){case 37:case 63234:keyChange=true;self.rowObject.indent(-1*self.rtl);break;case 38:case 63232:{let $previousRow=$(self.rowObject.element).prev('tr').eq(0);let previousRow=$previousRow.get(0);while(previousRow&&Drupal.elementIsHidden(previousRow)){$previousRow=$(previousRow).prev('tr').eq(0);previousRow=$previousRow.get(0);}if(previousRow){self.safeBlur=false;self.rowObject.direction='up';keyChange=true;if(item.matches('.tabledrag-root')){groupHeight=0;while(previousRow&&$previousRow.find('.js-indentation').length){$previousRow=$(previousRow).prev('tr').eq(0);previousRow=$previousRow.get(0);groupHeight+=Drupal.elementIsHidden(previousRow)?0:previousRow.offsetHeight;}if(previousRow){self.rowObject.swap('before',previousRow);window.scrollBy(0,-groupHeight);}}else{if(self.table.tBodies[0].rows[0]!==previousRow||previousRow.matches('.draggable')){self.rowObject.swap('before',previousRow);self.rowObject.interval=null;self.rowObject.indent(0);window.scrollBy(0,-parseInt(item.offsetHeight,10));}}$handle.trigger('focus');}break;}case 39:case 63235:keyChange=true;self.rowObject.indent(self.rtl);break;case 40:case 63233:{let $nextRow=$(self.rowObject.group).eq(-1).next('tr').eq(0);let nextRow=$nextRow.get(0);while(nextRow&&Drupal.elementIsHidden(nextRow)){$nextRow=$(nextRow).next('tr').eq(0);nextRow=$nextRow.get(0);}if(nextRow){self.safeBlur=false;self.rowObject.direction='down';keyChange=true;if(item.matches('.tabledrag-root')){groupHeight=0;const nextGroup=new self.row(nextRow,'keyboard',self.indentEnabled,self.maxDepth,false);if(nextGroup){$(nextGroup.group).each(function(){groupHeight+=Drupal.elementIsHidden(this)?0:this.offsetHeight;});const nextGroupRow=$(nextGroup.group).eq(-1).get(0);self.rowObject.swap('after',nextGroupRow);window.scrollBy(0,parseInt(groupHeight,10));}}else{self.rowObject.swap('after',nextRow);self.rowObject.interval=null;self.rowObject.indent(0);window.scrollBy(0,parseInt(item.offsetHeight,10));}$handle.trigger('focus');}break;}}if(self.rowObject&&self.rowObject.changed===true){$(item).addClass('drag');if(self.oldRowElement)$(self.oldRowElement).removeClass('drag-previous');self.oldRowElement=item;if(self.striping===true)self.restripeTable();self.onDrag();}if(keyChange)return false;});$handle.on('keypress',(event)=>{switch(event.keyCode){case 37:case 38:case 39:case 40:return false;}});};Drupal.tableDrag.prototype.dragStart=function(event,self,item){self.dragObject={};self.dragObject.initOffset=self.getPointerOffset(item,event);self.dragObject.initPointerCoords=self.pointerCoords(event);if(self.indentEnabled)self.dragObject.indentPointerPos=self.dragObject.initPointerCoords;if(self.rowObject)$(self.rowObject.element).find('a.tabledrag-handle').trigger('blur');self.rowObject=new self.row(item,'pointer',self.indentEnabled,self.maxDepth,true);self.table.topY=$(self.table).offset().top;self.table.bottomY=self.table.topY+self.table.offsetHeight;$(item).addClass('drag');$('body').addClass(this.dragOrientation);if(self.oldRowElement)$(self.oldRowElement).removeClass('drag-previous');self.oldY=self.pointerCoords(event).y;};Drupal.tableDrag.prototype.dragRow=function(event,self){if(self.dragObject){self.currentPointerCoords=self.pointerCoords(event);const y=self.currentPointerCoords.y-self.dragObject.initOffset.y;const x=self.currentPointerCoords.x-self.dragObject.initOffset.x;if(y!==self.oldY){self.rowObject.direction=y>self.oldY?'down':'up';self.oldY=y;const scrollAmount=self.checkScroll(self.currentPointerCoords.y);clearInterval(self.scrollInterval);if((scrollAmount>0&&self.rowObject.direction==='down')||(scrollAmount<0&&self.rowObject.direction==='up'))self.setScroll(scrollAmount);const currentRow=self.findDropTargetRow(x,y);if(currentRow){if(self.rowObject.direction==='down')self.rowObject.swap('after',currentRow,self);else self.rowObject.swap('before',currentRow,self);if(self.striping===true)self.restripeTable();}}if(self.indentEnabled){const xDiff=self.currentPointerCoords.x-self.dragObject.indentPointerPos.x;const indentDiff=Math.round(xDiff/self.indentAmount);const indentChange=self.rowObject.indent(indentDiff);self.dragObject.indentPointerPos.x+=self.indentAmount*indentChange*self.rtl;self.indentCount=Math.max(self.indentCount,self.rowObject.indents);}return false;}};Drupal.tableDrag.prototype.dropRow=function(event,self){let droppedRow;let $droppedRow;if(self.rowObject!==null){droppedRow=self.rowObject.element;$droppedRow=$(droppedRow);if(self.rowObject.changed===true){self.updateFields(droppedRow);Object.keys(self.tableSettings||{}).forEach((group)=>{const rowSettings=self.rowSettings(group,droppedRow);if(rowSettings.relationship==='group')Object.keys(self.rowObject.children||{}).forEach((n)=>{self.updateField(self.rowObject.children[n],group);});});self.rowObject.markChanged();if(self.changed===false){self.rowObject.addChangedWarning();self.changed=true;}}if(self.indentEnabled)self.rowObject.removeIndentClasses();if(self.oldRowElement)$(self.oldRowElement).removeClass('drag-previous');$droppedRow.removeClass('drag').addClass('drag-previous');self.oldRowElement=droppedRow;self.onDrop();self.rowObject=null;}if(self.dragObject!==null){self.dragObject=null;$('body').removeClass(self.dragOrientation);clearInterval(self.scrollInterval);}};Drupal.tableDrag.prototype.pointerCoords=function(event){if(event.pageX||event.pageY)return {x:event.pageX,y:event.pageY};return {x:event.clientX+document.body.scrollLeft-document.body.clientLeft,y:event.clientY+document.body.scrollTop-document.body.clientTop};};Drupal.tableDrag.prototype.getPointerOffset=function(target,event){const docPos=$(target).offset();const pointerPos=this.pointerCoords(event);return {x:pointerPos.x-docPos.left,y:pointerPos.y-docPos.top};};Drupal.tableDrag.prototype.findDropTargetRow=function(x,y){const rows=$(this.table.tBodies[0].rows).not(':hidden');for(let n=0;n<rows.length;n++){let row=rows[n];let $row=$(row);const rowY=$row.offset().top;let rowHeight;if(row.offsetHeight===0)rowHeight=parseInt(row.firstChild.offsetHeight,10)/2;else rowHeight=parseInt(row.offsetHeight,10)/2;if(y>rowY-rowHeight&&y<rowY+rowHeight){if(this.indentEnabled){if(Object.keys(this.rowObject.group).some((o)=>this.rowObject.group[o]===row))return null;}else{if(row===this.rowObject.element)return null;}if(!this.rowObject.isValidSwap(row))return null;while(Drupal.elementIsHidden(row)&&Drupal.elementIsHidden($row.prev('tr')[0])){$row=$row.prev('tr:first-of-type');row=$row.get(0);}return row;}}return null;};Drupal.tableDrag.prototype.updateFields=function(changedRow){Object.keys(this.tableSettings||{}).forEach((group)=>{this.updateField(changedRow,group);});};Drupal.tableDrag.prototype.updateField=function(changedRow,group){let rowSettings=this.rowSettings(group,changedRow);const $changedRow=$(changedRow);let sourceRow;let $previousRow;let previousRow;let useSibling;if(rowSettings.relationship==='self'||rowSettings.relationship==='group')sourceRow=changedRow;else if(rowSettings.relationship==='sibling'){$previousRow=$changedRow.prev('tr:first-of-type');previousRow=$previousRow.get(0);const $nextRow=$changedRow.next('tr:first-of-type');const nextRow=$nextRow.get(0);sourceRow=changedRow;if(previousRow&&previousRow.matches('.draggable')&&$previousRow.find(`.${group}`).length)if(this.indentEnabled){if($previousRow.find('.js-indentations').length===$changedRow.find('.js-indentations').length)sourceRow=previousRow;}else sourceRow=previousRow;else{if(nextRow&&nextRow.matches('.draggable')&&$nextRow.find(`.${group}`).length)if(this.indentEnabled){if($nextRow.find('.js-indentations').length===$changedRow.find('.js-indentations').length)sourceRow=nextRow;}else sourceRow=nextRow;}}else{if(rowSettings.relationship==='parent'){$previousRow=$changedRow.prev('tr');previousRow=$previousRow;while($previousRow.length&&$previousRow.find('.js-indentation').length>=this.rowObject.indents){$previousRow=$previousRow.prev('tr');previousRow=$previousRow;}if($previousRow.length)sourceRow=$previousRow.get(0);else{sourceRow=$(this.table).find('tr.draggable:first-of-type').get(0);if(sourceRow===this.rowObject.element)sourceRow=$(this.rowObject.group[this.rowObject.group.length-1]).next('tr.draggable').get(0);useSibling=true;}}}this.copyDragClasses(sourceRow,changedRow,group);rowSettings=this.rowSettings(group,changedRow);if(useSibling){rowSettings.relationship='sibling';rowSettings.source=rowSettings.target;}const targetClass=`.${rowSettings.target}`;const targetElement=$changedRow.find(targetClass).get(0);if(targetElement){const sourceClass=`.${rowSettings.source}`;const sourceElement=$(sourceClass,sourceRow).get(0);switch(rowSettings.action){case 'depth':targetElement.value=$(sourceElement).closest('tr').find('.js-indentation').length;break;case 'match':targetElement.value=sourceElement.value;break;case 'order':{const siblings=this.rowObject.findSiblings(rowSettings);if(targetElement.tagName==='SELECT'){const values=[];$(targetElement).find('option').each(function(){values.push(this.value);});const maxVal=values[values.length-1];$(siblings).find(targetClass).each(function(){if(values.length>0)this.value=values.shift();else this.value=maxVal;});}else{let weight=0;const $siblingTarget=$(siblings[0]).find(targetClass);if($siblingTarget.length)weight=parseInt($siblingTarget[0].value,10)||0;$(siblings).find(targetClass).each(function(){this.value=weight;weight++;});}break;}}}};Drupal.tableDrag.prototype.copyDragClasses=function(sourceRow,targetRow,group){const sourceElement=$(sourceRow).find(`.${group}`);const targetElement=$(targetRow).find(`.${group}`);if(sourceElement.length&&targetElement.length)targetElement[0].className=sourceElement[0].className;};Drupal.tableDrag.prototype.checkScroll=function(cursorY){const de=document.documentElement;const b=document.body;const windowHeight=window.innerHeight||(de.clientHeight&&de.clientWidth!==0?de.clientHeight:b.offsetHeight);this.windowHeight=windowHeight;let scrollY;if(document.all)scrollY=!de.scrollTop?b.scrollTop:de.scrollTop;else scrollY=window.pageYOffset?window.pageYOffset:window.scrollY;this.scrollY=scrollY;const trigger=this.scrollSettings.trigger;let delta=0;if(cursorY-scrollY>windowHeight-trigger){delta=trigger/(windowHeight+scrollY-cursorY);delta=delta>0&&delta<trigger?delta:trigger;return delta*this.scrollSettings.amount;}if(cursorY-scrollY<trigger){delta=trigger/(cursorY-scrollY);delta=delta>0&&delta<trigger?delta:trigger;return -delta*this.scrollSettings.amount;}};Drupal.tableDrag.prototype.setScroll=function(scrollAmount){const self=this;this.scrollInterval=setInterval(()=>{self.checkScroll(self.currentPointerCoords.y);const aboveTable=self.scrollY>self.table.topY;const belowTable=self.scrollY+self.windowHeight<self.table.bottomY;if((scrollAmount>0&&belowTable)||(scrollAmount<0&&aboveTable))window.scrollBy(0,scrollAmount);},this.scrollSettings.interval);};Drupal.tableDrag.prototype.restripeTable=function(){$(this.table).find('> tbody > tr.draggable, > tr.draggable').filter(':visible').filter(':odd').removeClass('odd').addClass('even').end().filter(':even').removeClass('even').addClass('odd');};Drupal.tableDrag.prototype.onDrag=function(){return null;};Drupal.tableDrag.prototype.onDrop=function(){return null;};Drupal.tableDrag.prototype.row=function(tableRow,method,indentEnabled,maxDepth,addClasses){const $tableRow=$(tableRow);this.element=tableRow;this.method=method;this.group=[tableRow];this.groupDepth=$tableRow.find('.js-indentation').length;this.changed=false;this.table=$tableRow.closest('table')[0];this.indentEnabled=indentEnabled;this.maxDepth=maxDepth;this.direction='';if(this.indentEnabled){this.indents=$tableRow.find('.js-indentation').length;this.children=this.findChildren(addClasses);this.group=this.group.concat(this.children);for(let n=0;n<this.group.length;n++)this.groupDepth=Math.max($(this.group[n]).find('.js-indentation').length,this.groupDepth);}};Drupal.tableDrag.prototype.row.prototype.addChangedWarning=function(){if(!$(this.table.parentNode).find('.tabledrag-changed-warning').length){const $changedWarning=$(Drupal.theme('tableDragChangedWarning'));const $form=$(this.table).closest('form');let $moveTo=this.table;if($changedWarning.parents('.gin-table-scroll-wrapper').has('.tabledrag-toggle-weight-wrapper'))$moveTo='.tabledrag-toggle-weight-wrapper';else{if($changedWarning.parents('.gin-table-scroll-wrapper'))$moveTo='.gin-table-scroll-wrapper';}$changedWarning.insertBefore($moveTo).hide().fadeIn($form[0].hasAttribute('data-tabledrag-save-warning')?0:'slow');$form[0].setAttribute('data-tabledrag-save-warning',true);}};Drupal.tableDrag.prototype.row.prototype.findChildren=function(addClasses){const parentIndentation=this.indents;let currentRow=$(this.element,this.table).next('tr.draggable');const rows=[];let child=0;function rowIndentation(indentNum,el){const self=$(el);if(child===1&&indentNum===parentIndentation)self.addClass('tree-child-first');if(indentNum===parentIndentation)self.addClass('tree-child');else{if(indentNum>parentIndentation)self.addClass('tree-child-horizontal');}}while(currentRow.length){if(currentRow.find('.js-indentation').length>parentIndentation){child++;rows.push(currentRow[0]);if(addClasses)currentRow.find('.js-indentation').each(rowIndentation);}else break;currentRow=currentRow.next('tr.draggable');}if(addClasses&&rows.length)$(rows[rows.length-1]).find(`.js-indentation:nth-child(${parentIndentation+1})`).addClass('tree-child-last');return rows;};Drupal.tableDrag.prototype.row.prototype.isValidSwap=function(row){const $row=$(row);if(this.indentEnabled){let prevRow;let nextRow;if(this.direction==='down'){prevRow=row;nextRow=$row.next('tr').get(0);}else{prevRow=$row.prev('tr').get(0);nextRow=row;}this.interval=this.validIndentInterval(prevRow,nextRow);if(this.interval.min>this.interval.max)return false;}if(this.table.tBodies[0].rows[0]===row&&!row.matches('.draggable'))return false;return true;};Drupal.tableDrag.prototype.row.prototype.swap=function(position,row){this.group.forEach((row)=>{Drupal.detachBehaviors(row,drupalSettings,'move');});$(row)[position](this.group);this.group.forEach((row)=>{Drupal.attachBehaviors(row,drupalSettings);});this.changed=true;this.onSwap(row);};Drupal.tableDrag.prototype.row.prototype.validIndentInterval=function(prevRow,nextRow){const $prevRow=$(prevRow);let maxIndent;const minIndent=nextRow?$(nextRow).find('.js-indentation').length:0;if(!prevRow||!prevRow.matches('.draggable')||this.element.matches('.tabledrag-root'))maxIndent=0;else{maxIndent=$prevRow.find('.js-indentation').length+(prevRow.matches('.tabledrag-leaf')?0:1);if(this.maxDepth)maxIndent=Math.min(maxIndent,this.maxDepth-(this.groupDepth-this.indents));}return {min:minIndent,max:maxIndent};};Drupal.tableDrag.prototype.row.prototype.indent=function(indentDiff){const $group=$(this.group);if(!this.interval){const prevRow=$(this.element).prev('tr').get(0);const nextRow=$group.eq(-1).next('tr').get(0);this.interval=this.validIndentInterval(prevRow,nextRow);}let indent=this.indents+indentDiff;indent=Math.max(indent,this.interval.min);indent=Math.min(indent,this.interval.max);indentDiff=indent-this.indents;for(let n=1;n<=Math.abs(indentDiff);n++)if(indentDiff<0){$group.find('.js-indentation:first-of-type').remove();this.indents--;}else{$group.find('td:first-of-type').prepend(Drupal.theme('tableDragIndentation'));this.indents++;}if(indentDiff){this.changed=true;this.groupDepth+=indentDiff;this.onIndent();}return indentDiff;};Drupal.tableDrag.prototype.row.prototype.findSiblings=function(rowSettings){const siblings=[];const directions=['prev','next'];const rowIndentation=this.indents;let checkRowIndentation;for(let d=0;d<directions.length;d++){let checkRow=$(this.element)[directions[d]]();while(checkRow.length){if(checkRow.find(`.${rowSettings.target}`)){if(this.indentEnabled)checkRowIndentation=checkRow.find('.js-indentation').length;if(!this.indentEnabled||checkRowIndentation===rowIndentation)siblings.push(checkRow[0]);else{if(checkRowIndentation<rowIndentation)break;}}else break;checkRow=checkRow[directions[d]]();}if(directions[d]==='prev'){siblings.reverse();siblings.push(this.element);}}return siblings;};Drupal.tableDrag.prototype.row.prototype.removeIndentClasses=function(){Object.keys(this.children||{}).forEach((n)=>{$(this.children[n]).find('.js-indentation').removeClass('tree-child').removeClass('tree-child-first').removeClass('tree-child-last').removeClass('tree-child-horizontal');});};Drupal.tableDrag.prototype.row.prototype.markChanged=function(){const marker=Drupal.theme('tableDragChangedMarker');const cell=$(this.element).find('td:first-of-type');if(cell.find('abbr.tabledrag-changed').length===0)cell.append(marker);Drupal.tableDrag[this.table.id].changedRowIds.add(this.element.id);};Drupal.tableDrag.prototype.row.prototype.onIndent=function(){return null;};Drupal.tableDrag.prototype.row.prototype.onSwap=function(swappedRow){return null;};$.extend(Drupal.theme,{tableDragChangedMarker(){return `<abbr class="warning tabledrag-changed" title="${Drupal.t('Changed')}">*</abbr>`;},tableDragIndentation(){return '<div class="js-indentation indentation">&nbsp;</div>';},tableDragChangedWarning(){return `<div class="tabledrag-changed-warning messages messages--warning" role="alert">${Drupal.theme('tableDragChangedMarker')} ${Drupal.t('You have unsaved changes.')}</div>`;},tableDragToggle:()=>`<div class="tabledrag-toggle-weight-wrapper" data-drupal-selector="tabledrag-toggle-weight-wrapper">
            <button type="button" class="link tabledrag-toggle-weight" data-drupal-selector="tabledrag-toggle-weight"></button>
            </div>`,toggleButtonContent:(show)=>{const classes=['action-link','action-link--extrasmall','tabledrag-toggle-weight'];let text='';if(show){classes.push('action-link--icon-hide');text=Drupal.t('Hide row weights');}else{classes.push('action-link--icon-show');text=Drupal.t('Show row weights');}return `<span class="${classes.join(' ')}">${text}</span>`;},tableDragHandle(dragOrientation='drag'){const title=dragOrientation==='drag-y'?Drupal.t('Change order'):Drupal.t('Move in any direction');return `<a href="#" title="${title}"
        class="tabledrag-handle"><div class="handle"></div></a>`;}});})(jQuery,Drupal,drupalSettings);;
(($,Drupal)=>{Drupal.behaviors.claroTableDrag={attach(context,settings){const createItemWrapBoundaries=(row)=>{const $row=$(row);const $firstCell=$row.find('td:first-of-type').eq(0).wrapInner(Drupal.theme('tableDragCellContentWrapper')).wrapInner($(Drupal.theme('tableDragCellItemsWrapper')).addClass('js-tabledrag-cell-content'));const $targetElem=$firstCell.find('.js-tabledrag-cell-content');$targetElem.eq(0).find('> .tabledrag-cell-content__item > .js-tabledrag-handle, > .tabledrag-cell-content__item > .js-indentation').prependTo($targetElem);};Object.keys(settings.tableDrag||{}).forEach((base)=>{once('claroTabledrag',$(context).find(`#${base}`).find('> tr.draggable, > tbody > tr.draggable')).forEach(createItemWrapBoundaries);});}};$.extend(Drupal.tableDrag.prototype.row.prototype,{markChanged(){const marker=$(Drupal.theme('tableDragChangedMarker')).addClass('js-tabledrag-changed-marker');const cell=$(this.element).find('td:first-of-type');if(cell.find('.js-tabledrag-changed-marker').length===0)cell.find('.js-tabledrag-handle').after(marker);Drupal.tableDrag[this.table.id].changedRowIds.add(this.element.id);},onIndent(){$(this.table).find('.tabledrag-cell > .js-indentation').each((index,indentToMove)=>{const $indentToMove=$(indentToMove);const $cellContent=$indentToMove.siblings('.tabledrag-cell-content');$indentToMove.prependTo($cellContent);});}});$.extend(Drupal.theme,{tableDragIndentation(){return '<div class="js-indentation indentation"><svg xmlns="http://www.w3.org/2000/svg" class="tree" width="25" height="25" viewBox="0 0 25 25"><path class="tree__item tree__item-child-ltr tree__item-child-last-ltr tree__item-horizontal tree__item-horizontal-right" d="M12,12.5 H25" stroke="#888"/><path class="tree__item tree__item-child-rtl tree__item-child-last-rtl tree__item-horizontal tree__horizontal-left" d="M0,12.5 H13" stroke="#888"/><path class="tree__item tree__item-child-ltr tree__item-child-rtl tree__item-child-last-ltr tree__item-child-last-rtl tree__vertical tree__vertical-top" d="M12.5,12 v-99" stroke="#888"/><path class="tree__item tree__item-child-ltr tree__item-child-rtl tree__vertical tree__vertical-bottom" d="M12.5,12 v99" stroke="#888"/></svg></div>';},tableDragChangedWarning(){return `<div class="tabledrag-changed-warning messages messages--warning" role="alert">${Drupal.theme('tableDragChangedMarker')} ${Drupal.t('You have unsaved changes.')}</div>`;},tableDragHandle:(dragOrientation='drag')=>{const title=dragOrientation==='drag-y'?Drupal.t('Change order'):Drupal.t('Move in any direction');return `<a href="#" title="${title}" class="tabledrag-handle js-tabledrag-handle"></a>`;},tableDragToggle:()=>`<div class="tabledrag-toggle-weight-wrapper" data-drupal-selector="tabledrag-toggle-weight-wrapper">
            <button type="button" class="link action-link tabledrag-toggle-weight" data-drupal-selector="tabledrag-toggle-weight"></button>
            </div>`,toggleButtonContent:(show)=>{const classes=['action-link','action-link--extrasmall','tabledrag-toggle-weight'];let text='';if(show){classes.push('action-link--icon-hide');text=Drupal.t('Hide row weights');}else{classes.push('action-link--icon-show');text=Drupal.t('Show row weights');}return `<span class="${classes.join(' ')}">${text}</a>`;},tableDragCellContentWrapper(){return '<div class="tabledrag-cell-content__item"></div>';},tableDragCellItemsWrapper(){return '<div class="tabledrag-cell-content"></div>';}});})(jQuery,Drupal);;
(function($,Drupal,window){function TableResponsive(table){this.table=table;this.$table=$(table);this.showText=Drupal.t('Show all columns');this.hideText=Drupal.t('Hide lower priority columns');this.$headers=this.$table.find('th');this.$link=$('<button type="button" class="link tableresponsive-toggle"></button>').attr('title',Drupal.t('Show table cells that were hidden to make the table fit within a small screen.')).on('click',this.eventhandlerToggleColumns.bind(this));this.$table.before($('<div class="tableresponsive-toggle-columns"></div>').append(this.$link));$(window).on('resize.tableresponsive',this.eventhandlerEvaluateColumnVisibility.bind(this));}Drupal.behaviors.tableResponsive={attach(context,settings){once('tableresponsive','table.responsive-enabled',context).forEach((table)=>{TableResponsive.tables.push(new TableResponsive(table));});if(TableResponsive.tables.length)$(window).trigger('resize.tableresponsive');}};$.extend(TableResponsive,{tables:[]});$.extend(TableResponsive.prototype,{eventhandlerEvaluateColumnVisibility(e){const pegged=parseInt(this.$link.data('pegged'),10);const hiddenLength=this.$headers.filter('.priority-medium:hidden, .priority-low:hidden').length;if(hiddenLength>0){this.$link.show();this.$link[0].textContent=this.showText;}if(!pegged&&hiddenLength===0){this.$link.hide();this.$link[0].textContent=this.hideText;}},eventhandlerToggleColumns(e){e.preventDefault();const self=this;const $hiddenHeaders=this.$headers.filter('.priority-medium:hidden, .priority-low:hidden');this.$revealedCells=this.$revealedCells||$();if($hiddenHeaders.length>0){$hiddenHeaders.each(function(index,element){const $header=$(this);const position=$header.prevAll('th').length;self.$table.find('tbody tr').each(function(){const $cells=$(this).find('td').eq(position);$cells.show();self.$revealedCells=$().add(self.$revealedCells).add($cells);});$header.show();self.$revealedCells=$().add(self.$revealedCells).add($header);});this.$link[0].textContent=this.hideText;this.$link.data('pegged',1);}else{this.$revealedCells.hide();this.$revealedCells.each(function(index,element){const $cell=$(this);const properties=$cell.attr('style').split(';');const newProps=[];const match=/^display\s*:\s*none$/;for(let i=0;i<properties.length;i++){const prop=properties[i];prop.trim();const isDisplayNone=match.exec(prop);if(isDisplayNone)continue;newProps.push(prop);}$cell.attr('style',newProps.join(';'));});this.$link[0].textContent=this.showText;this.$link.data('pegged',0);$(window).trigger('resize.tableresponsive');}}});Drupal.TableResponsive=TableResponsive;})(jQuery,Drupal,window);;
