<?php

namespace Drupal\commerce_payment\Plugin\Commerce\PaymentGateway;

use Symfony\Component\HttpFoundation\Request;

/**
 * Defines the interface for gateways which support notifications.
 *
 * Payment providers can use the notification URL (commerce_payment.notify)
 * to inform the site that a new pending/complete payment should be created
 * (if the payment happened off-site), or to provide information about an
 * existing payment (refunds, disputes, etc).
 */
interface SupportsNotificationsInterface {

  /**
   * Processes the notification request.
   *
   * This method should only be concerned with creating/completing payments,
   * the parent order does not need to be touched. The order state is updated
   * automatically when the order is paid in full, or manually by the
   * merchant (via the admin UI).
   *
   * Note:
   * This method can't throw exceptions on failure because some payment
   * providers expect an error response to be returned in that case.
   * Therefore, the method can log the error itself and then choose which
   * response to return.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The request.
   *
   * @return \Symfony\Component\HttpFoundation\Response|null
   *   The response, or NULL to return an empty HTTP 200 response.
   */
  public function onNotify(Request $request);

}
