<?php

/*
 * This file is part of the Sonata Project package.
 *
 * (c) Thomas Rabaix <thomas.rabaix@sonata-project.org>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Sonata\CoreBundle\Color;

/**
 * Handles A list of all HTML colors.
 *
 * @see http://www.w3schools.com/HTML/html_colornames.asp
 *
 * @author Quentin Somazzi <qsomazzi@ekino.com>
 */
class Colors
{
    const ALICEBLUE = '#F0F8FF';
    const ANTIQUEWHITE = '#FAEBD7';
    const AQUA = '#00FFFF';
    const AQUAMARINE = '#7FFFD4';
    const AZURE = '#F0FFFF';
    const BEIGE = '#F5F5DC';
    const BISQUE = '#FFE4C4';
    const BLACK = '#000000';
    const BLANCHEDALMOND = '#FFEBCD';
    const BLUE = '#0000FF';
    const BLUEVIOLET = '#8A2BE2';
    const BROWN = '#A52A2A';
    const BURLYWOOD = '#DEB887';
    const CADETBLUE = '#5F9EA0';
    const CHARTREUSE = '#7FFF00';
    const CHOCOLATE = '#D2691E';
    const CORAL = '#FF7F50';
    const CORNFLOWERBLUE = '#6495ED';
    const CORNSILK = '#FFF8DC';
    const CRIMSON = '#DC143C';
    const CYAN = '#00FFFF';
    const DARKBLUE = '#00008B';
    const DARKCYAN = '#008B8B';
    const DARKGOLDENROD = '#B8860B';
    const DARKGRAY = '#A9A9A9';
    const DARKGREEN = '#006400';
    const DARKKHAKI = '#BDB76B';
    const DARKMAGENTA = '#8B008B';
    const DARKOLIVEGREEN = '#556B2F';
    const DARKORANGE = '#FF8C00';
    const DARKORCHID = '#9932CC';
    const DARKRED = '#8B0000';
    const DARKSALMON = '#E9967A';
    const DARKSEAGREEN = '#8FBC8F';
    const DARKSLATEBLUE = '#483D8B';
    const DARKSLATEGRAY = '#2F4F4F';
    const DARKTURQUOISE = '#00CED1';
    const DARKVIOLET = '#9400D3';
    const DEEPPINK = '#FF1493';
    const DEEPSKYBLUE = '#00BFFF';
    const DIMGRAY = '#696969';
    const DODGERBLUE = '#1E90FF';
    const FIREBRICK = '#B22222';
    const FLORALWHITE = '#FFFAF0';
    const FORESTGREEN = '#228B22';
    const FUCHSIA = '#FF00FF';
    const GAINSBORO = '#DCDCDC';
    const GHOSTWHITE = '#F8F8FF';
    const GOLD = '#FFD700';
    const GOLDENROD = '#DAA520';
    const GRAY = '#808080';
    const GREEN = '#008000';
    const GREENYELLOW = '#ADFF2F';
    const HONEYDEW = '#F0FFF0';
    const HOTPINK = '#FF69B4';
    const INDIANRED = '#CD5C5C';
    const INDIGO = '#4B0082';
    const IVORY = '#FFFFF0';
    const KHAKI = '#F0E68C';
    const LAVENDER = '#E6E6FA';
    const LAVENDERBLUSH = '#FFF0F5';
    const LAWNGREEN = '#7CFC00';
    const LEMONCHIFFON = '#FFFACD';
    const LIGHTBLUE = '#ADD8E6';
    const LIGHTCORAL = '#F08080';
    const LIGHTCYAN = '#E0FFFF';
    const LIGHTGOLDENRODYELLOW = '#FAFAD2';
    const LIGHTGRAY = '#D3D3D3';
    const LIGHTGREEN = '#90EE90';
    const LIGHTPINK = '#FFB6C1';
    const LIGHTSALMON = '#FFA07A';
    const LIGHTSEAGREEN = '#20B2AA';
    const LIGHTSKYBLUE = '#87CEFA';
    const LIGHTSLATEGRAY = '#778899';
    const LIGHTSTEELBLUE = '#B0C4DE';
    const LIGHTYELLOW = '#FFFFE0';
    const LIME = '#00FF00';
    const LIMEGREEN = '#32CD32';
    const LINEN = '#FAF0E6';
    const MAGENTA = '#FF00FF';
    const MAROON = '#800000';
    const MEDIUMAQUAMARINE = '#66CDAA';
    const MEDIUMBLUE = '#0000CD';
    const MEDIUMORCHID = '#BA55D3';
    const MEDIUMPURPLE = '#9370DB';
    const MEDIUMSEAGREEN = '#3CB371';
    const MEDIUMSLATEBLUE = '#7B68EE';
    const MEDIUMSPRINGGREEN = '#00FA9A';
    const MEDIUMTURQUOISE = '#48D1CC';
    const MEDIUMVIOLETRED = '#C71585';
    const MIDNIGHTBLUE = '#191970';
    const MINTCREAM = '#F5FFFA';
    const MISTYROSE = '#FFE4E1';
    const MOCCASIN = '#FFE4B5';
    const NAVAJOWHITE = '#FFDEAD';
    const NAVY = '#000080';
    const OLDLACE = '#FDF5E6';
    const OLIVE = '#808000';
    const OLIVEDRAB = '#6B8E23';
    const ORANGE = '#FFA500';
    const ORANGERED = '#FF4500';
    const ORCHID = '#DA70D6';
    const PALEGOLDENROD = '#EEE8AA';
    const PALEGREEN = '#98FB98';
    const PALETURQUOISE = '#AFEEEE';
    const PALEVIOLETRED = '#DB7093';
    const PAPAYAWHIP = '#FFEFD5';
    const PEACHPUFF = '#FFDAB9';
    const PERU = '#CD853F';
    const PINK = '#FFC0CB';
    const PLUM = '#DDA0DD';
    const POWDERBLUE = '#B0E0E6';
    const PURPLE = '#800080';
    const REBECCAPURPLE = '#663399';
    const RED = '#FF0000';
    const ROSYBROWN = '#BC8F8F';
    const ROYALBLUE = '#4169E1';
    const SADDLEBROWN = '#8B4513';
    const SALMON = '#FA8072';
    const SANDYBROWN = '#F4A460';
    const SEAGREEN = '#2E8B57';
    const SEASHELL = '#FFF5EE';
    const SIENNA = '#A0522D';
    const SILVER = '#C0C0C0';
    const SKYBLUE = '#87CEEB';
    const SLATEBLUE = '#6A5ACD';
    const SLATEGRAY = '#708090';
    const SNOW = '#FFFAFA';
    const SPRINGGREEN = '#00FF7F';
    const STEELBLUE = '#4682B4';
    const TAN = '#D2B48C';
    const TEAL = '#008080';
    const THISTLE = '#D8BFD8';
    const TOMATO = '#FF6347';
    const TURQUOISE = '#40E0D0';
    const VIOLET = '#EE82EE';
    const WHEAT = '#F5DEB3';
    const WHITE = '#FFFFFF';
    const WHITESMOKE = '#F5F5F5';
    const YELLOW = '#FFFF00';
    const YELLOWGREEN = '#9ACD32';

    /**
     * Return the list of colors.
     *
     * @return array
     */
    public static function getAll()
    {
        return array(
            self::ALICEBLUE => 'aliceblue',
            self::ANTIQUEWHITE => 'antiquewhite',
            self::AQUA => 'aqua',
            self::AQUAMARINE => 'aquamarine',
            self::AZURE => 'azure',
            self::BEIGE => 'beige',
            self::BISQUE => 'bisque',
            self::BLACK => 'black',
            self::BLANCHEDALMOND => 'blanchedalmond',
            self::BLUE => 'blue',
            self::BLUEVIOLET => 'blueviolet',
            self::BROWN => 'brown',
            self::BURLYWOOD => 'burlywood',
            self::CADETBLUE => 'cadetblue',
            self::CHARTREUSE => 'chartreuse',
            self::CHOCOLATE => 'chocolate',
            self::CORAL => 'coral',
            self::CORNFLOWERBLUE => 'cornflowerblue',
            self::CORNSILK => 'cornsilk',
            self::CRIMSON => 'crimson',
            self::CYAN => 'cyan',
            self::DARKBLUE => 'darkblue',
            self::DARKCYAN => 'darkcyan',
            self::DARKGOLDENROD => 'darkgoldenrod',
            self::DARKGRAY => 'darkgray',
            self::DARKGREEN => 'darkgreen',
            self::DARKKHAKI => 'darkkhaki',
            self::DARKMAGENTA => 'darkmagenta',
            self::DARKOLIVEGREEN => 'darkolivegreen',
            self::DARKORANGE => 'darkorange',
            self::DARKORCHID => 'darkorchid',
            self::DARKRED => 'darkred',
            self::DARKSALMON => 'darksalmon',
            self::DARKSEAGREEN => 'darkseagreen',
            self::DARKSLATEBLUE => 'darkslateblue',
            self::DARKSLATEGRAY => 'darkslategray',
            self::DARKTURQUOISE => 'darkturquoise',
            self::DARKVIOLET => 'darkviolet',
            self::DEEPPINK => 'deeppink',
            self::DEEPSKYBLUE => 'deepskyblue',
            self::DIMGRAY => 'dimgray',
            self::DODGERBLUE => 'dodgerblue',
            self::FIREBRICK => 'firebrick',
            self::FLORALWHITE => 'floralwhite',
            self::FORESTGREEN => 'forestgreen',
            self::FUCHSIA => 'fuchsia',
            self::GAINSBORO => 'gainsboro',
            self::GHOSTWHITE => 'ghostwhite',
            self::GOLD => 'gold',
            self::GOLDENROD => 'goldenrod',
            self::GRAY => 'gray',
            self::GREEN => 'green',
            self::GREENYELLOW => 'greenyellow',
            self::HONEYDEW => 'honeydew',
            self::HOTPINK => 'hotpink',
            self::INDIANRED => 'indianred',
            self::INDIGO => 'indigo',
            self::IVORY => 'ivory',
            self::KHAKI => 'khaki',
            self::LAVENDER => 'lavender',
            self::LAVENDERBLUSH => 'lavenderblush',
            self::LAWNGREEN => 'lawngreen',
            self::LEMONCHIFFON => 'lemonchiffon',
            self::LIGHTBLUE => 'lightblue',
            self::LIGHTCORAL => 'lightcoral',
            self::LIGHTCYAN => 'lightcyan',
            self::LIGHTGOLDENRODYELLOW => 'lightgoldenrodyellow',
            self::LIGHTGRAY => 'lightgray',
            self::LIGHTGREEN => 'lightgreen',
            self::LIGHTPINK => 'lightpink',
            self::LIGHTSALMON => 'lightsalmon',
            self::LIGHTSEAGREEN => 'lightseagreen',
            self::LIGHTSKYBLUE => 'lightskyblue',
            self::LIGHTSLATEGRAY => 'lightslategray',
            self::LIGHTSTEELBLUE => 'lightsteelblue',
            self::LIGHTYELLOW => 'lightyellow',
            self::LIME => 'lime',
            self::LIMEGREEN => 'limegreen',
            self::LINEN => 'linen',
            self::MAGENTA => 'magenta',
            self::MAROON => 'maroon',
            self::MEDIUMAQUAMARINE => 'mediumaquamarine',
            self::MEDIUMBLUE => 'mediumblue',
            self::MEDIUMORCHID => 'mediumorchid',
            self::MEDIUMPURPLE => 'mediumpurple',
            self::MEDIUMSEAGREEN => 'mediumseagreen',
            self::MEDIUMSLATEBLUE => 'mediumslateblue',
            self::MEDIUMSPRINGGREEN => 'mediumspringgreen',
            self::MEDIUMTURQUOISE => 'mediumturquoise',
            self::MEDIUMVIOLETRED => 'mediumvioletred',
            self::MIDNIGHTBLUE => 'midnightblue',
            self::MINTCREAM => 'mintcream',
            self::MISTYROSE => 'mistyrose',
            self::MOCCASIN => 'moccasin',
            self::NAVAJOWHITE => 'navajowhite',
            self::NAVY => 'navy',
            self::OLDLACE => 'oldlace',
            self::OLIVE => 'olive',
            self::OLIVEDRAB => 'olivedrab',
            self::ORANGE => 'orange',
            self::ORANGERED => 'orangered',
            self::ORCHID => 'orchid',
            self::PALEGOLDENROD => 'palegoldenrod',
            self::PALEGREEN => 'palegreen',
            self::PALETURQUOISE => 'paleturquoise',
            self::PALEVIOLETRED => 'palevioletred',
            self::PAPAYAWHIP => 'papayawhip',
            self::PEACHPUFF => 'peachpuff',
            self::PERU => 'peru',
            self::PINK => 'pink',
            self::PLUM => 'plum',
            self::POWDERBLUE => 'powderblue',
            self::PURPLE => 'purple',
            self::REBECCAPURPLE => 'rebeccapurple',
            self::RED => 'red',
            self::ROSYBROWN => 'rosybrown',
            self::ROYALBLUE => 'royalblue',
            self::SADDLEBROWN => 'saddlebrown',
            self::SALMON => 'salmon',
            self::SANDYBROWN => 'sandybrown',
            self::SEAGREEN => 'seagreen',
            self::SEASHELL => 'seashell',
            self::SIENNA => 'sienna',
            self::SILVER => 'silver',
            self::SKYBLUE => 'skyblue',
            self::SLATEBLUE => 'slateblue',
            self::SLATEGRAY => 'slategray',
            self::SNOW => 'snow',
            self::SPRINGGREEN => 'springgreen',
            self::STEELBLUE => 'steelblue',
            self::TAN => 'tan',
            self::TEAL => 'teal',
            self::THISTLE => 'thistle',
            self::TOMATO => 'tomato',
            self::TURQUOISE => 'turquoise',
            self::VIOLET => 'violet',
            self::WHEAT => 'wheat',
            self::WHITE => 'white',
            self::WHITESMOKE => 'whitesmoke',
            self::YELLOW => 'yellow',
            self::YELLOWGREEN => 'yellowgreen',
        );
    }
}
