<?php
namespace Emojione;
class Emojione {
    static $ascii = false; // convert ascii smileys?
    static $unicodeAlt = true; // use the unicode char as the alt attribute (makes copy and pasting the resulting text better)
    static $imageType = 'png';
    static $cacheBustParam = '?v=1.2.4';
    static $sprites = false;
    static $imagePathPNG = '//cdn.jsdelivr.net/emojione/assets/png/';
    static $imagePathSVG = '//cdn.jsdelivr.net/emojione/assets/svg/';
    static $imagePathSVGSprites = './../../assets/sprites/emojione.sprites.svg';
    static $unicode_replaceWith = false;
    static $ignoredRegexp = '<object[^>]*>.*?<\/object>|<span[^>]*>.*?<\/span>|<(?:object|embed|svg|img|div|span|p|a)[^>]*>';
    static $unicodeRegexp = '([#0-9](?>\\xEF\\xB8\\x8F)?\\xE2\\x83\\xA3|\\xC2[\\xA9\\xAE]|\\xE2..(?>\\xEF\\xB8\\x8F)?|\\xE3(?>\\x80[\\xB0\\xBD]|\\x8A[\\x97\\x99])(?>\\xEF\\xB8\\x8F)?|\\xF0\\x9F(?>[\\x80-\\x86].(?>\\xEF\\xB8\\x8F)?|\\x87.\\xF0\\x9F\\x87.|..))';
    static $shortcodeRegexp = ':([-+\\w]+):';

    static $shortcode_replace = Array(
        ':hash:' => '0023-20e3',
        ':zero:' => '0030-20e3',
        ':one:' => '0031-20e3',
        ':two:' => '0032-20e3',
        ':three:' => '0033-20e3',
        ':four:' => '0034-20e3',
        ':five:' => '0035-20e3',
        ':six:' => '0036-20e3',
        ':seven:' => '0037-20e3',
        ':eight:' => '0038-20e3',
        ':nine:' => '0039-20e3',
        ':copyright:' => '00a9',
        ':registered:' => '00ae',
        ':bangbang:' => '203c',
        ':interrobang:' => '2049',
        ':tm:' => '2122',
        ':information_source:' => '2139',
        ':left_right_arrow:' => '2194',
        ':arrow_up_down:' => '2195',
        ':arrow_upper_left:' => '2196',
        ':arrow_upper_right:' => '2197',
        ':arrow_lower_right:' => '2198',
        ':arrow_lower_left:' => '2199',
        ':leftwards_arrow_with_hook:' => '21a9',
        ':arrow_right_hook:' => '21aa',
        ':watch:' => '231a',
        ':hourglass:' => '231b',
        ':fast_forward:' => '23e9',
        ':rewind:' => '23ea',
        ':arrow_double_up:' => '23eb',
        ':arrow_double_down:' => '23ec',
        ':alarm_clock:' => '23f0',
        ':hourglass_flowing_sand:' => '23f3',
        ':m:' => '24c2',
        ':black_small_square:' => '25aa',
        ':white_small_square:' => '25ab',
        ':arrow_forward:' => '25b6',
        ':arrow_backward:' => '25c0',
        ':white_medium_square:' => '25fb',
        ':black_medium_square:' => '25fc',
        ':white_medium_small_square:' => '25fd',
        ':black_medium_small_square:' => '25fe',
        ':sunny:' => '2600',
        ':cloud:' => '2601',
        ':telephone:' => '260e',
        ':ballot_box_with_check:' => '2611',
        ':umbrella:' => '2614',
        ':coffee:' => '2615',
        ':point_up:' => '261d',
        ':relaxed:' => '263a',
        ':aries:' => '2648',
        ':taurus:' => '2649',
        ':gemini:' => '264a',
        ':cancer:' => '264b',
        ':leo:' => '264c',
        ':virgo:' => '264d',
        ':libra:' => '264e',
        ':scorpius:' => '264f',
        ':sagittarius:' => '2650',
        ':capricorn:' => '2651',
        ':aquarius:' => '2652',
        ':pisces:' => '2653',
        ':spades:' => '2660',
        ':clubs:' => '2663',
        ':hearts:' => '2665',
        ':diamonds:' => '2666',
        ':hotsprings:' => '2668',
        ':recycle:' => '267b',
        ':wheelchair:' => '267f',
        ':anchor:' => '2693',
        ':warning:' => '26a0',
        ':zap:' => '26a1',
        ':white_circle:' => '26aa',
        ':black_circle:' => '26ab',
        ':soccer:' => '26bd',
        ':baseball:' => '26be',
        ':snowman:' => '26c4',
        ':partly_sunny:' => '26c5',
        ':ophiuchus:' => '26ce',
        ':no_entry:' => '26d4',
        ':church:' => '26ea',
        ':fountain:' => '26f2',
        ':golf:' => '26f3',
        ':sailboat:' => '26f5',
        ':tent:' => '26fa',
        ':fuelpump:' => '26fd',
        ':scissors:' => '2702',
        ':white_check_mark:' => '2705',
        ':airplane:' => '2708',
        ':envelope:' => '2709',
        ':fist:' => '270a',
        ':raised_hand:' => '270b',
        ':v:' => '270c',
        ':pencil2:' => '270f',
        ':black_nib:' => '2712',
        ':heavy_check_mark:' => '2714',
        ':heavy_multiplication_x:' => '2716',
        ':sparkles:' => '2728',
        ':eight_spoked_asterisk:' => '2733',
        ':eight_pointed_black_star:' => '2734',
        ':snowflake:' => '2744',
        ':sparkle:' => '2747',
        ':x:' => '274c',
        ':negative_squared_cross_mark:' => '274e',
        ':question:' => '2753',
        ':grey_question:' => '2754',
        ':grey_exclamation:' => '2755',
        ':exclamation:' => '2757',
        ':heart:' => '2764',
        ':heavy_plus_sign:' => '2795',
        ':heavy_minus_sign:' => '2796',
        ':heavy_division_sign:' => '2797',
        ':arrow_right:' => '27a1',
        ':curly_loop:' => '27b0',
        ':arrow_heading_up:' => '2934',
        ':arrow_heading_down:' => '2935',
        ':arrow_left:' => '2b05',
        ':arrow_up:' => '2b06',
        ':arrow_down:' => '2b07',
        ':black_large_square:' => '2b1b',
        ':white_large_square:' => '2b1c',
        ':star:' => '2b50',
        ':o:' => '2b55',
        ':wavy_dash:' => '3030',
        ':part_alternation_mark:' => '303d',
        ':congratulations:' => '3297',
        ':secret:' => '3299',
        ':mahjong:' => '1f004',
        ':black_joker:' => '1f0cf',
        ':a:' => '1f170',
        ':b:' => '1f171',
        ':o2:' => '1f17e',
        ':parking:' => '1f17f',
        ':ab:' => '1f18e',
        ':cl:' => '1f191',
        ':cool:' => '1f192',
        ':free:' => '1f193',
        ':id:' => '1f194',
        ':new:' => '1f195',
        ':ng:' => '1f196',
        ':ok:' => '1f197',
        ':sos:' => '1f198',
        ':up:' => '1f199',
        ':vs:' => '1f19a',
        ':cn:' => '1f1e8-1f1f3',
        ':de:' => '1f1e9-1f1ea',
        ':es:' => '1f1ea-1f1f8',
        ':fr:' => '1f1eb-1f1f7',
        ':gb:' => '1f1ec-1f1e7',
        ':it:' => '1f1ee-1f1f9',
        ':jp:' => '1f1ef-1f1f5',
        ':kr:' => '1f1f0-1f1f7',
        ':us:' => '1f1fa-1f1f8',
        ':ru:' => '1f1f7-1f1fa',
        ':koko:' => '1f201',
        ':sa:' => '1f202',
        ':u7121:' => '1f21a',
        ':u6307:' => '1f22f',
        ':u7981:' => '1f232',
        ':u7a7a:' => '1f233',
        ':u5408:' => '1f234',
        ':u6e80:' => '1f235',
        ':u6709:' => '1f236',
        ':u6708:' => '1f237',
        ':u7533:' => '1f238',
        ':u5272:' => '1f239',
        ':u55b6:' => '1f23a',
        ':ideograph_advantage:' => '1f250',
        ':accept:' => '1f251',
        ':cyclone:' => '1f300',
        ':foggy:' => '1f301',
        ':closed_umbrella:' => '1f302',
        ':night_with_stars:' => '1f303',
        ':sunrise_over_mountains:' => '1f304',
        ':sunrise:' => '1f305',
        ':city_dusk:' => '1f306',
        ':city_sunset:' => '1f307',
        ':city_sunrise:' => '1f307',
        ':rainbow:' => '1f308',
        ':bridge_at_night:' => '1f309',
        ':ocean:' => '1f30a',
        ':volcano:' => '1f30b',
        ':milky_way:' => '1f30c',
        ':earth_asia:' => '1f30f',
        ':new_moon:' => '1f311',
        ':first_quarter_moon:' => '1f313',
        ':waxing_gibbous_moon:' => '1f314',
        ':full_moon:' => '1f315',
        ':crescent_moon:' => '1f319',
        ':first_quarter_moon_with_face:' => '1f31b',
        ':star2:' => '1f31f',
        ':stars:' => '1f320',
        ':chestnut:' => '1f330',
        ':seedling:' => '1f331',
        ':palm_tree:' => '1f334',
        ':cactus:' => '1f335',
        ':tulip:' => '1f337',
        ':cherry_blossom:' => '1f338',
        ':rose:' => '1f339',
        ':hibiscus:' => '1f33a',
        ':sunflower:' => '1f33b',
        ':blossom:' => '1f33c',
        ':corn:' => '1f33d',
        ':ear_of_rice:' => '1f33e',
        ':herb:' => '1f33f',
        ':four_leaf_clover:' => '1f340',
        ':maple_leaf:' => '1f341',
        ':fallen_leaf:' => '1f342',
        ':leaves:' => '1f343',
        ':mushroom:' => '1f344',
        ':tomato:' => '1f345',
        ':eggplant:' => '1f346',
        ':grapes:' => '1f347',
        ':melon:' => '1f348',
        ':watermelon:' => '1f349',
        ':tangerine:' => '1f34a',
        ':banana:' => '1f34c',
        ':pineapple:' => '1f34d',
        ':apple:' => '1f34e',
        ':green_apple:' => '1f34f',
        ':peach:' => '1f351',
        ':cherries:' => '1f352',
        ':strawberry:' => '1f353',
        ':hamburger:' => '1f354',
        ':pizza:' => '1f355',
        ':meat_on_bone:' => '1f356',
        ':poultry_leg:' => '1f357',
        ':rice_cracker:' => '1f358',
        ':rice_ball:' => '1f359',
        ':rice:' => '1f35a',
        ':curry:' => '1f35b',
        ':ramen:' => '1f35c',
        ':spaghetti:' => '1f35d',
        ':bread:' => '1f35e',
        ':fries:' => '1f35f',
        ':sweet_potato:' => '1f360',
        ':dango:' => '1f361',
        ':oden:' => '1f362',
        ':sushi:' => '1f363',
        ':fried_shrimp:' => '1f364',
        ':fish_cake:' => '1f365',
        ':icecream:' => '1f366',
        ':shaved_ice:' => '1f367',
        ':ice_cream:' => '1f368',
        ':doughnut:' => '1f369',
        ':cookie:' => '1f36a',
        ':chocolate_bar:' => '1f36b',
        ':candy:' => '1f36c',
        ':lollipop:' => '1f36d',
        ':custard:' => '1f36e',
        ':honey_pot:' => '1f36f',
        ':cake:' => '1f370',
        ':bento:' => '1f371',
        ':stew:' => '1f372',
        ':egg:' => '1f373',
        ':fork_and_knife:' => '1f374',
        ':tea:' => '1f375',
        ':sake:' => '1f376',
        ':wine_glass:' => '1f377',
        ':cocktail:' => '1f378',
        ':tropical_drink:' => '1f379',
        ':beer:' => '1f37a',
        ':beers:' => '1f37b',
        ':ribbon:' => '1f380',
        ':gift:' => '1f381',
        ':birthday:' => '1f382',
        ':jack_o_lantern:' => '1f383',
        ':christmas_tree:' => '1f384',
        ':santa:' => '1f385',
        ':fireworks:' => '1f386',
        ':sparkler:' => '1f387',
        ':balloon:' => '1f388',
        ':tada:' => '1f389',
        ':confetti_ball:' => '1f38a',
        ':tanabata_tree:' => '1f38b',
        ':crossed_flags:' => '1f38c',
        ':bamboo:' => '1f38d',
        ':dolls:' => '1f38e',
        ':flags:' => '1f38f',
        ':wind_chime:' => '1f390',
        ':rice_scene:' => '1f391',
        ':school_satchel:' => '1f392',
        ':mortar_board:' => '1f393',
        ':carousel_horse:' => '1f3a0',
        ':ferris_wheel:' => '1f3a1',
        ':roller_coaster:' => '1f3a2',
        ':fishing_pole_and_fish:' => '1f3a3',
        ':microphone:' => '1f3a4',
        ':movie_camera:' => '1f3a5',
        ':cinema:' => '1f3a6',
        ':headphones:' => '1f3a7',
        ':art:' => '1f3a8',
        ':tophat:' => '1f3a9',
        ':circus_tent:' => '1f3aa',
        ':ticket:' => '1f3ab',
        ':clapper:' => '1f3ac',
        ':performing_arts:' => '1f3ad',
        ':video_game:' => '1f3ae',
        ':dart:' => '1f3af',
        ':slot_machine:' => '1f3b0',
        ':8ball:' => '1f3b1',
        ':game_die:' => '1f3b2',
        ':bowling:' => '1f3b3',
        ':flower_playing_cards:' => '1f3b4',
        ':musical_note:' => '1f3b5',
        ':notes:' => '1f3b6',
        ':saxophone:' => '1f3b7',
        ':guitar:' => '1f3b8',
        ':musical_keyboard:' => '1f3b9',
        ':trumpet:' => '1f3ba',
        ':violin:' => '1f3bb',
        ':musical_score:' => '1f3bc',
        ':running_shirt_with_sash:' => '1f3bd',
        ':tennis:' => '1f3be',
        ':ski:' => '1f3bf',
        ':basketball:' => '1f3c0',
        ':checkered_flag:' => '1f3c1',
        ':snowboarder:' => '1f3c2',
        ':runner:' => '1f3c3',
        ':surfer:' => '1f3c4',
        ':trophy:' => '1f3c6',
        ':football:' => '1f3c8',
        ':swimmer:' => '1f3ca',
        ':house:' => '1f3e0',
        ':house_with_garden:' => '1f3e1',
        ':office:' => '1f3e2',
        ':post_office:' => '1f3e3',
        ':hospital:' => '1f3e5',
        ':bank:' => '1f3e6',
        ':atm:' => '1f3e7',
        ':hotel:' => '1f3e8',
        ':love_hotel:' => '1f3e9',
        ':convenience_store:' => '1f3ea',
        ':school:' => '1f3eb',
        ':department_store:' => '1f3ec',
        ':factory:' => '1f3ed',
        ':izakaya_lantern:' => '1f3ee',
        ':japanese_castle:' => '1f3ef',
        ':european_castle:' => '1f3f0',
        ':snail:' => '1f40c',
        ':snake:' => '1f40d',
        ':racehorse:' => '1f40e',
        ':sheep:' => '1f411',
        ':monkey:' => '1f412',
        ':chicken:' => '1f414',
        ':boar:' => '1f417',
        ':elephant:' => '1f418',
        ':octopus:' => '1f419',
        ':shell:' => '1f41a',
        ':bug:' => '1f41b',
        ':ant:' => '1f41c',
        ':bee:' => '1f41d',
        ':beetle:' => '1f41e',
        ':fish:' => '1f41f',
        ':tropical_fish:' => '1f420',
        ':blowfish:' => '1f421',
        ':turtle:' => '1f422',
        ':hatching_chick:' => '1f423',
        ':baby_chick:' => '1f424',
        ':hatched_chick:' => '1f425',
        ':bird:' => '1f426',
        ':penguin:' => '1f427',
        ':koala:' => '1f428',
        ':poodle:' => '1f429',
        ':camel:' => '1f42b',
        ':dolphin:' => '1f42c',
        ':mouse:' => '1f42d',
        ':cow:' => '1f42e',
        ':tiger:' => '1f42f',
        ':rabbit:' => '1f430',
        ':cat:' => '1f431',
        ':dragon_face:' => '1f432',
        ':whale:' => '1f433',
        ':horse:' => '1f434',
        ':monkey_face:' => '1f435',
        ':dog:' => '1f436',
        ':pig:' => '1f437',
        ':frog:' => '1f438',
        ':hamster:' => '1f439',
        ':wolf:' => '1f43a',
        ':bear:' => '1f43b',
        ':panda_face:' => '1f43c',
        ':pig_nose:' => '1f43d',
        ':feet:' => '1f43e',
        ':eyes:' => '1f440',
        ':ear:' => '1f442',
        ':nose:' => '1f443',
        ':lips:' => '1f444',
        ':tongue:' => '1f445',
        ':point_up_2:' => '1f446',
        ':point_down:' => '1f447',
        ':point_left:' => '1f448',
        ':point_right:' => '1f449',
        ':punch:' => '1f44a',
        ':wave:' => '1f44b',
        ':ok_hand:' => '1f44c',
        ':thumbsup:' => '1f44d',
        ':+1:' => '1f44d',
        ':thumbsdown:' => '1f44e',
        ':-1:' => '1f44e',
        ':clap:' => '1f44f',
        ':open_hands:' => '1f450',
        ':crown:' => '1f451',
        ':womans_hat:' => '1f452',
        ':eyeglasses:' => '1f453',
        ':necktie:' => '1f454',
        ':shirt:' => '1f455',
        ':jeans:' => '1f456',
        ':dress:' => '1f457',
        ':kimono:' => '1f458',
        ':bikini:' => '1f459',
        ':womans_clothes:' => '1f45a',
        ':purse:' => '1f45b',
        ':handbag:' => '1f45c',
        ':pouch:' => '1f45d',
        ':mans_shoe:' => '1f45e',
        ':athletic_shoe:' => '1f45f',
        ':high_heel:' => '1f460',
        ':sandal:' => '1f461',
        ':boot:' => '1f462',
        ':footprints:' => '1f463',
        ':bust_in_silhouette:' => '1f464',
        ':boy:' => '1f466',
        ':girl:' => '1f467',
        ':man:' => '1f468',
        ':woman:' => '1f469',
        ':family:' => '1f46a',
        ':couple:' => '1f46b',
        ':cop:' => '1f46e',
        ':dancers:' => '1f46f',
        ':bride_with_veil:' => '1f470',
        ':person_with_blond_hair:' => '1f471',
        ':man_with_gua_pi_mao:' => '1f472',
        ':man_with_turban:' => '1f473',
        ':older_man:' => '1f474',
        ':older_woman:' => '1f475',
        ':grandma:' => '1f475',
        ':baby:' => '1f476',
        ':construction_worker:' => '1f477',
        ':princess:' => '1f478',
        ':japanese_ogre:' => '1f479',
        ':japanese_goblin:' => '1f47a',
        ':ghost:' => '1f47b',
        ':angel:' => '1f47c',
        ':alien:' => '1f47d',
        ':space_invader:' => '1f47e',
        ':imp:' => '1f47f',
        ':skull:' => '1f480',
        ':skeleton:' => '1f480',
        ':card_index:' => '1f4c7',
        ':information_desk_person:' => '1f481',
        ':guardsman:' => '1f482',
        ':dancer:' => '1f483',
        ':lipstick:' => '1f484',
        ':nail_care:' => '1f485',
        ':ledger:' => '1f4d2',
        ':massage:' => '1f486',
        ':notebook:' => '1f4d3',
        ':haircut:' => '1f487',
        ':notebook_with_decorative_cover:' => '1f4d4',
        ':barber:' => '1f488',
        ':closed_book:' => '1f4d5',
        ':syringe:' => '1f489',
        ':book:' => '1f4d6',
        ':pill:' => '1f48a',
        ':green_book:' => '1f4d7',
        ':kiss:' => '1f48b',
        ':blue_book:' => '1f4d8',
        ':love_letter:' => '1f48c',
        ':orange_book:' => '1f4d9',
        ':ring:' => '1f48d',
        ':books:' => '1f4da',
        ':gem:' => '1f48e',
        ':name_badge:' => '1f4db',
        ':couplekiss:' => '1f48f',
        ':scroll:' => '1f4dc',
        ':bouquet:' => '1f490',
        ':pencil:' => '1f4dd',
        ':couple_with_heart:' => '1f491',
        ':telephone_receiver:' => '1f4de',
        ':wedding:' => '1f492',
        ':pager:' => '1f4df',
        ':fax:' => '1f4e0',
        ':heartbeat:' => '1f493',
        ':satellite:' => '1f4e1',
        ':loudspeaker:' => '1f4e2',
        ':broken_heart:' => '1f494',
        ':mega:' => '1f4e3',
        ':outbox_tray:' => '1f4e4',
        ':two_hearts:' => '1f495',
        ':inbox_tray:' => '1f4e5',
        ':package:' => '1f4e6',
        ':sparkling_heart:' => '1f496',
        ':e-mail:' => '1f4e7',
        ':email:' => '1f4e7',
        ':incoming_envelope:' => '1f4e8',
        ':heartpulse:' => '1f497',
        ':envelope_with_arrow:' => '1f4e9',
        ':mailbox_closed:' => '1f4ea',
        ':cupid:' => '1f498',
        ':mailbox:' => '1f4eb',
        ':postbox:' => '1f4ee',
        ':blue_heart:' => '1f499',
        ':newspaper:' => '1f4f0',
        ':iphone:' => '1f4f1',
        ':green_heart:' => '1f49a',
        ':calling:' => '1f4f2',
        ':vibration_mode:' => '1f4f3',
        ':yellow_heart:' => '1f49b',
        ':mobile_phone_off:' => '1f4f4',
        ':signal_strength:' => '1f4f6',
        ':purple_heart:' => '1f49c',
        ':camera:' => '1f4f7',
        ':video_camera:' => '1f4f9',
        ':gift_heart:' => '1f49d',
        ':tv:' => '1f4fa',
        ':radio:' => '1f4fb',
        ':revolving_hearts:' => '1f49e',
        ':vhs:' => '1f4fc',
        ':arrows_clockwise:' => '1f503',
        ':heart_decoration:' => '1f49f',
        ':loud_sound:' => '1f50a',
        ':battery:' => '1f50b',
        ':diamond_shape_with_a_dot_inside:' => '1f4a0',
        ':electric_plug:' => '1f50c',
        ':mag:' => '1f50d',
        ':bulb:' => '1f4a1',
        ':mag_right:' => '1f50e',
        ':lock_with_ink_pen:' => '1f50f',
        ':anger:' => '1f4a2',
        ':closed_lock_with_key:' => '1f510',
        ':key:' => '1f511',
        ':bomb:' => '1f4a3',
        ':lock:' => '1f512',
        ':unlock:' => '1f513',
        ':zzz:' => '1f4a4',
        ':bell:' => '1f514',
        ':bookmark:' => '1f516',
        ':boom:' => '1f4a5',
        ':link:' => '1f517',
        ':radio_button:' => '1f518',
        ':sweat_drops:' => '1f4a6',
        ':back:' => '1f519',
        ':end:' => '1f51a',
        ':droplet:' => '1f4a7',
        ':on:' => '1f51b',
        ':soon:' => '1f51c',
        ':dash:' => '1f4a8',
        ':top:' => '1f51d',
        ':underage:' => '1f51e',
        ':poop:' => '1f4a9',
        ':shit:' => '1f4a9',
        ':hankey:' => '1f4a9',
        ':poo:' => '1f4a9',
        ':keycap_ten:' => '1f51f',
        ':muscle:' => '1f4aa',
        ':capital_abcd:' => '1f520',
        ':abcd:' => '1f521',
        ':dizzy:' => '1f4ab',
        ':1234:' => '1f522',
        ':symbols:' => '1f523',
        ':speech_balloon:' => '1f4ac',
        ':abc:' => '1f524',
        ':fire:' => '1f525',
        ':flame:' => '1f525',
        ':white_flower:' => '1f4ae',
        ':flashlight:' => '1f526',
        ':wrench:' => '1f527',
        ':100:' => '1f4af',
        ':hammer:' => '1f528',
        ':nut_and_bolt:' => '1f529',
        ':moneybag:' => '1f4b0',
        ':knife:' => '1f52a',
        ':gun:' => '1f52b',
        ':currency_exchange:' => '1f4b1',
        ':crystal_ball:' => '1f52e',
        ':heavy_dollar_sign:' => '1f4b2',
        ':six_pointed_star:' => '1f52f',
        ':credit_card:' => '1f4b3',
        ':beginner:' => '1f530',
        ':trident:' => '1f531',
        ':yen:' => '1f4b4',
        ':black_square_button:' => '1f532',
        ':white_square_button:' => '1f533',
        ':dollar:' => '1f4b5',
        ':red_circle:' => '1f534',
        ':large_blue_circle:' => '1f535',
        ':money_with_wings:' => '1f4b8',
        ':large_orange_diamond:' => '1f536',
        ':large_blue_diamond:' => '1f537',
        ':chart:' => '1f4b9',
        ':small_orange_diamond:' => '1f538',
        ':small_blue_diamond:' => '1f539',
        ':seat:' => '1f4ba',
        ':small_red_triangle:' => '1f53a',
        ':small_red_triangle_down:' => '1f53b',
        ':computer:' => '1f4bb',
        ':arrow_up_small:' => '1f53c',
        ':briefcase:' => '1f4bc',
        ':arrow_down_small:' => '1f53d',
        ':clock1:' => '1f550',
        ':minidisc:' => '1f4bd',
        ':clock2:' => '1f551',
        ':floppy_disk:' => '1f4be',
        ':clock3:' => '1f552',
        ':cd:' => '1f4bf',
        ':clock4:' => '1f553',
        ':dvd:' => '1f4c0',
        ':clock5:' => '1f554',
        ':clock6:' => '1f555',
        ':file_folder:' => '1f4c1',
        ':clock7:' => '1f556',
        ':clock8:' => '1f557',
        ':open_file_folder:' => '1f4c2',
        ':clock9:' => '1f558',
        ':clock10:' => '1f559',
        ':page_with_curl:' => '1f4c3',
        ':clock11:' => '1f55a',
        ':clock12:' => '1f55b',
        ':page_facing_up:' => '1f4c4',
        ':mount_fuji:' => '1f5fb',
        ':tokyo_tower:' => '1f5fc',
        ':date:' => '1f4c5',
        ':statue_of_liberty:' => '1f5fd',
        ':japan:' => '1f5fe',
        ':calendar:' => '1f4c6',
        ':moyai:' => '1f5ff',
        ':grin:' => '1f601',
        ':joy:' => '1f602',
        ':smiley:' => '1f603',
        ':chart_with_upwards_trend:' => '1f4c8',
        ':smile:' => '1f604',
        ':sweat_smile:' => '1f605',
        ':chart_with_downwards_trend:' => '1f4c9',
        ':laughing:' => '1f606',
        ':satisfied:' => '1f606',
        ':wink:' => '1f609',
        ':bar_chart:' => '1f4ca',
        ':blush:' => '1f60a',
        ':yum:' => '1f60b',
        ':clipboard:' => '1f4cb',
        ':relieved:' => '1f60c',
        ':heart_eyes:' => '1f60d',
        ':pushpin:' => '1f4cc',
        ':smirk:' => '1f60f',
        ':unamused:' => '1f612',
        ':round_pushpin:' => '1f4cd',
        ':sweat:' => '1f613',
        ':pensive:' => '1f614',
        ':paperclip:' => '1f4ce',
        ':confounded:' => '1f616',
        ':kissing_heart:' => '1f618',
        ':straight_ruler:' => '1f4cf',
        ':kissing_closed_eyes:' => '1f61a',
        ':stuck_out_tongue_winking_eye:' => '1f61c',
        ':triangular_ruler:' => '1f4d0',
        ':stuck_out_tongue_closed_eyes:' => '1f61d',
        ':disappointed:' => '1f61e',
        ':bookmark_tabs:' => '1f4d1',
        ':angry:' => '1f620',
        ':rage:' => '1f621',
        ':cry:' => '1f622',
        ':persevere:' => '1f623',
        ':triumph:' => '1f624',
        ':disappointed_relieved:' => '1f625',
        ':fearful:' => '1f628',
        ':weary:' => '1f629',
        ':sleepy:' => '1f62a',
        ':tired_face:' => '1f62b',
        ':sob:' => '1f62d',
        ':cold_sweat:' => '1f630',
        ':scream:' => '1f631',
        ':astonished:' => '1f632',
        ':flushed:' => '1f633',
        ':dizzy_face:' => '1f635',
        ':mask:' => '1f637',
        ':smile_cat:' => '1f638',
        ':joy_cat:' => '1f639',
        ':smiley_cat:' => '1f63a',
        ':heart_eyes_cat:' => '1f63b',
        ':smirk_cat:' => '1f63c',
        ':kissing_cat:' => '1f63d',
        ':pouting_cat:' => '1f63e',
        ':crying_cat_face:' => '1f63f',
        ':scream_cat:' => '1f640',
        ':no_good:' => '1f645',
        ':ok_woman:' => '1f646',
        ':bow:' => '1f647',
        ':see_no_evil:' => '1f648',
        ':hear_no_evil:' => '1f649',
        ':speak_no_evil:' => '1f64a',
        ':raising_hand:' => '1f64b',
        ':raised_hands:' => '1f64c',
        ':person_frowning:' => '1f64d',
        ':person_with_pouting_face:' => '1f64e',
        ':pray:' => '1f64f',
        ':rocket:' => '1f680',
        ':railway_car:' => '1f683',
        ':bullettrain_side:' => '1f684',
        ':bullettrain_front:' => '1f685',
        ':metro:' => '1f687',
        ':station:' => '1f689',
        ':bus:' => '1f68c',
        ':busstop:' => '1f68f',
        ':ambulance:' => '1f691',
        ':fire_engine:' => '1f692',
        ':police_car:' => '1f693',
        ':taxi:' => '1f695',
        ':red_car:' => '1f697',
        ':blue_car:' => '1f699',
        ':truck:' => '1f69a',
        ':ship:' => '1f6a2',
        ':speedboat:' => '1f6a4',
        ':traffic_light:' => '1f6a5',
        ':construction:' => '1f6a7',
        ':rotating_light:' => '1f6a8',
        ':triangular_flag_on_post:' => '1f6a9',
        ':door:' => '1f6aa',
        ':no_entry_sign:' => '1f6ab',
        ':smoking:' => '1f6ac',
        ':no_smoking:' => '1f6ad',
        ':bike:' => '1f6b2',
        ':walking:' => '1f6b6',
        ':mens:' => '1f6b9',
        ':womens:' => '1f6ba',
        ':restroom:' => '1f6bb',
        ':baby_symbol:' => '1f6bc',
        ':toilet:' => '1f6bd',
        ':wc:' => '1f6be',
        ':bath:' => '1f6c0',
        ':grinning:' => '1f600',
        ':innocent:' => '1f607',
        ':smiling_imp:' => '1f608',
        ':sunglasses:' => '1f60e',
        ':neutral_face:' => '1f610',
        ':expressionless:' => '1f611',
        ':confused:' => '1f615',
        ':kissing:' => '1f617',
        ':kissing_smiling_eyes:' => '1f619',
        ':stuck_out_tongue:' => '1f61b',
        ':worried:' => '1f61f',
        ':frowning:' => '1f626',
        ':anguished:' => '1f626',
        ':anguished:' => '1f627',
        ':grimacing:' => '1f62c',
        ':open_mouth:' => '1f62e',
        ':hushed:' => '1f62f',
        ':sleeping:' => '1f634',
        ':no_mouth:' => '1f636',
        ':helicopter:' => '1f681',
        ':steam_locomotive:' => '1f682',
        ':train2:' => '1f686',
        ':light_rail:' => '1f688',
        ':tram:' => '1f68a',
        ':oncoming_bus:' => '1f68d',
        ':trolleybus:' => '1f68e',
        ':minibus:' => '1f690',
        ':oncoming_police_car:' => '1f694',
        ':oncoming_taxi:' => '1f696',
        ':oncoming_automobile:' => '1f698',
        ':articulated_lorry:' => '1f69b',
        ':tractor:' => '1f69c',
        ':monorail:' => '1f69d',
        ':mountain_railway:' => '1f69e',
        ':suspension_railway:' => '1f69f',
        ':mountain_cableway:' => '1f6a0',
        ':aerial_tramway:' => '1f6a1',
        ':rowboat:' => '1f6a3',
        ':vertical_traffic_light:' => '1f6a6',
        ':put_litter_in_its_place:' => '1f6ae',
        ':do_not_litter:' => '1f6af',
        ':potable_water:' => '1f6b0',
        ':non-potable_water:' => '1f6b1',
        ':no_bicycles:' => '1f6b3',
        ':bicyclist:' => '1f6b4',
        ':mountain_bicyclist:' => '1f6b5',
        ':no_pedestrians:' => '1f6b7',
        ':children_crossing:' => '1f6b8',
        ':shower:' => '1f6bf',
        ':bathtub:' => '1f6c1',
        ':passport_control:' => '1f6c2',
        ':customs:' => '1f6c3',
        ':baggage_claim:' => '1f6c4',
        ':left_luggage:' => '1f6c5',
        ':earth_africa:' => '1f30d',
        ':earth_americas:' => '1f30e',
        ':globe_with_meridians:' => '1f310',
        ':waxing_crescent_moon:' => '1f312',
        ':waning_gibbous_moon:' => '1f316',
        ':last_quarter_moon:' => '1f317',
        ':waning_crescent_moon:' => '1f318',
        ':new_moon_with_face:' => '1f31a',
        ':last_quarter_moon_with_face:' => '1f31c',
        ':full_moon_with_face:' => '1f31d',
        ':sun_with_face:' => '1f31e',
        ':evergreen_tree:' => '1f332',
        ':deciduous_tree:' => '1f333',
        ':lemon:' => '1f34b',
        ':pear:' => '1f350',
        ':baby_bottle:' => '1f37c',
        ':horse_racing:' => '1f3c7',
        ':rugby_football:' => '1f3c9',
        ':european_post_office:' => '1f3e4',
        ':rat:' => '1f400',
        ':mouse2:' => '1f401',
        ':ox:' => '1f402',
        ':water_buffalo:' => '1f403',
        ':cow2:' => '1f404',
        ':tiger2:' => '1f405',
        ':leopard:' => '1f406',
        ':rabbit2:' => '1f407',
        ':cat2:' => '1f408',
        ':dragon:' => '1f409',
        ':crocodile:' => '1f40a',
        ':whale2:' => '1f40b',
        ':ram:' => '1f40f',
        ':goat:' => '1f410',
        ':rooster:' => '1f413',
        ':dog2:' => '1f415',
        ':pig2:' => '1f416',
        ':dromedary_camel:' => '1f42a',
        ':busts_in_silhouette:' => '1f465',
        ':two_men_holding_hands:' => '1f46c',
        ':two_women_holding_hands:' => '1f46d',
        ':thought_balloon:' => '1f4ad',
        ':euro:' => '1f4b6',
        ':pound:' => '1f4b7',
        ':mailbox_with_mail:' => '1f4ec',
        ':mailbox_with_no_mail:' => '1f4ed',
        ':postal_horn:' => '1f4ef',
        ':no_mobile_phones:' => '1f4f5',
        ':twisted_rightwards_arrows:' => '1f500',
        ':repeat:' => '1f501',
        ':repeat_one:' => '1f502',
        ':arrows_counterclockwise:' => '1f504',
        ':low_brightness:' => '1f505',
        ':high_brightness:' => '1f506',
        ':mute:' => '1f507',
        ':sound:' => '1f509',
        ':no_bell:' => '1f515',
        ':microscope:' => '1f52c',
        ':telescope:' => '1f52d',
        ':clock130:' => '1f55c',
        ':clock230:' => '1f55d',
        ':clock330:' => '1f55e',
        ':clock430:' => '1f55f',
        ':clock530:' => '1f560',
        ':clock630:' => '1f561',
        ':clock730:' => '1f562',
        ':clock830:' => '1f563',
        ':clock930:' => '1f564',
        ':clock1030:' => '1f565',
        ':clock1130:' => '1f566',
        ':clock1230:' => '1f567',
        ':speaker:' => '1f508',
        ':train:' => '1f68b',
        ':loop:' => '27bf',
        ':af:' => '1f1e6-1f1eb',
        ':al:' => '1f1e6-1f1f1',
        ':dz:' => '1f1e9-1f1ff',
        ':ad:' => '1f1e6-1f1e9',
        ':ao:' => '1f1e6-1f1f4',
        ':ag:' => '1f1e6-1f1ec',
        ':ar:' => '1f1e6-1f1f7',
        ':am:' => '1f1e6-1f1f2',
        ':au:' => '1f1e6-1f1fa',
        ':at:' => '1f1e6-1f1f9',
        ':az:' => '1f1e6-1f1ff',
        ':bs:' => '1f1e7-1f1f8',
        ':bh:' => '1f1e7-1f1ed',
        ':bd:' => '1f1e7-1f1e9',
        ':bb:' => '1f1e7-1f1e7',
        ':by:' => '1f1e7-1f1fe',
        ':be:' => '1f1e7-1f1ea',
        ':bz:' => '1f1e7-1f1ff',
        ':bj:' => '1f1e7-1f1ef',
        ':bt:' => '1f1e7-1f1f9',
        ':bo:' => '1f1e7-1f1f4',
        ':ba:' => '1f1e7-1f1e6',
        ':bw:' => '1f1e7-1f1fc',
        ':br:' => '1f1e7-1f1f7',
        ':bn:' => '1f1e7-1f1f3',
        ':bg:' => '1f1e7-1f1ec',
        ':bf:' => '1f1e7-1f1eb',
        ':bi:' => '1f1e7-1f1ee',
        ':kh:' => '1f1f0-1f1ed',
        ':cm:' => '1f1e8-1f1f2',
        ':ca:' => '1f1e8-1f1e6',
        ':cv:' => '1f1e8-1f1fb',
        ':cf:' => '1f1e8-1f1eb',
        ':td:' => '1f1f9-1f1e9',
        ':cl:' => '1f1e8-1f1f1',
        ':co:' => '1f1e8-1f1f4',
        ':km:' => '1f1f0-1f1f2',
        ':cr:' => '1f1e8-1f1f7',
        ':ci:' => '1f1e8-1f1ee',
        ':hr:' => '1f1ed-1f1f7',
        ':cu:' => '1f1e8-1f1fa',
        ':cy:' => '1f1e8-1f1fe',
        ':cz:' => '1f1e8-1f1ff',
        ':cd:' => '1f1e8-1f1e9',
        ':dk:' => '1f1e9-1f1f0',
        ':dj:' => '1f1e9-1f1ef',
        ':dm:' => '1f1e9-1f1f2',
        ':do:' => '1f1e9-1f1f4',
        ':tl:' => '1f1f9-1f1f1',
        ':ec:' => '1f1ea-1f1e8',
        ':eg:' => '1f1ea-1f1ec',
        ':sv:' => '1f1f8-1f1fb',
        ':gq:' => '1f1ec-1f1f6',
        ':er:' => '1f1ea-1f1f7',
        ':ee:' => '1f1ea-1f1ea',
        ':et:' => '1f1ea-1f1f9',
        ':fj:' => '1f1eb-1f1ef',
        ':fi:' => '1f1eb-1f1ee',
        ':ga:' => '1f1ec-1f1e6',
        ':gm:' => '1f1ec-1f1f2',
        ':ge:' => '1f1ec-1f1ea',
        ':gh:' => '1f1ec-1f1ed',
        ':gr:' => '1f1ec-1f1f7',
        ':gd:' => '1f1ec-1f1e9',
        ':gt:' => '1f1ec-1f1f9',
        ':gn:' => '1f1ec-1f1f3',
        ':gw:' => '1f1ec-1f1fc',
        ':gy:' => '1f1ec-1f1fe',
        ':ht:' => '1f1ed-1f1f9',
        ':hn:' => '1f1ed-1f1f3',
        ':hu:' => '1f1ed-1f1fa',
        ':is:' => '1f1ee-1f1f8',
        ':in:' => '1f1ee-1f1f3',
        ':id:' => '1f1ee-1f1e9',
        ':ir:' => '1f1ee-1f1f7',
        ':iq:' => '1f1ee-1f1f6',
        ':ie:' => '1f1ee-1f1ea',
        ':il:' => '1f1ee-1f1f1',
        ':jm:' => '1f1ef-1f1f2',
        ':jo:' => '1f1ef-1f1f4',
        ':kz:' => '1f1f0-1f1ff',
        ':ke:' => '1f1f0-1f1ea',
        ':ki:' => '1f1f0-1f1ee',
        ':xk:' => '1f1fd-1f1f0',
        ':kw:' => '1f1f0-1f1fc',
        ':kg:' => '1f1f0-1f1ec',
        ':la:' => '1f1f1-1f1e6',
        ':lv:' => '1f1f1-1f1fb',
        ':lb:' => '1f1f1-1f1e7',
        ':ls:' => '1f1f1-1f1f8',
        ':lr:' => '1f1f1-1f1f7',
        ':ly:' => '1f1f1-1f1fe',
        ':li:' => '1f1f1-1f1ee',
        ':lt:' => '1f1f1-1f1f9',
        ':lu:' => '1f1f1-1f1fa',
        ':mk:' => '1f1f2-1f1f0',
        ':mg:' => '1f1f2-1f1ec',
        ':mw:' => '1f1f2-1f1fc',
        ':my:' => '1f1f2-1f1fe',
        ':mv:' => '1f1f2-1f1fb',
        ':ml:' => '1f1f2-1f1f1',
        ':mt:' => '1f1f2-1f1f9',
        ':mh:' => '1f1f2-1f1ed',
        ':mr:' => '1f1f2-1f1f7',
        ':mu:' => '1f1f2-1f1fa',
        ':mx:' => '1f1f2-1f1fd',
        ':fm:' => '1f1eb-1f1f2',
        ':md:' => '1f1f2-1f1e9',
        ':mc:' => '1f1f2-1f1e8',
        ':mn:' => '1f1f2-1f1f3',
        ':me:' => '1f1f2-1f1ea',
        ':ma:' => '1f1f2-1f1e6',
        ':mz:' => '1f1f2-1f1ff',
        ':mm:' => '1f1f2-1f1f2',
        ':na:' => '1f1f3-1f1e6',
        ':nr:' => '1f1f3-1f1f7',
        ':np:' => '1f1f3-1f1f5',
        ':nl:' => '1f1f3-1f1f1',
        ':nz:' => '1f1f3-1f1ff',
        ':ni:' => '1f1f3-1f1ee',
        ':ne:' => '1f1f3-1f1ea',
        ':ng:' => '1f1f3-1f1ec',
        ':kp:' => '1f1f0-1f1f5',
        ':no:' => '1f1f3-1f1f4',
        ':om:' => '1f1f4-1f1f2',
        ':pk:' => '1f1f5-1f1f0',
        ':pw:' => '1f1f5-1f1fc',
        ':pa:' => '1f1f5-1f1e6',
        ':pg:' => '1f1f5-1f1ec',
        ':py:' => '1f1f5-1f1fe',
        ':pe:' => '1f1f5-1f1ea',
        ':ph:' => '1f1f5-1f1ed',
        ':pl:' => '1f1f5-1f1f1',
        ':pt:' => '1f1f5-1f1f9',
        ':qa:' => '1f1f6-1f1e6',
        ':tw:' => '1f1f9-1f1fc',
        ':cg:' => '1f1e8-1f1ec',
        ':ro:' => '1f1f7-1f1f4',
        ':rw:' => '1f1f7-1f1fc',
        ':kn:' => '1f1f0-1f1f3',
        ':lc:' => '1f1f1-1f1e8',
        ':vc:' => '1f1fb-1f1e8',
        ':ws:' => '1f1fc-1f1f8',
        ':sm:' => '1f1f8-1f1f2',
        ':st:' => '1f1f8-1f1f9',
        ':sa:' => '1f1f8-1f1e6',
        ':sn:' => '1f1f8-1f1f3',
        ':rs:' => '1f1f7-1f1f8',
        ':sc:' => '1f1f8-1f1e8',
        ':sl:' => '1f1f8-1f1f1',
        ':sg:' => '1f1f8-1f1ec',
        ':sk:' => '1f1f8-1f1f0',
        ':si:' => '1f1f8-1f1ee',
        ':sb:' => '1f1f8-1f1e7',
        ':so:' => '1f1f8-1f1f4',
        ':za:' => '1f1ff-1f1e6',
        ':lk:' => '1f1f1-1f1f0',
        ':sd:' => '1f1f8-1f1e9',
        ':sr:' => '1f1f8-1f1f7',
        ':sz:' => '1f1f8-1f1ff',
        ':se:' => '1f1f8-1f1ea',
        ':ch:' => '1f1e8-1f1ed',
        ':sy:' => '1f1f8-1f1fe',
        ':tj:' => '1f1f9-1f1ef',
        ':tz:' => '1f1f9-1f1ff',
        ':th:' => '1f1f9-1f1ed',
        ':tg:' => '1f1f9-1f1ec',
        ':to:' => '1f1f9-1f1f4',
        ':tt:' => '1f1f9-1f1f9',
        ':tn:' => '1f1f9-1f1f3',
        ':tr:' => '1f1f9-1f1f7',
        ':tm:' => '1f1f9-1f1f2',
        ':tv:' => '1f1f9-1f1fb',
        ':ug:' => '1f1fa-1f1ec',
        ':ua:' => '1f1fa-1f1e6',
        ':ae:' => '1f1e6-1f1ea',
        ':uy:' => '1f1fa-1f1fe',
        ':uz:' => '1f1fa-1f1ff',
        ':vu:' => '1f1fb-1f1fa',
        ':va:' => '1f1fb-1f1e6',
        ':ve:' => '1f1fb-1f1ea',
        ':vn:' => '1f1fb-1f1f3',
        ':eh:' => '1f1ea-1f1ed',
        ':ye:' => '1f1fe-1f1ea',
        ':zm:' => '1f1ff-1f1f2',
        ':zw:' => '1f1ff-1f1fc',
        ':pr:' => '1f1f5-1f1f7',
        ':ky:' => '1f1f0-1f1fe',
        ':bm:' => '1f1e7-1f1f2',
        ':pf:' => '1f1f5-1f1eb',
        ':ps:' => '1f1f5-1f1f8',
        ':nc:' => '1f1f3-1f1e8',
        ':sh:' => '1f1f8-1f1ed',
        ':aw:' => '1f1e6-1f1fc',
        ':vi:' => '1f1fb-1f1ee',
        ':hk:' => '1f1ed-1f1f0',
        ':ac:' => '1f1e6-1f1e8',
        ':ms:' => '1f1f2-1f1f8',
        ':gu:' => '1f1ec-1f1fa',
        ':gl:' => '1f1ec-1f1f1',
        ':nu:' => '1f1f3-1f1fa',
        ':wf:' => '1f1fc-1f1eb',
        ':mo:' => '1f1f2-1f1f4',
        ':fo:' => '1f1eb-1f1f4',
        ':fk:' => '1f1eb-1f1f0',
        ':je:' => '1f1ef-1f1ea',
        ':ai:' => '1f1e6-1f1ee',
        ':gi:' => '1f1ec-1f1ee'
    );
    static $ascii_replace = Array(
        '<3' => '2764',
        '</3' => '1f494',
        ':\')' => '1f602',
        ':\'-)' => '1f602',
        ':D' => '1f603',
        ':-D' => '1f603',
        '=D' => '1f603',
        ':)' => '1f604',
        ':-)' => '1f604',
        '=]' => '1f604',
        '=)' => '1f604',
        ':]' => '1f604',
        '\':)' => '1f605',
        '\':-)' => '1f605',
        '\'=)' => '1f605',
        '\':D' => '1f605',
        '\':-D' => '1f605',
        '\'=D' => '1f605',
        '>:)' => '1f606',
        '>;)' => '1f606',
        '>:-)' => '1f606',
        '>=)' => '1f606',
        ';)' => '1f609',
        ';-)' => '1f609',
        '*-)' => '1f609',
        '*)' => '1f609',
        ';-]' => '1f609',
        ';]' => '1f609',
        ';D' => '1f609',
        ';^)' => '1f609',
        '\':(' => '1f613',
        '\':-(' => '1f613',
        '\'=(' => '1f613',
        ':*' => '1f618',
        ':-*' => '1f618',
        '=*' => '1f618',
        ':^*' => '1f618',
        '>:P' => '1f61c',
        'X-P' => '1f61c',
        'x-p' => '1f61c',
        '>:[' => '1f61e',
        ':-(' => '1f61e',
        ':(' => '1f61e',
        ':-[' => '1f61e',
        ':[' => '1f61e',
        '=(' => '1f61e',
        '>:(' => '1f620',
        '>:-(' => '1f620',
        ':@' => '1f620',
        ':\'(' => '1f622',
        ':\'-(' => '1f622',
        ';(' => '1f622',
        ';-(' => '1f622',
        '>.<' => '1f623',
        ':$' => '1f633',
        '=$' => '1f633',
        '#-)' => '1f635',
        '#)' => '1f635',
        '%-)' => '1f635',
        '%)' => '1f635',
        'X)' => '1f635',
        'X-)' => '1f635',
        '*\\0/*' => '1f646',
        '\\0/' => '1f646',
        '*\\O/*' => '1f646',
        '\\O/' => '1f646',
        'O:-)' => '1f607',
        '0:-3' => '1f607',
        '0:3' => '1f607',
        '0:-)' => '1f607',
        '0:)' => '1f607',
        '0;^)' => '1f607',
        'O:-)' => '1f607',
        'O:)' => '1f607',
        'O;-)' => '1f607',
        'O=)' => '1f607',
        '0;-)' => '1f607',
        'O:-3' => '1f607',
        'O:3' => '1f607',
        'B-)' => '1f60e',
        'B)' => '1f60e',
        '8)' => '1f60e',
        '8-)' => '1f60e',
        'B-D' => '1f60e',
        '8-D' => '1f60e',
        '-_-' => '1f611',
        '-__-' => '1f611',
        '-___-' => '1f611',
        '>:\\' => '1f615',
        '>:/' => '1f615',
        ':-/' => '1f615',
        ':-.' => '1f615',
        ':/' => '1f615',
        ':\\' => '1f615',
        '=/' => '1f615',
        '=\\' => '1f615',
        ':L' => '1f615',
        '=L' => '1f615',
        ':P' => '1f61b',
        ':-P' => '1f61b',
        '=P' => '1f61b',
        ':-p' => '1f61b',
        ':p' => '1f61b',
        '=p' => '1f61b',
        ':-Þ' => '1f61b',
        ':Þ' => '1f61b',
        ':þ' => '1f61b',
        ':-þ' => '1f61b',
        ':-b' => '1f61b',
        ':b' => '1f61b',
        'd:' => '1f61b',
        ':-O' => '1f62e',
        ':O' => '1f62e',
        ':-o' => '1f62e',
        ':o' => '1f62e',
        'O_O' => '1f62e',
        '>:O' => '1f62e',
        ':-X' => '1f636',
        ':X' => '1f636',
        ':-#' => '1f636',
        ':#' => '1f636',
        '=X' => '1f636',
        '=x' => '1f636',
        ':x' => '1f636',
        ':-x' => '1f636',
        '=#' => '1f636'
    );
    static $unicode_replace = Array(
        "\x23\xEF\xB8\x8F\xE2\x83\xA3" => ':hash:',
        "\x23\xE2\x83\xA3" => ':hash:',
        "\x30\xEF\xB8\x8F\xE2\x83\xA3" => ':zero:',
        "\x30\xE2\x83\xA3" => ':zero:',
        "\x31\xEF\xB8\x8F\xE2\x83\xA3" => ':one:',
        "\x31\xE2\x83\xA3" => ':one:',
        "\x32\xEF\xB8\x8F\xE2\x83\xA3" => ':two:',
        "\x32\xE2\x83\xA3" => ':two:',
        "\x33\xEF\xB8\x8F\xE2\x83\xA3" => ':three:',
        "\x33\xE2\x83\xA3" => ':three:',
        "\x34\xEF\xB8\x8F\xE2\x83\xA3" => ':four:',
        "\x34\xE2\x83\xA3" => ':four:',
        "\x35\xEF\xB8\x8F\xE2\x83\xA3" => ':five:',
        "\x35\xE2\x83\xA3" => ':five:',
        "\x36\xEF\xB8\x8F\xE2\x83\xA3" => ':six:',
        "\x36\xE2\x83\xA3" => ':six:',
        "\x37\xEF\xB8\x8F\xE2\x83\xA3" => ':seven:',
        "\x37\xE2\x83\xA3" => ':seven:',
        "\x38\xEF\xB8\x8F\xE2\x83\xA3" => ':eight:',
        "\x38\xE2\x83\xA3" => ':eight:',
        "\x39\xEF\xB8\x8F\xE2\x83\xA3" => ':nine:',
        "\x39\xE2\x83\xA3" => ':nine:',
        "\xC2\xA9" => ':copyright:',
        "\xC2\xAE" => ':registered:',
        "\xE2\x80\xBC\xEF\xB8\x8F" => ':bangbang:',
        "\xE2\x80\xBC" => ':bangbang:',
        "\xE2\x81\x89\xEF\xB8\x8F" => ':interrobang:',
        "\xE2\x81\x89" => ':interrobang:',
        "\xE2\x84\xA2" => ':tm:',
        "\xE2\x84\xB9\xEF\xB8\x8F" => ':information_source:',
        "\xE2\x84\xB9" => ':information_source:',
        "\xE2\x86\x94\xEF\xB8\x8F" => ':left_right_arrow:',
        "\xE2\x86\x94" => ':left_right_arrow:',
        "\xE2\x86\x95\xEF\xB8\x8F" => ':arrow_up_down:',
        "\xE2\x86\x95" => ':arrow_up_down:',
        "\xE2\x86\x96\xEF\xB8\x8F" => ':arrow_upper_left:',
        "\xE2\x86\x96" => ':arrow_upper_left:',
        "\xE2\x86\x97\xEF\xB8\x8F" => ':arrow_upper_right:',
        "\xE2\x86\x97" => ':arrow_upper_right:',
        "\xE2\x86\x98\xEF\xB8\x8F" => ':arrow_lower_right:',
        "\xE2\x86\x98" => ':arrow_lower_right:',
        "\xE2\x86\x99\xEF\xB8\x8F" => ':arrow_lower_left:',
        "\xE2\x86\x99" => ':arrow_lower_left:',
        "\xE2\x86\xA9\xEF\xB8\x8F" => ':leftwards_arrow_with_hook:',
        "\xE2\x86\xA9" => ':leftwards_arrow_with_hook:',
        "\xE2\x86\xAA\xEF\xB8\x8F" => ':arrow_right_hook:',
        "\xE2\x86\xAA" => ':arrow_right_hook:',
        "\xE2\x8C\x9A\xEF\xB8\x8F" => ':watch:',
        "\xE2\x8C\x9A" => ':watch:',
        "\xE2\x8C\x9B\xEF\xB8\x8F" => ':hourglass:',
        "\xE2\x8C\x9B" => ':hourglass:',
        "\xE2\x8F\xA9" => ':fast_forward:',
        "\xE2\x8F\xAA" => ':rewind:',
        "\xE2\x8F\xAB" => ':arrow_double_up:',
        "\xE2\x8F\xAC" => ':arrow_double_down:',
        "\xE2\x8F\xB0" => ':alarm_clock:',
        "\xE2\x8F\xB3" => ':hourglass_flowing_sand:',
        "\xE2\x93\x82\xEF\xB8\x8F" => ':m:',
        "\xE2\x93\x82" => ':m:',
        "\xE2\x96\xAA\xEF\xB8\x8F" => ':black_small_square:',
        "\xE2\x96\xAA" => ':black_small_square:',
        "\xE2\x96\xAB\xEF\xB8\x8F" => ':white_small_square:',
        "\xE2\x96\xAB" => ':white_small_square:',
        "\xE2\x96\xB6\xEF\xB8\x8F" => ':arrow_forward:',
        "\xE2\x96\xB6" => ':arrow_forward:',
        "\xE2\x97\x80\xEF\xB8\x8F" => ':arrow_backward:',
        "\xE2\x97\x80" => ':arrow_backward:',
        "\xE2\x97\xBB\xEF\xB8\x8F" => ':white_medium_square:',
        "\xE2\x97\xBB" => ':white_medium_square:',
        "\xE2\x97\xBC\xEF\xB8\x8F" => ':black_medium_square:',
        "\xE2\x97\xBC" => ':black_medium_square:',
        "\xE2\x97\xBD\xEF\xB8\x8F" => ':white_medium_small_square:',
        "\xE2\x97\xBD" => ':white_medium_small_square:',
        "\xE2\x97\xBE\xEF\xB8\x8F" => ':black_medium_small_square:',
        "\xE2\x97\xBE" => ':black_medium_small_square:',
        "\xE2\x98\x80\xEF\xB8\x8F" => ':sunny:',
        "\xE2\x98\x80" => ':sunny:',
        "\xE2\x98\x81\xEF\xB8\x8F" => ':cloud:',
        "\xE2\x98\x81" => ':cloud:',
        "\xE2\x98\x8E\xEF\xB8\x8F" => ':telephone:',
        "\xE2\x98\x8E" => ':telephone:',
        "\xE2\x98\x91\xEF\xB8\x8F" => ':ballot_box_with_check:',
        "\xE2\x98\x91" => ':ballot_box_with_check:',
        "\xE2\x98\x94\xEF\xB8\x8F" => ':umbrella:',
        "\xE2\x98\x94" => ':umbrella:',
        "\xE2\x98\x95\xEF\xB8\x8F" => ':coffee:',
        "\xE2\x98\x95" => ':coffee:',
        "\xE2\x98\x9D\xEF\xB8\x8F" => ':point_up:',
        "\xE2\x98\x9D" => ':point_up:',
        "\xE2\x98\xBA\xEF\xB8\x8F" => ':relaxed:',
        "\xE2\x98\xBA" => ':relaxed:',
        "\xE2\x99\x88\xEF\xB8\x8F" => ':aries:',
        "\xE2\x99\x88" => ':aries:',
        "\xE2\x99\x89\xEF\xB8\x8F" => ':taurus:',
        "\xE2\x99\x89" => ':taurus:',
        "\xE2\x99\x8A\xEF\xB8\x8F" => ':gemini:',
        "\xE2\x99\x8A" => ':gemini:',
        "\xE2\x99\x8B\xEF\xB8\x8F" => ':cancer:',
        "\xE2\x99\x8B" => ':cancer:',
        "\xE2\x99\x8C\xEF\xB8\x8F" => ':leo:',
        "\xE2\x99\x8C" => ':leo:',
        "\xE2\x99\x8D\xEF\xB8\x8F" => ':virgo:',
        "\xE2\x99\x8D" => ':virgo:',
        "\xE2\x99\x8E\xEF\xB8\x8F" => ':libra:',
        "\xE2\x99\x8E" => ':libra:',
        "\xE2\x99\x8F\xEF\xB8\x8F" => ':scorpius:',
        "\xE2\x99\x8F" => ':scorpius:',
        "\xE2\x99\x90\xEF\xB8\x8F" => ':sagittarius:',
        "\xE2\x99\x90" => ':sagittarius:',
        "\xE2\x99\x91\xEF\xB8\x8F" => ':capricorn:',
        "\xE2\x99\x91" => ':capricorn:',
        "\xE2\x99\x92\xEF\xB8\x8F" => ':aquarius:',
        "\xE2\x99\x92" => ':aquarius:',
        "\xE2\x99\x93\xEF\xB8\x8F" => ':pisces:',
        "\xE2\x99\x93" => ':pisces:',
        "\xE2\x99\xA0\xEF\xB8\x8F" => ':spades:',
        "\xE2\x99\xA0" => ':spades:',
        "\xE2\x99\xA3\xEF\xB8\x8F" => ':clubs:',
        "\xE2\x99\xA3" => ':clubs:',
        "\xE2\x99\xA5\xEF\xB8\x8F" => ':hearts:',
        "\xE2\x99\xA5" => ':hearts:',
        "\xE2\x99\xA6\xEF\xB8\x8F" => ':diamonds:',
        "\xE2\x99\xA6" => ':diamonds:',
        "\xE2\x99\xA8\xEF\xB8\x8F" => ':hotsprings:',
        "\xE2\x99\xA8" => ':hotsprings:',
        "\xE2\x99\xBB\xEF\xB8\x8F" => ':recycle:',
        "\xE2\x99\xBB" => ':recycle:',
        "\xE2\x99\xBF\xEF\xB8\x8F" => ':wheelchair:',
        "\xE2\x99\xBF" => ':wheelchair:',
        "\xE2\x9A\x93\xEF\xB8\x8F" => ':anchor:',
        "\xE2\x9A\x93" => ':anchor:',
        "\xE2\x9A\xA0\xEF\xB8\x8F" => ':warning:',
        "\xE2\x9A\xA0" => ':warning:',
        "\xE2\x9A\xA1\xEF\xB8\x8F" => ':zap:',
        "\xE2\x9A\xA1" => ':zap:',
        "\xE2\x9A\xAA\xEF\xB8\x8F" => ':white_circle:',
        "\xE2\x9A\xAA" => ':white_circle:',
        "\xE2\x9A\xAB\xEF\xB8\x8F" => ':black_circle:',
        "\xE2\x9A\xAB" => ':black_circle:',
        "\xE2\x9A\xBD\xEF\xB8\x8F" => ':soccer:',
        "\xE2\x9A\xBD" => ':soccer:',
        "\xE2\x9A\xBE\xEF\xB8\x8F" => ':baseball:',
        "\xE2\x9A\xBE" => ':baseball:',
        "\xE2\x9B\x84\xEF\xB8\x8F" => ':snowman:',
        "\xE2\x9B\x84" => ':snowman:',
        "\xE2\x9B\x85\xEF\xB8\x8F" => ':partly_sunny:',
        "\xE2\x9B\x85" => ':partly_sunny:',
        "\xE2\x9B\x8E" => ':ophiuchus:',
        "\xE2\x9B\x94\xEF\xB8\x8F" => ':no_entry:',
        "\xE2\x9B\x94" => ':no_entry:',
        "\xE2\x9B\xAA\xEF\xB8\x8F" => ':church:',
        "\xE2\x9B\xAA" => ':church:',
        "\xE2\x9B\xB2\xEF\xB8\x8F" => ':fountain:',
        "\xE2\x9B\xB2" => ':fountain:',
        "\xE2\x9B\xB3\xEF\xB8\x8F" => ':golf:',
        "\xE2\x9B\xB3" => ':golf:',
        "\xE2\x9B\xB5\xEF\xB8\x8F" => ':sailboat:',
        "\xE2\x9B\xB5" => ':sailboat:',
        "\xE2\x9B\xBA\xEF\xB8\x8F" => ':tent:',
        "\xE2\x9B\xBA" => ':tent:',
        "\xE2\x9B\xBD\xEF\xB8\x8F" => ':fuelpump:',
        "\xE2\x9B\xBD" => ':fuelpump:',
        "\xE2\x9C\x82\xEF\xB8\x8F" => ':scissors:',
        "\xE2\x9C\x82" => ':scissors:',
        "\xE2\x9C\x85" => ':white_check_mark:',
        "\xE2\x9C\x88\xEF\xB8\x8F" => ':airplane:',
        "\xE2\x9C\x88" => ':airplane:',
        "\xE2\x9C\x89\xEF\xB8\x8F" => ':envelope:',
        "\xE2\x9C\x89" => ':envelope:',
        "\xE2\x9C\x8A" => ':fist:',
        "\xE2\x9C\x8B" => ':raised_hand:',
        "\xE2\x9C\x8C\xEF\xB8\x8F" => ':v:',
        "\xE2\x9C\x8C" => ':v:',
        "\xE2\x9C\x8F\xEF\xB8\x8F" => ':pencil2:',
        "\xE2\x9C\x8F" => ':pencil2:',
        "\xE2\x9C\x92\xEF\xB8\x8F" => ':black_nib:',
        "\xE2\x9C\x92" => ':black_nib:',
        "\xE2\x9C\x94\xEF\xB8\x8F" => ':heavy_check_mark:',
        "\xE2\x9C\x94" => ':heavy_check_mark:',
        "\xE2\x9C\x96\xEF\xB8\x8F" => ':heavy_multiplication_x:',
        "\xE2\x9C\x96" => ':heavy_multiplication_x:',
        "\xE2\x9C\xA8" => ':sparkles:',
        "\xE2\x9C\xB3\xEF\xB8\x8F" => ':eight_spoked_asterisk:',
        "\xE2\x9C\xB3" => ':eight_spoked_asterisk:',
        "\xE2\x9C\xB4\xEF\xB8\x8F" => ':eight_pointed_black_star:',
        "\xE2\x9C\xB4" => ':eight_pointed_black_star:',
        "\xE2\x9D\x84\xEF\xB8\x8F" => ':snowflake:',
        "\xE2\x9D\x84" => ':snowflake:',
        "\xE2\x9D\x87\xEF\xB8\x8F" => ':sparkle:',
        "\xE2\x9D\x87" => ':sparkle:',
        "\xE2\x9D\x8C" => ':x:',
        "\xE2\x9D\x8E" => ':negative_squared_cross_mark:',
        "\xE2\x9D\x93" => ':question:',
        "\xE2\x9D\x94" => ':grey_question:',
        "\xE2\x9D\x95" => ':grey_exclamation:',
        "\xE2\x9D\x97\xEF\xB8\x8F" => ':exclamation:',
        "\xE2\x9D\x97" => ':exclamation:',
        "\xE2\x9D\xA4\xEF\xB8\x8F" => ':heart:',
        "\xE2\x9D\xA4" => ':heart:',
        "\xE2\x9E\x95" => ':heavy_plus_sign:',
        "\xE2\x9E\x96" => ':heavy_minus_sign:',
        "\xE2\x9E\x97" => ':heavy_division_sign:',
        "\xE2\x9E\xA1\xEF\xB8\x8F" => ':arrow_right:',
        "\xE2\x9E\xA1" => ':arrow_right:',
        "\xE2\x9E\xB0" => ':curly_loop:',
        "\xE2\xA4\xB4\xEF\xB8\x8F" => ':arrow_heading_up:',
        "\xE2\xA4\xB4" => ':arrow_heading_up:',
        "\xE2\xA4\xB5\xEF\xB8\x8F" => ':arrow_heading_down:',
        "\xE2\xA4\xB5" => ':arrow_heading_down:',
        "\xE2\xAC\x85\xEF\xB8\x8F" => ':arrow_left:',
        "\xE2\xAC\x85" => ':arrow_left:',
        "\xE2\xAC\x86\xEF\xB8\x8F" => ':arrow_up:',
        "\xE2\xAC\x86" => ':arrow_up:',
        "\xE2\xAC\x87\xEF\xB8\x8F" => ':arrow_down:',
        "\xE2\xAC\x87" => ':arrow_down:',
        "\xE2\xAC\x9B\xEF\xB8\x8F" => ':black_large_square:',
        "\xE2\xAC\x9B" => ':black_large_square:',
        "\xE2\xAC\x9C\xEF\xB8\x8F" => ':white_large_square:',
        "\xE2\xAC\x9C" => ':white_large_square:',
        "\xE2\xAD\x90\xEF\xB8\x8F" => ':star:',
        "\xE2\xAD\x90" => ':star:',
        "\xE2\xAD\x95\xEF\xB8\x8F" => ':o:',
        "\xE2\xAD\x95" => ':o:',
        "\xE3\x80\xB0" => ':wavy_dash:',
        "\xE3\x80\xBD\xEF\xB8\x8F" => ':part_alternation_mark:',
        "\xE3\x80\xBD" => ':part_alternation_mark:',
        "\xE3\x8A\x97\xEF\xB8\x8F" => ':congratulations:',
        "\xE3\x8A\x97" => ':congratulations:',
        "\xE3\x8A\x99\xEF\xB8\x8F" => ':secret:',
        "\xE3\x8A\x99" => ':secret:',
        "\xF0\x9F\x80\x84\xEF\xB8\x8F" => ':mahjong:',
        "\xF0\x9F\x80\x84" => ':mahjong:',
        "\xF0\x9F\x83\x8F" => ':black_joker:',
        "\xF0\x9F\x85\xB0" => ':a:',
        "\xF0\x9F\x85\xB1" => ':b:',
        "\xF0\x9F\x85\xBE" => ':o2:',
        "\xF0\x9F\x85\xBF\xEF\xB8\x8F" => ':parking:',
        "\xF0\x9F\x85\xBF" => ':parking:',
        "\xF0\x9F\x86\x8E" => ':ab:',
        "\xF0\x9F\x86\x91" => ':cl:',
        "\xF0\x9F\x86\x92" => ':cool:',
        "\xF0\x9F\x86\x93" => ':free:',
        "\xF0\x9F\x86\x94" => ':id:',
        "\xF0\x9F\x86\x95" => ':new:',
        "\xF0\x9F\x86\x96" => ':ng:',
        "\xF0\x9F\x86\x97" => ':ok:',
        "\xF0\x9F\x86\x98" => ':sos:',
        "\xF0\x9F\x86\x99" => ':up:',
        "\xF0\x9F\x86\x9A" => ':vs:',
        "\xF0\x9F\x87\xA8\xF0\x9F\x87\xB3" => ':cn:',
        "\xF0\x9F\x87\xA9\xF0\x9F\x87\xAA" => ':de:',
        "\xF0\x9F\x87\xAA\xF0\x9F\x87\xB8" => ':es:',
        "\xF0\x9F\x87\xAB\xF0\x9F\x87\xB7" => ':fr:',
        "\xF0\x9F\x87\xAC\xF0\x9F\x87\xA7" => ':gb:',
        "\xF0\x9F\x87\xAE\xF0\x9F\x87\xB9" => ':it:',
        "\xF0\x9F\x87\xAF\xF0\x9F\x87\xB5" => ':jp:',
        "\xF0\x9F\x87\xB0\xF0\x9F\x87\xB7" => ':kr:',
        "\xF0\x9F\x87\xBA\xF0\x9F\x87\xB8" => ':us:',
        "\xF0\x9F\x87\xB7\xF0\x9F\x87\xBA" => ':ru:',
        "\xF0\x9F\x88\x81" => ':koko:',
        "\xF0\x9F\x88\x82" => ':sa:',
        "\xF0\x9F\x88\x9A\xEF\xB8\x8F" => ':u7121:',
        "\xF0\x9F\x88\x9A" => ':u7121:',
        "\xF0\x9F\x88\xAF\xEF\xB8\x8F" => ':u6307:',
        "\xF0\x9F\x88\xAF" => ':u6307:',
        "\xF0\x9F\x88\xB2" => ':u7981:',
        "\xF0\x9F\x88\xB3" => ':u7a7a:',
        "\xF0\x9F\x88\xB4" => ':u5408:',
        "\xF0\x9F\x88\xB5" => ':u6e80:',
        "\xF0\x9F\x88\xB6" => ':u6709:',
        "\xF0\x9F\x88\xB7" => ':u6708:',
        "\xF0\x9F\x88\xB8" => ':u7533:',
        "\xF0\x9F\x88\xB9" => ':u5272:',
        "\xF0\x9F\x88\xBA" => ':u55b6:',
        "\xF0\x9F\x89\x90" => ':ideograph_advantage:',
        "\xF0\x9F\x89\x91" => ':accept:',
        "\xF0\x9F\x8C\x80" => ':cyclone:',
        "\xF0\x9F\x8C\x81" => ':foggy:',
        "\xF0\x9F\x8C\x82" => ':closed_umbrella:',
        "\xF0\x9F\x8C\x83" => ':night_with_stars:',
        "\xF0\x9F\x8C\x84" => ':sunrise_over_mountains:',
        "\xF0\x9F\x8C\x85" => ':sunrise:',
        "\xF0\x9F\x8C\x86" => ':city_dusk:',
        "\xF0\x9F\x8C\x87" => ':city_sunset:',
        "\xF0\x9F\x8C\x88" => ':rainbow:',
        "\xF0\x9F\x8C\x89" => ':bridge_at_night:',
        "\xF0\x9F\x8C\x8A" => ':ocean:',
        "\xF0\x9F\x8C\x8B" => ':volcano:',
        "\xF0\x9F\x8C\x8C" => ':milky_way:',
        "\xF0\x9F\x8C\x8F" => ':earth_asia:',
        "\xF0\x9F\x8C\x91" => ':new_moon:',
        "\xF0\x9F\x8C\x93" => ':first_quarter_moon:',
        "\xF0\x9F\x8C\x94" => ':waxing_gibbous_moon:',
        "\xF0\x9F\x8C\x95" => ':full_moon:',
        "\xF0\x9F\x8C\x99" => ':crescent_moon:',
        "\xF0\x9F\x8C\x9B" => ':first_quarter_moon_with_face:',
        "\xF0\x9F\x8C\x9F" => ':star2:',
        "\xF0\x9F\x8C\xA0" => ':stars:',
        "\xF0\x9F\x8C\xB0" => ':chestnut:',
        "\xF0\x9F\x8C\xB1" => ':seedling:',
        "\xF0\x9F\x8C\xB4" => ':palm_tree:',
        "\xF0\x9F\x8C\xB5" => ':cactus:',
        "\xF0\x9F\x8C\xB7" => ':tulip:',
        "\xF0\x9F\x8C\xB8" => ':cherry_blossom:',
        "\xF0\x9F\x8C\xB9" => ':rose:',
        "\xF0\x9F\x8C\xBA" => ':hibiscus:',
        "\xF0\x9F\x8C\xBB" => ':sunflower:',
        "\xF0\x9F\x8C\xBC" => ':blossom:',
        "\xF0\x9F\x8C\xBD" => ':corn:',
        "\xF0\x9F\x8C\xBE" => ':ear_of_rice:',
        "\xF0\x9F\x8C\xBF" => ':herb:',
        "\xF0\x9F\x8D\x80" => ':four_leaf_clover:',
        "\xF0\x9F\x8D\x81" => ':maple_leaf:',
        "\xF0\x9F\x8D\x82" => ':fallen_leaf:',
        "\xF0\x9F\x8D\x83" => ':leaves:',
        "\xF0\x9F\x8D\x84" => ':mushroom:',
        "\xF0\x9F\x8D\x85" => ':tomato:',
        "\xF0\x9F\x8D\x86" => ':eggplant:',
        "\xF0\x9F\x8D\x87" => ':grapes:',
        "\xF0\x9F\x8D\x88" => ':melon:',
        "\xF0\x9F\x8D\x89" => ':watermelon:',
        "\xF0\x9F\x8D\x8A" => ':tangerine:',
        "\xF0\x9F\x8D\x8C" => ':banana:',
        "\xF0\x9F\x8D\x8D" => ':pineapple:',
        "\xF0\x9F\x8D\x8E" => ':apple:',
        "\xF0\x9F\x8D\x8F" => ':green_apple:',
        "\xF0\x9F\x8D\x91" => ':peach:',
        "\xF0\x9F\x8D\x92" => ':cherries:',
        "\xF0\x9F\x8D\x93" => ':strawberry:',
        "\xF0\x9F\x8D\x94" => ':hamburger:',
        "\xF0\x9F\x8D\x95" => ':pizza:',
        "\xF0\x9F\x8D\x96" => ':meat_on_bone:',
        "\xF0\x9F\x8D\x97" => ':poultry_leg:',
        "\xF0\x9F\x8D\x98" => ':rice_cracker:',
        "\xF0\x9F\x8D\x99" => ':rice_ball:',
        "\xF0\x9F\x8D\x9A" => ':rice:',
        "\xF0\x9F\x8D\x9B" => ':curry:',
        "\xF0\x9F\x8D\x9C" => ':ramen:',
        "\xF0\x9F\x8D\x9D" => ':spaghetti:',
        "\xF0\x9F\x8D\x9E" => ':bread:',
        "\xF0\x9F\x8D\x9F" => ':fries:',
        "\xF0\x9F\x8D\xA0" => ':sweet_potato:',
        "\xF0\x9F\x8D\xA1" => ':dango:',
        "\xF0\x9F\x8D\xA2" => ':oden:',
        "\xF0\x9F\x8D\xA3" => ':sushi:',
        "\xF0\x9F\x8D\xA4" => ':fried_shrimp:',
        "\xF0\x9F\x8D\xA5" => ':fish_cake:',
        "\xF0\x9F\x8D\xA6" => ':icecream:',
        "\xF0\x9F\x8D\xA7" => ':shaved_ice:',
        "\xF0\x9F\x8D\xA8" => ':ice_cream:',
        "\xF0\x9F\x8D\xA9" => ':doughnut:',
        "\xF0\x9F\x8D\xAA" => ':cookie:',
        "\xF0\x9F\x8D\xAB" => ':chocolate_bar:',
        "\xF0\x9F\x8D\xAC" => ':candy:',
        "\xF0\x9F\x8D\xAD" => ':lollipop:',
        "\xF0\x9F\x8D\xAE" => ':custard:',
        "\xF0\x9F\x8D\xAF" => ':honey_pot:',
        "\xF0\x9F\x8D\xB0" => ':cake:',
        "\xF0\x9F\x8D\xB1" => ':bento:',
        "\xF0\x9F\x8D\xB2" => ':stew:',
        "\xF0\x9F\x8D\xB3" => ':egg:',
        "\xF0\x9F\x8D\xB4" => ':fork_and_knife:',
        "\xF0\x9F\x8D\xB5" => ':tea:',
        "\xF0\x9F\x8D\xB6" => ':sake:',
        "\xF0\x9F\x8D\xB7" => ':wine_glass:',
        "\xF0\x9F\x8D\xB8" => ':cocktail:',
        "\xF0\x9F\x8D\xB9" => ':tropical_drink:',
        "\xF0\x9F\x8D\xBA" => ':beer:',
        "\xF0\x9F\x8D\xBB" => ':beers:',
        "\xF0\x9F\x8E\x80" => ':ribbon:',
        "\xF0\x9F\x8E\x81" => ':gift:',
        "\xF0\x9F\x8E\x82" => ':birthday:',
        "\xF0\x9F\x8E\x83" => ':jack_o_lantern:',
        "\xF0\x9F\x8E\x84" => ':christmas_tree:',
        "\xF0\x9F\x8E\x85" => ':santa:',
        "\xF0\x9F\x8E\x86" => ':fireworks:',
        "\xF0\x9F\x8E\x87" => ':sparkler:',
        "\xF0\x9F\x8E\x88" => ':balloon:',
        "\xF0\x9F\x8E\x89" => ':tada:',
        "\xF0\x9F\x8E\x8A" => ':confetti_ball:',
        "\xF0\x9F\x8E\x8B" => ':tanabata_tree:',
        "\xF0\x9F\x8E\x8C" => ':crossed_flags:',
        "\xF0\x9F\x8E\x8D" => ':bamboo:',
        "\xF0\x9F\x8E\x8E" => ':dolls:',
        "\xF0\x9F\x8E\x8F" => ':flags:',
        "\xF0\x9F\x8E\x90" => ':wind_chime:',
        "\xF0\x9F\x8E\x91" => ':rice_scene:',
        "\xF0\x9F\x8E\x92" => ':school_satchel:',
        "\xF0\x9F\x8E\x93" => ':mortar_board:',
        "\xF0\x9F\x8E\xA0" => ':carousel_horse:',
        "\xF0\x9F\x8E\xA1" => ':ferris_wheel:',
        "\xF0\x9F\x8E\xA2" => ':roller_coaster:',
        "\xF0\x9F\x8E\xA3" => ':fishing_pole_and_fish:',
        "\xF0\x9F\x8E\xA4" => ':microphone:',
        "\xF0\x9F\x8E\xA5" => ':movie_camera:',
        "\xF0\x9F\x8E\xA6" => ':cinema:',
        "\xF0\x9F\x8E\xA7" => ':headphones:',
        "\xF0\x9F\x8E\xA8" => ':art:',
        "\xF0\x9F\x8E\xA9" => ':tophat:',
        "\xF0\x9F\x8E\xAA" => ':circus_tent:',
        "\xF0\x9F\x8E\xAB" => ':ticket:',
        "\xF0\x9F\x8E\xAC" => ':clapper:',
        "\xF0\x9F\x8E\xAD" => ':performing_arts:',
        "\xF0\x9F\x8E\xAE" => ':video_game:',
        "\xF0\x9F\x8E\xAF" => ':dart:',
        "\xF0\x9F\x8E\xB0" => ':slot_machine:',
        "\xF0\x9F\x8E\xB1" => ':8ball:',
        "\xF0\x9F\x8E\xB2" => ':game_die:',
        "\xF0\x9F\x8E\xB3" => ':bowling:',
        "\xF0\x9F\x8E\xB4" => ':flower_playing_cards:',
        "\xF0\x9F\x8E\xB5" => ':musical_note:',
        "\xF0\x9F\x8E\xB6" => ':notes:',
        "\xF0\x9F\x8E\xB7" => ':saxophone:',
        "\xF0\x9F\x8E\xB8" => ':guitar:',
        "\xF0\x9F\x8E\xB9" => ':musical_keyboard:',
        "\xF0\x9F\x8E\xBA" => ':trumpet:',
        "\xF0\x9F\x8E\xBB" => ':violin:',
        "\xF0\x9F\x8E\xBC" => ':musical_score:',
        "\xF0\x9F\x8E\xBD" => ':running_shirt_with_sash:',
        "\xF0\x9F\x8E\xBE" => ':tennis:',
        "\xF0\x9F\x8E\xBF" => ':ski:',
        "\xF0\x9F\x8F\x80" => ':basketball:',
        "\xF0\x9F\x8F\x81" => ':checkered_flag:',
        "\xF0\x9F\x8F\x82" => ':snowboarder:',
        "\xF0\x9F\x8F\x83" => ':runner:',
        "\xF0\x9F\x8F\x84" => ':surfer:',
        "\xF0\x9F\x8F\x86" => ':trophy:',
        "\xF0\x9F\x8F\x88" => ':football:',
        "\xF0\x9F\x8F\x8A" => ':swimmer:',
        "\xF0\x9F\x8F\xA0" => ':house:',
        "\xF0\x9F\x8F\xA1" => ':house_with_garden:',
        "\xF0\x9F\x8F\xA2" => ':office:',
        "\xF0\x9F\x8F\xA3" => ':post_office:',
        "\xF0\x9F\x8F\xA5" => ':hospital:',
        "\xF0\x9F\x8F\xA6" => ':bank:',
        "\xF0\x9F\x8F\xA7" => ':atm:',
        "\xF0\x9F\x8F\xA8" => ':hotel:',
        "\xF0\x9F\x8F\xA9" => ':love_hotel:',
        "\xF0\x9F\x8F\xAA" => ':convenience_store:',
        "\xF0\x9F\x8F\xAB" => ':school:',
        "\xF0\x9F\x8F\xAC" => ':department_store:',
        "\xF0\x9F\x8F\xAD" => ':factory:',
        "\xF0\x9F\x8F\xAE" => ':izakaya_lantern:',
        "\xF0\x9F\x8F\xAF" => ':japanese_castle:',
        "\xF0\x9F\x8F\xB0" => ':european_castle:',
        "\xF0\x9F\x90\x8C" => ':snail:',
        "\xF0\x9F\x90\x8D" => ':snake:',
        "\xF0\x9F\x90\x8E" => ':racehorse:',
        "\xF0\x9F\x90\x91" => ':sheep:',
        "\xF0\x9F\x90\x92" => ':monkey:',
        "\xF0\x9F\x90\x94" => ':chicken:',
        "\xF0\x9F\x90\x97" => ':boar:',
        "\xF0\x9F\x90\x98" => ':elephant:',
        "\xF0\x9F\x90\x99" => ':octopus:',
        "\xF0\x9F\x90\x9A" => ':shell:',
        "\xF0\x9F\x90\x9B" => ':bug:',
        "\xF0\x9F\x90\x9C" => ':ant:',
        "\xF0\x9F\x90\x9D" => ':bee:',
        "\xF0\x9F\x90\x9E" => ':beetle:',
        "\xF0\x9F\x90\x9F" => ':fish:',
        "\xF0\x9F\x90\xA0" => ':tropical_fish:',
        "\xF0\x9F\x90\xA1" => ':blowfish:',
        "\xF0\x9F\x90\xA2" => ':turtle:',
        "\xF0\x9F\x90\xA3" => ':hatching_chick:',
        "\xF0\x9F\x90\xA4" => ':baby_chick:',
        "\xF0\x9F\x90\xA5" => ':hatched_chick:',
        "\xF0\x9F\x90\xA6" => ':bird:',
        "\xF0\x9F\x90\xA7" => ':penguin:',
        "\xF0\x9F\x90\xA8" => ':koala:',
        "\xF0\x9F\x90\xA9" => ':poodle:',
        "\xF0\x9F\x90\xAB" => ':camel:',
        "\xF0\x9F\x90\xAC" => ':dolphin:',
        "\xF0\x9F\x90\xAD" => ':mouse:',
        "\xF0\x9F\x90\xAE" => ':cow:',
        "\xF0\x9F\x90\xAF" => ':tiger:',
        "\xF0\x9F\x90\xB0" => ':rabbit:',
        "\xF0\x9F\x90\xB1" => ':cat:',
        "\xF0\x9F\x90\xB2" => ':dragon_face:',
        "\xF0\x9F\x90\xB3" => ':whale:',
        "\xF0\x9F\x90\xB4" => ':horse:',
        "\xF0\x9F\x90\xB5" => ':monkey_face:',
        "\xF0\x9F\x90\xB6" => ':dog:',
        "\xF0\x9F\x90\xB7" => ':pig:',
        "\xF0\x9F\x90\xB8" => ':frog:',
        "\xF0\x9F\x90\xB9" => ':hamster:',
        "\xF0\x9F\x90\xBA" => ':wolf:',
        "\xF0\x9F\x90\xBB" => ':bear:',
        "\xF0\x9F\x90\xBC" => ':panda_face:',
        "\xF0\x9F\x90\xBD" => ':pig_nose:',
        "\xF0\x9F\x90\xBE" => ':feet:',
        "\xF0\x9F\x91\x80" => ':eyes:',
        "\xF0\x9F\x91\x82" => ':ear:',
        "\xF0\x9F\x91\x83" => ':nose:',
        "\xF0\x9F\x91\x84" => ':lips:',
        "\xF0\x9F\x91\x85" => ':tongue:',
        "\xF0\x9F\x91\x86" => ':point_up_2:',
        "\xF0\x9F\x91\x87" => ':point_down:',
        "\xF0\x9F\x91\x88" => ':point_left:',
        "\xF0\x9F\x91\x89" => ':point_right:',
        "\xF0\x9F\x91\x8A" => ':punch:',
        "\xF0\x9F\x91\x8B" => ':wave:',
        "\xF0\x9F\x91\x8C" => ':ok_hand:',
        "\xF0\x9F\x91\x8D" => ':thumbsup:',
        "\xF0\x9F\x91\x8E" => ':thumbsdown:',
        "\xF0\x9F\x91\x8F" => ':clap:',
        "\xF0\x9F\x91\x90" => ':open_hands:',
        "\xF0\x9F\x91\x91" => ':crown:',
        "\xF0\x9F\x91\x92" => ':womans_hat:',
        "\xF0\x9F\x91\x93" => ':eyeglasses:',
        "\xF0\x9F\x91\x94" => ':necktie:',
        "\xF0\x9F\x91\x95" => ':shirt:',
        "\xF0\x9F\x91\x96" => ':jeans:',
        "\xF0\x9F\x91\x97" => ':dress:',
        "\xF0\x9F\x91\x98" => ':kimono:',
        "\xF0\x9F\x91\x99" => ':bikini:',
        "\xF0\x9F\x91\x9A" => ':womans_clothes:',
        "\xF0\x9F\x91\x9B" => ':purse:',
        "\xF0\x9F\x91\x9C" => ':handbag:',
        "\xF0\x9F\x91\x9D" => ':pouch:',
        "\xF0\x9F\x91\x9E" => ':mans_shoe:',
        "\xF0\x9F\x91\x9F" => ':athletic_shoe:',
        "\xF0\x9F\x91\xA0" => ':high_heel:',
        "\xF0\x9F\x91\xA1" => ':sandal:',
        "\xF0\x9F\x91\xA2" => ':boot:',
        "\xF0\x9F\x91\xA3" => ':footprints:',
        "\xF0\x9F\x91\xA4" => ':bust_in_silhouette:',
        "\xF0\x9F\x91\xA6" => ':boy:',
        "\xF0\x9F\x91\xA7" => ':girl:',
        "\xF0\x9F\x91\xA8" => ':man:',
        "\xF0\x9F\x91\xA9" => ':woman:',
        "\xF0\x9F\x91\xAA" => ':family:',
        "\xF0\x9F\x91\xAB" => ':couple:',
        "\xF0\x9F\x91\xAE" => ':cop:',
        "\xF0\x9F\x91\xAF" => ':dancers:',
        "\xF0\x9F\x91\xB0" => ':bride_with_veil:',
        "\xF0\x9F\x91\xB1" => ':person_with_blond_hair:',
        "\xF0\x9F\x91\xB2" => ':man_with_gua_pi_mao:',
        "\xF0\x9F\x91\xB3" => ':man_with_turban:',
        "\xF0\x9F\x91\xB4" => ':older_man:',
        "\xF0\x9F\x91\xB5" => ':older_woman:',
        "\xF0\x9F\x91\xB6" => ':baby:',
        "\xF0\x9F\x91\xB7" => ':construction_worker:',
        "\xF0\x9F\x91\xB8" => ':princess:',
        "\xF0\x9F\x91\xB9" => ':japanese_ogre:',
        "\xF0\x9F\x91\xBA" => ':japanese_goblin:',
        "\xF0\x9F\x91\xBB" => ':ghost:',
        "\xF0\x9F\x91\xBC" => ':angel:',
        "\xF0\x9F\x91\xBD" => ':alien:',
        "\xF0\x9F\x91\xBE" => ':space_invader:',
        "\xF0\x9F\x91\xBF" => ':imp:',
        "\xF0\x9F\x92\x80" => ':skull:',
        "\xF0\x9F\x93\x87" => ':card_index:',
        "\xF0\x9F\x92\x81" => ':information_desk_person:',
        "\xF0\x9F\x92\x82" => ':guardsman:',
        "\xF0\x9F\x92\x83" => ':dancer:',
        "\xF0\x9F\x92\x84" => ':lipstick:',
        "\xF0\x9F\x92\x85" => ':nail_care:',
        "\xF0\x9F\x93\x92" => ':ledger:',
        "\xF0\x9F\x92\x86" => ':massage:',
        "\xF0\x9F\x93\x93" => ':notebook:',
        "\xF0\x9F\x92\x87" => ':haircut:',
        "\xF0\x9F\x93\x94" => ':notebook_with_decorative_cover:',
        "\xF0\x9F\x92\x88" => ':barber:',
        "\xF0\x9F\x93\x95" => ':closed_book:',
        "\xF0\x9F\x92\x89" => ':syringe:',
        "\xF0\x9F\x93\x96" => ':book:',
        "\xF0\x9F\x92\x8A" => ':pill:',
        "\xF0\x9F\x93\x97" => ':green_book:',
        "\xF0\x9F\x92\x8B" => ':kiss:',
        "\xF0\x9F\x93\x98" => ':blue_book:',
        "\xF0\x9F\x92\x8C" => ':love_letter:',
        "\xF0\x9F\x93\x99" => ':orange_book:',
        "\xF0\x9F\x92\x8D" => ':ring:',
        "\xF0\x9F\x93\x9A" => ':books:',
        "\xF0\x9F\x92\x8E" => ':gem:',
        "\xF0\x9F\x93\x9B" => ':name_badge:',
        "\xF0\x9F\x92\x8F" => ':couplekiss:',
        "\xF0\x9F\x93\x9C" => ':scroll:',
        "\xF0\x9F\x92\x90" => ':bouquet:',
        "\xF0\x9F\x93\x9D" => ':pencil:',
        "\xF0\x9F\x92\x91" => ':couple_with_heart:',
        "\xF0\x9F\x93\x9E" => ':telephone_receiver:',
        "\xF0\x9F\x92\x92" => ':wedding:',
        "\xF0\x9F\x93\x9F" => ':pager:',
        "\xF0\x9F\x93\xA0" => ':fax:',
        "\xF0\x9F\x92\x93" => ':heartbeat:',
        "\xF0\x9F\x93\xA1" => ':satellite:',
        "\xF0\x9F\x93\xA2" => ':loudspeaker:',
        "\xF0\x9F\x92\x94" => ':broken_heart:',
        "\xF0\x9F\x93\xA3" => ':mega:',
        "\xF0\x9F\x93\xA4" => ':outbox_tray:',
        "\xF0\x9F\x92\x95" => ':two_hearts:',
        "\xF0\x9F\x93\xA5" => ':inbox_tray:',
        "\xF0\x9F\x93\xA6" => ':package:',
        "\xF0\x9F\x92\x96" => ':sparkling_heart:',
        "\xF0\x9F\x93\xA7" => ':e-mail:',
        "\xF0\x9F\x93\xA8" => ':incoming_envelope:',
        "\xF0\x9F\x92\x97" => ':heartpulse:',
        "\xF0\x9F\x93\xA9" => ':envelope_with_arrow:',
        "\xF0\x9F\x93\xAA" => ':mailbox_closed:',
        "\xF0\x9F\x92\x98" => ':cupid:',
        "\xF0\x9F\x93\xAB" => ':mailbox:',
        "\xF0\x9F\x93\xAE" => ':postbox:',
        "\xF0\x9F\x92\x99" => ':blue_heart:',
        "\xF0\x9F\x93\xB0" => ':newspaper:',
        "\xF0\x9F\x93\xB1" => ':iphone:',
        "\xF0\x9F\x92\x9A" => ':green_heart:',
        "\xF0\x9F\x93\xB2" => ':calling:',
        "\xF0\x9F\x93\xB3" => ':vibration_mode:',
        "\xF0\x9F\x92\x9B" => ':yellow_heart:',
        "\xF0\x9F\x93\xB4" => ':mobile_phone_off:',
        "\xF0\x9F\x93\xB6" => ':signal_strength:',
        "\xF0\x9F\x92\x9C" => ':purple_heart:',
        "\xF0\x9F\x93\xB7" => ':camera:',
        "\xF0\x9F\x93\xB9" => ':video_camera:',
        "\xF0\x9F\x92\x9D" => ':gift_heart:',
        "\xF0\x9F\x93\xBA" => ':tv:',
        "\xF0\x9F\x93\xBB" => ':radio:',
        "\xF0\x9F\x92\x9E" => ':revolving_hearts:',
        "\xF0\x9F\x93\xBC" => ':vhs:',
        "\xF0\x9F\x94\x83" => ':arrows_clockwise:',
        "\xF0\x9F\x92\x9F" => ':heart_decoration:',
        "\xF0\x9F\x94\x8A" => ':loud_sound:',
        "\xF0\x9F\x94\x8B" => ':battery:',
        "\xF0\x9F\x92\xA0" => ':diamond_shape_with_a_dot_inside:',
        "\xF0\x9F\x94\x8C" => ':electric_plug:',
        "\xF0\x9F\x94\x8D" => ':mag:',
        "\xF0\x9F\x92\xA1" => ':bulb:',
        "\xF0\x9F\x94\x8E" => ':mag_right:',
        "\xF0\x9F\x94\x8F" => ':lock_with_ink_pen:',
        "\xF0\x9F\x92\xA2" => ':anger:',
        "\xF0\x9F\x94\x90" => ':closed_lock_with_key:',
        "\xF0\x9F\x94\x91" => ':key:',
        "\xF0\x9F\x92\xA3" => ':bomb:',
        "\xF0\x9F\x94\x92" => ':lock:',
        "\xF0\x9F\x94\x93" => ':unlock:',
        "\xF0\x9F\x92\xA4" => ':zzz:',
        "\xF0\x9F\x94\x94" => ':bell:',
        "\xF0\x9F\x94\x96" => ':bookmark:',
        "\xF0\x9F\x92\xA5" => ':boom:',
        "\xF0\x9F\x94\x97" => ':link:',
        "\xF0\x9F\x94\x98" => ':radio_button:',
        "\xF0\x9F\x92\xA6" => ':sweat_drops:',
        "\xF0\x9F\x94\x99" => ':back:',
        "\xF0\x9F\x94\x9A" => ':end:',
        "\xF0\x9F\x92\xA7" => ':droplet:',
        "\xF0\x9F\x94\x9B" => ':on:',
        "\xF0\x9F\x94\x9C" => ':soon:',
        "\xF0\x9F\x92\xA8" => ':dash:',
        "\xF0\x9F\x94\x9D" => ':top:',
        "\xF0\x9F\x94\x9E" => ':underage:',
        "\xF0\x9F\x92\xA9" => ':poop:',
        "\xF0\x9F\x94\x9F" => ':keycap_ten:',
        "\xF0\x9F\x92\xAA" => ':muscle:',
        "\xF0\x9F\x94\xA0" => ':capital_abcd:',
        "\xF0\x9F\x94\xA1" => ':abcd:',
        "\xF0\x9F\x92\xAB" => ':dizzy:',
        "\xF0\x9F\x94\xA2" => ':1234:',
        "\xF0\x9F\x94\xA3" => ':symbols:',
        "\xF0\x9F\x92\xAC" => ':speech_balloon:',
        "\xF0\x9F\x94\xA4" => ':abc:',
        "\xF0\x9F\x94\xA5" => ':fire:',
        "\xF0\x9F\x92\xAE" => ':white_flower:',
        "\xF0\x9F\x94\xA6" => ':flashlight:',
        "\xF0\x9F\x94\xA7" => ':wrench:',
        "\xF0\x9F\x92\xAF" => ':100:',
        "\xF0\x9F\x94\xA8" => ':hammer:',
        "\xF0\x9F\x94\xA9" => ':nut_and_bolt:',
        "\xF0\x9F\x92\xB0" => ':moneybag:',
        "\xF0\x9F\x94\xAA" => ':knife:',
        "\xF0\x9F\x94\xAB" => ':gun:',
        "\xF0\x9F\x92\xB1" => ':currency_exchange:',
        "\xF0\x9F\x94\xAE" => ':crystal_ball:',
        "\xF0\x9F\x92\xB2" => ':heavy_dollar_sign:',
        "\xF0\x9F\x94\xAF" => ':six_pointed_star:',
        "\xF0\x9F\x92\xB3" => ':credit_card:',
        "\xF0\x9F\x94\xB0" => ':beginner:',
        "\xF0\x9F\x94\xB1" => ':trident:',
        "\xF0\x9F\x92\xB4" => ':yen:',
        "\xF0\x9F\x94\xB2" => ':black_square_button:',
        "\xF0\x9F\x94\xB3" => ':white_square_button:',
        "\xF0\x9F\x92\xB5" => ':dollar:',
        "\xF0\x9F\x94\xB4" => ':red_circle:',
        "\xF0\x9F\x94\xB5" => ':large_blue_circle:',
        "\xF0\x9F\x92\xB8" => ':money_with_wings:',
        "\xF0\x9F\x94\xB6" => ':large_orange_diamond:',
        "\xF0\x9F\x94\xB7" => ':large_blue_diamond:',
        "\xF0\x9F\x92\xB9" => ':chart:',
        "\xF0\x9F\x94\xB8" => ':small_orange_diamond:',
        "\xF0\x9F\x94\xB9" => ':small_blue_diamond:',
        "\xF0\x9F\x92\xBA" => ':seat:',
        "\xF0\x9F\x94\xBA" => ':small_red_triangle:',
        "\xF0\x9F\x94\xBB" => ':small_red_triangle_down:',
        "\xF0\x9F\x92\xBB" => ':computer:',
        "\xF0\x9F\x94\xBC" => ':arrow_up_small:',
        "\xF0\x9F\x92\xBC" => ':briefcase:',
        "\xF0\x9F\x94\xBD" => ':arrow_down_small:',
        "\xF0\x9F\x95\x90" => ':clock1:',
        "\xF0\x9F\x92\xBD" => ':minidisc:',
        "\xF0\x9F\x95\x91" => ':clock2:',
        "\xF0\x9F\x92\xBE" => ':floppy_disk:',
        "\xF0\x9F\x95\x92" => ':clock3:',
        "\xF0\x9F\x92\xBF" => ':cd:',
        "\xF0\x9F\x95\x93" => ':clock4:',
        "\xF0\x9F\x93\x80" => ':dvd:',
        "\xF0\x9F\x95\x94" => ':clock5:',
        "\xF0\x9F\x95\x95" => ':clock6:',
        "\xF0\x9F\x93\x81" => ':file_folder:',
        "\xF0\x9F\x95\x96" => ':clock7:',
        "\xF0\x9F\x95\x97" => ':clock8:',
        "\xF0\x9F\x93\x82" => ':open_file_folder:',
        "\xF0\x9F\x95\x98" => ':clock9:',
        "\xF0\x9F\x95\x99" => ':clock10:',
        "\xF0\x9F\x93\x83" => ':page_with_curl:',
        "\xF0\x9F\x95\x9A" => ':clock11:',
        "\xF0\x9F\x95\x9B" => ':clock12:',
        "\xF0\x9F\x93\x84" => ':page_facing_up:',
        "\xF0\x9F\x97\xBB" => ':mount_fuji:',
        "\xF0\x9F\x97\xBC" => ':tokyo_tower:',
        "\xF0\x9F\x93\x85" => ':date:',
        "\xF0\x9F\x97\xBD" => ':statue_of_liberty:',
        "\xF0\x9F\x97\xBE" => ':japan:',
        "\xF0\x9F\x93\x86" => ':calendar:',
        "\xF0\x9F\x97\xBF" => ':moyai:',
        "\xF0\x9F\x98\x81" => ':grin:',
        "\xF0\x9F\x98\x82" => ':joy:',
        "\xF0\x9F\x98\x83" => ':smiley:',
        "\xF0\x9F\x93\x88" => ':chart_with_upwards_trend:',
        "\xF0\x9F\x98\x84" => ':smile:',
        "\xF0\x9F\x98\x85" => ':sweat_smile:',
        "\xF0\x9F\x93\x89" => ':chart_with_downwards_trend:',
        "\xF0\x9F\x98\x86" => ':laughing:',
        "\xF0\x9F\x98\x89" => ':wink:',
        "\xF0\x9F\x93\x8A" => ':bar_chart:',
        "\xF0\x9F\x98\x8A" => ':blush:',
        "\xF0\x9F\x98\x8B" => ':yum:',
        "\xF0\x9F\x93\x8B" => ':clipboard:',
        "\xF0\x9F\x98\x8C" => ':relieved:',
        "\xF0\x9F\x98\x8D" => ':heart_eyes:',
        "\xF0\x9F\x93\x8C" => ':pushpin:',
        "\xF0\x9F\x98\x8F" => ':smirk:',
        "\xF0\x9F\x98\x92" => ':unamused:',
        "\xF0\x9F\x93\x8D" => ':round_pushpin:',
        "\xF0\x9F\x98\x93" => ':sweat:',
        "\xF0\x9F\x98\x94" => ':pensive:',
        "\xF0\x9F\x93\x8E" => ':paperclip:',
        "\xF0\x9F\x98\x96" => ':confounded:',
        "\xF0\x9F\x98\x98" => ':kissing_heart:',
        "\xF0\x9F\x93\x8F" => ':straight_ruler:',
        "\xF0\x9F\x98\x9A" => ':kissing_closed_eyes:',
        "\xF0\x9F\x98\x9C" => ':stuck_out_tongue_winking_eye:',
        "\xF0\x9F\x93\x90" => ':triangular_ruler:',
        "\xF0\x9F\x98\x9D" => ':stuck_out_tongue_closed_eyes:',
        "\xF0\x9F\x98\x9E" => ':disappointed:',
        "\xF0\x9F\x93\x91" => ':bookmark_tabs:',
        "\xF0\x9F\x98\xA0" => ':angry:',
        "\xF0\x9F\x98\xA1" => ':rage:',
        "\xF0\x9F\x98\xA2" => ':cry:',
        "\xF0\x9F\x98\xA3" => ':persevere:',
        "\xF0\x9F\x98\xA4" => ':triumph:',
        "\xF0\x9F\x98\xA5" => ':disappointed_relieved:',
        "\xF0\x9F\x98\xA8" => ':fearful:',
        "\xF0\x9F\x98\xA9" => ':weary:',
        "\xF0\x9F\x98\xAA" => ':sleepy:',
        "\xF0\x9F\x98\xAB" => ':tired_face:',
        "\xF0\x9F\x98\xAD" => ':sob:',
        "\xF0\x9F\x98\xB0" => ':cold_sweat:',
        "\xF0\x9F\x98\xB1" => ':scream:',
        "\xF0\x9F\x98\xB2" => ':astonished:',
        "\xF0\x9F\x98\xB3" => ':flushed:',
        "\xF0\x9F\x98\xB5" => ':dizzy_face:',
        "\xF0\x9F\x98\xB7" => ':mask:',
        "\xF0\x9F\x98\xB8" => ':smile_cat:',
        "\xF0\x9F\x98\xB9" => ':joy_cat:',
        "\xF0\x9F\x98\xBA" => ':smiley_cat:',
        "\xF0\x9F\x98\xBB" => ':heart_eyes_cat:',
        "\xF0\x9F\x98\xBC" => ':smirk_cat:',
        "\xF0\x9F\x98\xBD" => ':kissing_cat:',
        "\xF0\x9F\x98\xBE" => ':pouting_cat:',
        "\xF0\x9F\x98\xBF" => ':crying_cat_face:',
        "\xF0\x9F\x99\x80" => ':scream_cat:',
        "\xF0\x9F\x99\x85" => ':no_good:',
        "\xF0\x9F\x99\x86" => ':ok_woman:',
        "\xF0\x9F\x99\x87" => ':bow:',
        "\xF0\x9F\x99\x88" => ':see_no_evil:',
        "\xF0\x9F\x99\x89" => ':hear_no_evil:',
        "\xF0\x9F\x99\x8A" => ':speak_no_evil:',
        "\xF0\x9F\x99\x8B" => ':raising_hand:',
        "\xF0\x9F\x99\x8C" => ':raised_hands:',
        "\xF0\x9F\x99\x8D" => ':person_frowning:',
        "\xF0\x9F\x99\x8E" => ':person_with_pouting_face:',
        "\xF0\x9F\x99\x8F" => ':pray:',
        "\xF0\x9F\x9A\x80" => ':rocket:',
        "\xF0\x9F\x9A\x83" => ':railway_car:',
        "\xF0\x9F\x9A\x84" => ':bullettrain_side:',
        "\xF0\x9F\x9A\x85" => ':bullettrain_front:',
        "\xF0\x9F\x9A\x87" => ':metro:',
        "\xF0\x9F\x9A\x89" => ':station:',
        "\xF0\x9F\x9A\x8C" => ':bus:',
        "\xF0\x9F\x9A\x8F" => ':busstop:',
        "\xF0\x9F\x9A\x91" => ':ambulance:',
        "\xF0\x9F\x9A\x92" => ':fire_engine:',
        "\xF0\x9F\x9A\x93" => ':police_car:',
        "\xF0\x9F\x9A\x95" => ':taxi:',
        "\xF0\x9F\x9A\x97" => ':red_car:',
        "\xF0\x9F\x9A\x99" => ':blue_car:',
        "\xF0\x9F\x9A\x9A" => ':truck:',
        "\xF0\x9F\x9A\xA2" => ':ship:',
        "\xF0\x9F\x9A\xA4" => ':speedboat:',
        "\xF0\x9F\x9A\xA5" => ':traffic_light:',
        "\xF0\x9F\x9A\xA7" => ':construction:',
        "\xF0\x9F\x9A\xA8" => ':rotating_light:',
        "\xF0\x9F\x9A\xA9" => ':triangular_flag_on_post:',
        "\xF0\x9F\x9A\xAA" => ':door:',
        "\xF0\x9F\x9A\xAB" => ':no_entry_sign:',
        "\xF0\x9F\x9A\xAC" => ':smoking:',
        "\xF0\x9F\x9A\xAD" => ':no_smoking:',
        "\xF0\x9F\x9A\xB2" => ':bike:',
        "\xF0\x9F\x9A\xB6" => ':walking:',
        "\xF0\x9F\x9A\xB9" => ':mens:',
        "\xF0\x9F\x9A\xBA" => ':womens:',
        "\xF0\x9F\x9A\xBB" => ':restroom:',
        "\xF0\x9F\x9A\xBC" => ':baby_symbol:',
        "\xF0\x9F\x9A\xBD" => ':toilet:',
        "\xF0\x9F\x9A\xBE" => ':wc:',
        "\xF0\x9F\x9B\x80" => ':bath:',
        "\xF0\x9F\x98\x80" => ':grinning:',
        "\xF0\x9F\x98\x87" => ':innocent:',
        "\xF0\x9F\x98\x88" => ':smiling_imp:',
        "\xF0\x9F\x98\x8E" => ':sunglasses:',
        "\xF0\x9F\x98\x90" => ':neutral_face:',
        "\xF0\x9F\x98\x91" => ':expressionless:',
        "\xF0\x9F\x98\x95" => ':confused:',
        "\xF0\x9F\x98\x97" => ':kissing:',
        "\xF0\x9F\x98\x99" => ':kissing_smiling_eyes:',
        "\xF0\x9F\x98\x9B" => ':stuck_out_tongue:',
        "\xF0\x9F\x98\x9F" => ':worried:',
        "\xF0\x9F\x98\xA6" => ':frowning:',
        "\xF0\x9F\x98\xA7" => ':anguished:',
        "\xF0\x9F\x98\xAC" => ':grimacing:',
        "\xF0\x9F\x98\xAE" => ':open_mouth:',
        "\xF0\x9F\x98\xAF" => ':hushed:',
        "\xF0\x9F\x98\xB4" => ':sleeping:',
        "\xF0\x9F\x98\xB6" => ':no_mouth:',
        "\xF0\x9F\x9A\x81" => ':helicopter:',
        "\xF0\x9F\x9A\x82" => ':steam_locomotive:',
        "\xF0\x9F\x9A\x86" => ':train2:',
        "\xF0\x9F\x9A\x88" => ':light_rail:',
        "\xF0\x9F\x9A\x8A" => ':tram:',
        "\xF0\x9F\x9A\x8D" => ':oncoming_bus:',
        "\xF0\x9F\x9A\x8E" => ':trolleybus:',
        "\xF0\x9F\x9A\x90" => ':minibus:',
        "\xF0\x9F\x9A\x94" => ':oncoming_police_car:',
        "\xF0\x9F\x9A\x96" => ':oncoming_taxi:',
        "\xF0\x9F\x9A\x98" => ':oncoming_automobile:',
        "\xF0\x9F\x9A\x9B" => ':articulated_lorry:',
        "\xF0\x9F\x9A\x9C" => ':tractor:',
        "\xF0\x9F\x9A\x9D" => ':monorail:',
        "\xF0\x9F\x9A\x9E" => ':mountain_railway:',
        "\xF0\x9F\x9A\x9F" => ':suspension_railway:',
        "\xF0\x9F\x9A\xA0" => ':mountain_cableway:',
        "\xF0\x9F\x9A\xA1" => ':aerial_tramway:',
        "\xF0\x9F\x9A\xA3" => ':rowboat:',
        "\xF0\x9F\x9A\xA6" => ':vertical_traffic_light:',
        "\xF0\x9F\x9A\xAE" => ':put_litter_in_its_place:',
        "\xF0\x9F\x9A\xAF" => ':do_not_litter:',
        "\xF0\x9F\x9A\xB0" => ':potable_water:',
        "\xF0\x9F\x9A\xB1" => ':non-potable_water:',
        "\xF0\x9F\x9A\xB3" => ':no_bicycles:',
        "\xF0\x9F\x9A\xB4" => ':bicyclist:',
        "\xF0\x9F\x9A\xB5" => ':mountain_bicyclist:',
        "\xF0\x9F\x9A\xB7" => ':no_pedestrians:',
        "\xF0\x9F\x9A\xB8" => ':children_crossing:',
        "\xF0\x9F\x9A\xBF" => ':shower:',
        "\xF0\x9F\x9B\x81" => ':bathtub:',
        "\xF0\x9F\x9B\x82" => ':passport_control:',
        "\xF0\x9F\x9B\x83" => ':customs:',
        "\xF0\x9F\x9B\x84" => ':baggage_claim:',
        "\xF0\x9F\x9B\x85" => ':left_luggage:',
        "\xF0\x9F\x8C\x8D" => ':earth_africa:',
        "\xF0\x9F\x8C\x8E" => ':earth_americas:',
        "\xF0\x9F\x8C\x90" => ':globe_with_meridians:',
        "\xF0\x9F\x8C\x92" => ':waxing_crescent_moon:',
        "\xF0\x9F\x8C\x96" => ':waning_gibbous_moon:',
        "\xF0\x9F\x8C\x97" => ':last_quarter_moon:',
        "\xF0\x9F\x8C\x98" => ':waning_crescent_moon:',
        "\xF0\x9F\x8C\x9A" => ':new_moon_with_face:',
        "\xF0\x9F\x8C\x9C" => ':last_quarter_moon_with_face:',
        "\xF0\x9F\x8C\x9D" => ':full_moon_with_face:',
        "\xF0\x9F\x8C\x9E" => ':sun_with_face:',
        "\xF0\x9F\x8C\xB2" => ':evergreen_tree:',
        "\xF0\x9F\x8C\xB3" => ':deciduous_tree:',
        "\xF0\x9F\x8D\x8B" => ':lemon:',
        "\xF0\x9F\x8D\x90" => ':pear:',
        "\xF0\x9F\x8D\xBC" => ':baby_bottle:',
        "\xF0\x9F\x8F\x87" => ':horse_racing:',
        "\xF0\x9F\x8F\x89" => ':rugby_football:',
        "\xF0\x9F\x8F\xA4" => ':european_post_office:',
        "\xF0\x9F\x90\x80" => ':rat:',
        "\xF0\x9F\x90\x81" => ':mouse2:',
        "\xF0\x9F\x90\x82" => ':ox:',
        "\xF0\x9F\x90\x83" => ':water_buffalo:',
        "\xF0\x9F\x90\x84" => ':cow2:',
        "\xF0\x9F\x90\x85" => ':tiger2:',
        "\xF0\x9F\x90\x86" => ':leopard:',
        "\xF0\x9F\x90\x87" => ':rabbit2:',
        "\xF0\x9F\x90\x88" => ':cat2:',
        "\xF0\x9F\x90\x89" => ':dragon:',
        "\xF0\x9F\x90\x8A" => ':crocodile:',
        "\xF0\x9F\x90\x8B" => ':whale2:',
        "\xF0\x9F\x90\x8F" => ':ram:',
        "\xF0\x9F\x90\x90" => ':goat:',
        "\xF0\x9F\x90\x93" => ':rooster:',
        "\xF0\x9F\x90\x95" => ':dog2:',
        "\xF0\x9F\x90\x96" => ':pig2:',
        "\xF0\x9F\x90\xAA" => ':dromedary_camel:',
        "\xF0\x9F\x91\xA5" => ':busts_in_silhouette:',
        "\xF0\x9F\x91\xAC" => ':two_men_holding_hands:',
        "\xF0\x9F\x91\xAD" => ':two_women_holding_hands:',
        "\xF0\x9F\x92\xAD" => ':thought_balloon:',
        "\xF0\x9F\x92\xB6" => ':euro:',
        "\xF0\x9F\x92\xB7" => ':pound:',
        "\xF0\x9F\x93\xAC" => ':mailbox_with_mail:',
        "\xF0\x9F\x93\xAD" => ':mailbox_with_no_mail:',
        "\xF0\x9F\x93\xAF" => ':postal_horn:',
        "\xF0\x9F\x93\xB5" => ':no_mobile_phones:',
        "\xF0\x9F\x94\x80" => ':twisted_rightwards_arrows:',
        "\xF0\x9F\x94\x81" => ':repeat:',
        "\xF0\x9F\x94\x82" => ':repeat_one:',
        "\xF0\x9F\x94\x84" => ':arrows_counterclockwise:',
        "\xF0\x9F\x94\x85" => ':low_brightness:',
        "\xF0\x9F\x94\x86" => ':high_brightness:',
        "\xF0\x9F\x94\x87" => ':mute:',
        "\xF0\x9F\x94\x89" => ':sound:',
        "\xF0\x9F\x94\x95" => ':no_bell:',
        "\xF0\x9F\x94\xAC" => ':microscope:',
        "\xF0\x9F\x94\xAD" => ':telescope:',
        "\xF0\x9F\x95\x9C" => ':clock130:',
        "\xF0\x9F\x95\x9D" => ':clock230:',
        "\xF0\x9F\x95\x9E" => ':clock330:',
        "\xF0\x9F\x95\x9F" => ':clock430:',
        "\xF0\x9F\x95\xA0" => ':clock530:',
        "\xF0\x9F\x95\xA1" => ':clock630:',
        "\xF0\x9F\x95\xA2" => ':clock730:',
        "\xF0\x9F\x95\xA3" => ':clock830:',
        "\xF0\x9F\x95\xA4" => ':clock930:',
        "\xF0\x9F\x95\xA5" => ':clock1030:',
        "\xF0\x9F\x95\xA6" => ':clock1130:',
        "\xF0\x9F\x95\xA7" => ':clock1230:',
        "\xF0\x9F\x94\x88" => ':speaker:',
        "\xF0\x9F\x9A\x8B" => ':train:',
        "\xE2\x9E\xBF" => ':loop:',
        "\xF0\x9F\x87\xA6\xF0\x9F\x87\xAB" => ':af:',
        "\xF0\x9F\x87\xA6\xF0\x9F\x87\xB1" => ':al:',
        "\xF0\x9F\x87\xA9\xF0\x9F\x87\xBF" => ':dz:',
        "\xF0\x9F\x87\xA6\xF0\x9F\x87\xA9" => ':ad:',
        "\xF0\x9F\x87\xA6\xF0\x9F\x87\xB4" => ':ao:',
        "\xF0\x9F\x87\xA6\xF0\x9F\x87\xAC" => ':ag:',
        "\xF0\x9F\x87\xA6\xF0\x9F\x87\xB7" => ':ar:',
        "\xF0\x9F\x87\xA6\xF0\x9F\x87\xB2" => ':am:',
        "\xF0\x9F\x87\xA6\xF0\x9F\x87\xBA" => ':au:',
        "\xF0\x9F\x87\xA6\xF0\x9F\x87\xB9" => ':at:',
        "\xF0\x9F\x87\xA6\xF0\x9F\x87\xBF" => ':az:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xB8" => ':bs:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xAD" => ':bh:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xA9" => ':bd:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xA7" => ':bb:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xBE" => ':by:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xAA" => ':be:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xBF" => ':bz:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xAF" => ':bj:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xB9" => ':bt:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xB4" => ':bo:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xA6" => ':ba:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xBC" => ':bw:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xB7" => ':br:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xB3" => ':bn:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xAC" => ':bg:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xAB" => ':bf:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xAE" => ':bi:',
        "\xF0\x9F\x87\xB0\xF0\x9F\x87\xAD" => ':kh:',
        "\xF0\x9F\x87\xA8\xF0\x9F\x87\xB2" => ':cm:',
        "\xF0\x9F\x87\xA8\xF0\x9F\x87\xA6" => ':ca:',
        "\xF0\x9F\x87\xA8\xF0\x9F\x87\xBB" => ':cv:',
        "\xF0\x9F\x87\xA8\xF0\x9F\x87\xAB" => ':cf:',
        "\xF0\x9F\x87\xB9\xF0\x9F\x87\xA9" => ':td:',
        "\xF0\x9F\x87\xA8\xF0\x9F\x87\xB1" => ':cl:',
        "\xF0\x9F\x87\xA8\xF0\x9F\x87\xB4" => ':co:',
        "\xF0\x9F\x87\xB0\xF0\x9F\x87\xB2" => ':km:',
        "\xF0\x9F\x87\xA8\xF0\x9F\x87\xB7" => ':cr:',
        "\xF0\x9F\x87\xA8\xF0\x9F\x87\xAE" => ':ci:',
        "\xF0\x9F\x87\xAD\xF0\x9F\x87\xB7" => ':hr:',
        "\xF0\x9F\x87\xA8\xF0\x9F\x87\xBA" => ':cu:',
        "\xF0\x9F\x87\xA8\xF0\x9F\x87\xBE" => ':cy:',
        "\xF0\x9F\x87\xA8\xF0\x9F\x87\xBF" => ':cz:',
        "\xF0\x9F\x87\xA8\xF0\x9F\x87\xA9" => ':cd:',
        "\xF0\x9F\x87\xA9\xF0\x9F\x87\xB0" => ':dk:',
        "\xF0\x9F\x87\xA9\xF0\x9F\x87\xAF" => ':dj:',
        "\xF0\x9F\x87\xA9\xF0\x9F\x87\xB2" => ':dm:',
        "\xF0\x9F\x87\xA9\xF0\x9F\x87\xB4" => ':do:',
        "\xF0\x9F\x87\xB9\xF0\x9F\x87\xB1" => ':tl:',
        "\xF0\x9F\x87\xAA\xF0\x9F\x87\xA8" => ':ec:',
        "\xF0\x9F\x87\xAA\xF0\x9F\x87\xAC" => ':eg:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xBB" => ':sv:',
        "\xF0\x9F\x87\xAC\xF0\x9F\x87\xB6" => ':gq:',
        "\xF0\x9F\x87\xAA\xF0\x9F\x87\xB7" => ':er:',
        "\xF0\x9F\x87\xAA\xF0\x9F\x87\xAA" => ':ee:',
        "\xF0\x9F\x87\xAA\xF0\x9F\x87\xB9" => ':et:',
        "\xF0\x9F\x87\xAB\xF0\x9F\x87\xAF" => ':fj:',
        "\xF0\x9F\x87\xAB\xF0\x9F\x87\xAE" => ':fi:',
        "\xF0\x9F\x87\xAC\xF0\x9F\x87\xA6" => ':ga:',
        "\xF0\x9F\x87\xAC\xF0\x9F\x87\xB2" => ':gm:',
        "\xF0\x9F\x87\xAC\xF0\x9F\x87\xAA" => ':ge:',
        "\xF0\x9F\x87\xAC\xF0\x9F\x87\xAD" => ':gh:',
        "\xF0\x9F\x87\xAC\xF0\x9F\x87\xB7" => ':gr:',
        "\xF0\x9F\x87\xAC\xF0\x9F\x87\xA9" => ':gd:',
        "\xF0\x9F\x87\xAC\xF0\x9F\x87\xB9" => ':gt:',
        "\xF0\x9F\x87\xAC\xF0\x9F\x87\xB3" => ':gn:',
        "\xF0\x9F\x87\xAC\xF0\x9F\x87\xBC" => ':gw:',
        "\xF0\x9F\x87\xAC\xF0\x9F\x87\xBE" => ':gy:',
        "\xF0\x9F\x87\xAD\xF0\x9F\x87\xB9" => ':ht:',
        "\xF0\x9F\x87\xAD\xF0\x9F\x87\xB3" => ':hn:',
        "\xF0\x9F\x87\xAD\xF0\x9F\x87\xBA" => ':hu:',
        "\xF0\x9F\x87\xAE\xF0\x9F\x87\xB8" => ':is:',
        "\xF0\x9F\x87\xAE\xF0\x9F\x87\xB3" => ':in:',
        "\xF0\x9F\x87\xAE\xF0\x9F\x87\xA9" => ':id:',
        "\xF0\x9F\x87\xAE\xF0\x9F\x87\xB7" => ':ir:',
        "\xF0\x9F\x87\xAE\xF0\x9F\x87\xB6" => ':iq:',
        "\xF0\x9F\x87\xAE\xF0\x9F\x87\xAA" => ':ie:',
        "\xF0\x9F\x87\xAE\xF0\x9F\x87\xB1" => ':il:',
        "\xF0\x9F\x87\xAF\xF0\x9F\x87\xB2" => ':jm:',
        "\xF0\x9F\x87\xAF\xF0\x9F\x87\xB4" => ':jo:',
        "\xF0\x9F\x87\xB0\xF0\x9F\x87\xBF" => ':kz:',
        "\xF0\x9F\x87\xB0\xF0\x9F\x87\xAA" => ':ke:',
        "\xF0\x9F\x87\xB0\xF0\x9F\x87\xAE" => ':ki:',
        "\xF0\x9F\x87\xBD\xF0\x9F\x87\xB0" => ':xk:',
        "\xF0\x9F\x87\xB0\xF0\x9F\x87\xBC" => ':kw:',
        "\xF0\x9F\x87\xB0\xF0\x9F\x87\xAC" => ':kg:',
        "\xF0\x9F\x87\xB1\xF0\x9F\x87\xA6" => ':la:',
        "\xF0\x9F\x87\xB1\xF0\x9F\x87\xBB" => ':lv:',
        "\xF0\x9F\x87\xB1\xF0\x9F\x87\xA7" => ':lb:',
        "\xF0\x9F\x87\xB1\xF0\x9F\x87\xB8" => ':ls:',
        "\xF0\x9F\x87\xB1\xF0\x9F\x87\xB7" => ':lr:',
        "\xF0\x9F\x87\xB1\xF0\x9F\x87\xBE" => ':ly:',
        "\xF0\x9F\x87\xB1\xF0\x9F\x87\xAE" => ':li:',
        "\xF0\x9F\x87\xB1\xF0\x9F\x87\xB9" => ':lt:',
        "\xF0\x9F\x87\xB1\xF0\x9F\x87\xBA" => ':lu:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xB0" => ':mk:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xAC" => ':mg:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xBC" => ':mw:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xBE" => ':my:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xBB" => ':mv:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xB1" => ':ml:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xB9" => ':mt:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xAD" => ':mh:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xB7" => ':mr:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xBA" => ':mu:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xBD" => ':mx:',
        "\xF0\x9F\x87\xAB\xF0\x9F\x87\xB2" => ':fm:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xA9" => ':md:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xA8" => ':mc:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xB3" => ':mn:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xAA" => ':me:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xA6" => ':ma:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xBF" => ':mz:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xB2" => ':mm:',
        "\xF0\x9F\x87\xB3\xF0\x9F\x87\xA6" => ':na:',
        "\xF0\x9F\x87\xB3\xF0\x9F\x87\xB7" => ':nr:',
        "\xF0\x9F\x87\xB3\xF0\x9F\x87\xB5" => ':np:',
        "\xF0\x9F\x87\xB3\xF0\x9F\x87\xB1" => ':nl:',
        "\xF0\x9F\x87\xB3\xF0\x9F\x87\xBF" => ':nz:',
        "\xF0\x9F\x87\xB3\xF0\x9F\x87\xAE" => ':ni:',
        "\xF0\x9F\x87\xB3\xF0\x9F\x87\xAA" => ':ne:',
        "\xF0\x9F\x87\xB3\xF0\x9F\x87\xAC" => ':ng:',
        "\xF0\x9F\x87\xB0\xF0\x9F\x87\xB5" => ':kp:',
        "\xF0\x9F\x87\xB3\xF0\x9F\x87\xB4" => ':no:',
        "\xF0\x9F\x87\xB4\xF0\x9F\x87\xB2" => ':om:',
        "\xF0\x9F\x87\xB5\xF0\x9F\x87\xB0" => ':pk:',
        "\xF0\x9F\x87\xB5\xF0\x9F\x87\xBC" => ':pw:',
        "\xF0\x9F\x87\xB5\xF0\x9F\x87\xA6" => ':pa:',
        "\xF0\x9F\x87\xB5\xF0\x9F\x87\xAC" => ':pg:',
        "\xF0\x9F\x87\xB5\xF0\x9F\x87\xBE" => ':py:',
        "\xF0\x9F\x87\xB5\xF0\x9F\x87\xAA" => ':pe:',
        "\xF0\x9F\x87\xB5\xF0\x9F\x87\xAD" => ':ph:',
        "\xF0\x9F\x87\xB5\xF0\x9F\x87\xB1" => ':pl:',
        "\xF0\x9F\x87\xB5\xF0\x9F\x87\xB9" => ':pt:',
        "\xF0\x9F\x87\xB6\xF0\x9F\x87\xA6" => ':qa:',
        "\xF0\x9F\x87\xB9\xF0\x9F\x87\xBC" => ':tw:',
        "\xF0\x9F\x87\xA8\xF0\x9F\x87\xAC" => ':cg:',
        "\xF0\x9F\x87\xB7\xF0\x9F\x87\xB4" => ':ro:',
        "\xF0\x9F\x87\xB7\xF0\x9F\x87\xBC" => ':rw:',
        "\xF0\x9F\x87\xB0\xF0\x9F\x87\xB3" => ':kn:',
        "\xF0\x9F\x87\xB1\xF0\x9F\x87\xA8" => ':lc:',
        "\xF0\x9F\x87\xBB\xF0\x9F\x87\xA8" => ':vc:',
        "\xF0\x9F\x87\xBC\xF0\x9F\x87\xB8" => ':ws:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xB2" => ':sm:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xB9" => ':st:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xA6" => ':sa:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xB3" => ':sn:',
        "\xF0\x9F\x87\xB7\xF0\x9F\x87\xB8" => ':rs:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xA8" => ':sc:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xB1" => ':sl:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xAC" => ':sg:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xB0" => ':sk:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xAE" => ':si:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xA7" => ':sb:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xB4" => ':so:',
        "\xF0\x9F\x87\xBF\xF0\x9F\x87\xA6" => ':za:',
        "\xF0\x9F\x87\xB1\xF0\x9F\x87\xB0" => ':lk:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xA9" => ':sd:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xB7" => ':sr:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xBF" => ':sz:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xAA" => ':se:',
        "\xF0\x9F\x87\xA8\xF0\x9F\x87\xAD" => ':ch:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xBE" => ':sy:',
        "\xF0\x9F\x87\xB9\xF0\x9F\x87\xAF" => ':tj:',
        "\xF0\x9F\x87\xB9\xF0\x9F\x87\xBF" => ':tz:',
        "\xF0\x9F\x87\xB9\xF0\x9F\x87\xAD" => ':th:',
        "\xF0\x9F\x87\xB9\xF0\x9F\x87\xAC" => ':tg:',
        "\xF0\x9F\x87\xB9\xF0\x9F\x87\xB4" => ':to:',
        "\xF0\x9F\x87\xB9\xF0\x9F\x87\xB9" => ':tt:',
        "\xF0\x9F\x87\xB9\xF0\x9F\x87\xB3" => ':tn:',
        "\xF0\x9F\x87\xB9\xF0\x9F\x87\xB7" => ':tr:',
        "\xF0\x9F\x87\xB9\xF0\x9F\x87\xB2" => ':tm:',
        "\xF0\x9F\x87\xB9\xF0\x9F\x87\xBB" => ':tv:',
        "\xF0\x9F\x87\xBA\xF0\x9F\x87\xAC" => ':ug:',
        "\xF0\x9F\x87\xBA\xF0\x9F\x87\xA6" => ':ua:',
        "\xF0\x9F\x87\xA6\xF0\x9F\x87\xAA" => ':ae:',
        "\xF0\x9F\x87\xBA\xF0\x9F\x87\xBE" => ':uy:',
        "\xF0\x9F\x87\xBA\xF0\x9F\x87\xBF" => ':uz:',
        "\xF0\x9F\x87\xBB\xF0\x9F\x87\xBA" => ':vu:',
        "\xF0\x9F\x87\xBB\xF0\x9F\x87\xA6" => ':va:',
        "\xF0\x9F\x87\xBB\xF0\x9F\x87\xAA" => ':ve:',
        "\xF0\x9F\x87\xBB\xF0\x9F\x87\xB3" => ':vn:',
        "\xF0\x9F\x87\xAA\xF0\x9F\x87\xAD" => ':eh:',
        "\xF0\x9F\x87\xBE\xF0\x9F\x87\xAA" => ':ye:',
        "\xF0\x9F\x87\xBF\xF0\x9F\x87\xB2" => ':zm:',
        "\xF0\x9F\x87\xBF\xF0\x9F\x87\xBC" => ':zw:',
        "\xF0\x9F\x87\xB5\xF0\x9F\x87\xB7" => ':pr:',
        "\xF0\x9F\x87\xB0\xF0\x9F\x87\xBE" => ':ky:',
        "\xF0\x9F\x87\xA7\xF0\x9F\x87\xB2" => ':bm:',
        "\xF0\x9F\x87\xB5\xF0\x9F\x87\xAB" => ':pf:',
        "\xF0\x9F\x87\xB5\xF0\x9F\x87\xB8" => ':ps:',
        "\xF0\x9F\x87\xB3\xF0\x9F\x87\xA8" => ':nc:',
        "\xF0\x9F\x87\xB8\xF0\x9F\x87\xAD" => ':sh:',
        "\xF0\x9F\x87\xA6\xF0\x9F\x87\xBC" => ':aw:',
        "\xF0\x9F\x87\xBB\xF0\x9F\x87\xAE" => ':vi:',
        "\xF0\x9F\x87\xAD\xF0\x9F\x87\xB0" => ':hk:',
        "\xF0\x9F\x87\xA6\xF0\x9F\x87\xA8" => ':ac:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xB8" => ':ms:',
        "\xF0\x9F\x87\xAC\xF0\x9F\x87\xBA" => ':gu:',
        "\xF0\x9F\x87\xAC\xF0\x9F\x87\xB1" => ':gl:',
        "\xF0\x9F\x87\xB3\xF0\x9F\x87\xBA" => ':nu:',
        "\xF0\x9F\x87\xBC\xF0\x9F\x87\xAB" => ':wf:',
        "\xF0\x9F\x87\xB2\xF0\x9F\x87\xB4" => ':mo:',
        "\xF0\x9F\x87\xAB\xF0\x9F\x87\xB4" => ':fo:',
        "\xF0\x9F\x87\xAB\xF0\x9F\x87\xB0" => ':fk:',
        "\xF0\x9F\x87\xAF\xF0\x9F\x87\xAA" => ':je:',
        "\xF0\x9F\x87\xA6\xF0\x9F\x87\xAE" => ':ai:',
        "\xF0\x9F\x87\xAC\xF0\x9F\x87\xAE" => ':gi:'
    );
    static $asciiRegexp = '(\\<3|&lt;3|\\<\\/3|&lt;\\/3|\\:\'\\)|\\:\'\\-\\)|\\:D|\\:\\-D|\\=D|\\:\\)|\\:\\-\\)|\\=\\]|\\=\\)|\\:\\]|\'\\:\\)|\'\\:\\-\\)|\'\\=\\)|\'\\:D|\'\\:\\-D|\'\\=D|\\>\\:\\)|&gt;\\:\\)|\\>;\\)|&gt;;\\)|\\>\\:\\-\\)|&gt;\\:\\-\\)|\\>\\=\\)|&gt;\\=\\)|;\\)|;\\-\\)|\\*\\-\\)|\\*\\)|;\\-\\]|;\\]|;D|;\\^\\)|\'\\:\\(|\'\\:\\-\\(|\'\\=\\(|\\:\\*|\\:\\-\\*|\\=\\*|\\:\\^\\*|\\>\\:P|&gt;\\:P|X\\-P|x\\-p|\\>\\:\\[|&gt;\\:\\[|\\:\\-\\(|\\:\\(|\\:\\-\\[|\\:\\[|\\=\\(|\\>\\:\\(|&gt;\\:\\(|\\>\\:\\-\\(|&gt;\\:\\-\\(|\\:@|\\:\'\\(|\\:\'\\-\\(|;\\(|;\\-\\(|\\>\\.\\<|&gt;\\.&lt;|\\:\\$|\\=\\$|#\\-\\)|#\\)|%\\-\\)|%\\)|X\\)|X\\-\\)|\\*\\\\0\\/\\*|\\\\0\\/|\\*\\\\O\\/\\*|\\\\O\\/|O\\:\\-\\)|0\\:\\-3|0\\:3|0\\:\\-\\)|0\\:\\)|0;\\^\\)|O\\:\\-\\)|O\\:\\)|O;\\-\\)|O\\=\\)|0;\\-\\)|O\\:\\-3|O\\:3|B\\-\\)|B\\)|8\\)|8\\-\\)|B\\-D|8\\-D|\\-_\\-|\\-__\\-|\\-___\\-|\\>\\:\\\\|&gt;\\:\\\\|\\>\\:\\/|&gt;\\:\\/|\\:\\-\\/|\\:\\-\\.|\\:\\/|\\:\\\\|\\=\\/|\\=\\\\|\\:L|\\=L|\\:P|\\:\\-P|\\=P|\\:\\-p|\\:p|\\=p|\\:\\-Þ|\\:\\-&THORN;|\\:Þ|\\:&THORN;|\\:þ|\\:&thorn;|\\:\\-þ|\\:\\-&thorn;|\\:\\-b|\\:b|d\\:|\\:\\-O|\\:O|\\:\\-o|\\:o|O_O|\\>\\:O|&gt;\\:O|\\:\\-X|\\:X|\\:\\-#|\\:#|\\=X|\\=x|\\:x|\\:\\-x|\\=#)';

    private function __construct() {

    }

    // ##########################################
    // ######## core methods
    // ##########################################
    static function toImage($string) {
        $string = self::unicodeToImage($string);
        $string = self::shortnameToImage($string);
        return $string;
    }
    // Uses toShort to transform all unicode into a standard shortname
    // then transforms the shortname into unicode
    // This is done for standardization when converting several unicode types
    static function unifyUnicode($string) {
        $string = self::toShort($string);
        $string = self::shortnameToUnicode($string);
        return $string;
    }
    // will output unicode from shortname
    // useful for sending emojis back to mobile devices
    static function shortnameToUnicode($string) {
        $string = preg_replace_callback('/'.self::$ignoredRegexp.'|('.self::$shortcodeRegexp.')/Si', 'static::shortnameToUnicodeCallback', $string);
        if(self::$ascii) {
            $string = preg_replace_callback('/'.self::$ignoredRegexp.'|((\\s|^)'.self::$asciiRegexp.'(?=\\s|$|[!,\.]))/S', 'static::asciiToUnicodeCallback', $string);
        }
        return $string;
    }
    // Replace shortnames (:wink:) with Ascii equivalents ;^)
    // Useful for systems that dont support unicode nor images
    static function shortnameToAscii($string) {
        $string = preg_replace_callback('/'.self::$ignoredRegexp.'|('.self::$shortcodeRegexp.')/Si', 'static::shortnameToAsciiCallback', $string);
        return $string;
    }
    static function shortnameToImage($string) {
        $string = preg_replace_callback('/'.self::$ignoredRegexp.'|('.self::$shortcodeRegexp.')/Si', 'static::shortnameToImageCallback', $string);
        if(self::$ascii) {
            $string = preg_replace_callback('/'.self::$ignoredRegexp.'|((\\s|^)'.self::$asciiRegexp.'(?=\\s|$|[!,\.]))/S', 'static::asciiToImageCallback', $string);
        }
        return $string;
    }
    static function toShort($string) {
        return preg_replace_callback('/'.self::$ignoredRegexp.'|'.self::$unicodeRegexp.'/S', 'static::toShortCallback', $string);
    }
    static function unicodeToImage($string) {
        return preg_replace_callback('/'.self::$ignoredRegexp.'|'.self::$unicodeRegexp.'/S', 'static::unicodeToImageCallback', $string);
    }

    // ##########################################
    // ######## preg_replace callbacks
    // ##########################################
    static function shortnameToAsciiCallback($m) {
        if((!is_array($m)) || (!isset($m[1])) || (empty($m[1]))) {
            return $m[0];
        }
        else {
            $aflipped = array_flip(self::$ascii_replace);

            $shortname = $m[0];

            if(!isset(self::$shortcode_replace[$shortname])) {
                return $m[0];
            }

            $unicode = strtolower(self::$shortcode_replace[$shortname]);

            return isset($aflipped[$unicode]) ? $aflipped[$unicode] : $m[0];
        }
    }
    static function shortnameToUnicodeCallback($m) {
        if((!is_array($m)) || (!isset($m[1])) || (empty($m[1]))) {
            return $m[0];
        }
        else {
            $flipped = array_flip(self::$unicode_replace);

            $shortname = $m[1];

            if(!isset($flipped[$shortname])) {
                return $m[0];
            }


            $unicode = $flipped[$shortname];
            return $unicode;
        }
    }
    static function shortnameToImageCallback($m) {
        if((!is_array($m)) || (!isset($m[1])) || (empty($m[1]))) {
            return $m[0];
        }
        else {
            $shortname = $m[1];

            if(!isset(self::$shortcode_replace[$shortname])) {
                return $m[0];
            }


            $unicode = self::$shortcode_replace[$shortname];
            $filename = strtoupper($unicode);

            if(self::$unicodeAlt) { $alt = self::convert($unicode); }
            else { $alt = $shortname; }

            if(self::$imageType == 'png') {
                if(self::$sprites) {
                    return '<span class="emojione-'.strtoupper($unicode).'" title="'.htmlspecialchars($shortname).'">'.$alt.'</span>';
                }
                else {
                    return '<img class="emojione" alt="'.$alt.'" src="'.self::$imagePathPNG.$filename.'.png'.self::$cacheBustParam.'"/>';
                }
            }

            if(self::$sprites) {
                return '<svg class="emojione"><description>'.$alt.'</description><use xlink:href="'.self::$imagePathSVGSprites.'#emoji-'.strtoupper($unicode).'"></use></svg>';
            }
            else {
                return '<object class="emojione" data="'.self::$imagePathSVG.$filename.'.svg'.self::$cacheBustParam.'" type="image/svg+xml" standby="'.$alt.'">'.$alt.'</object>';
            }
        }
    }
    static function asciiToUnicodeCallback($m) {
        if((!is_array($m)) || (!isset($m[3])) || (empty($m[3]))) {
            return $m[0];
        }
        else {
            $shortname = $m[3];
            $unicode = self::$ascii_replace[$shortname];
            return self::convert($unicode);
        }
    }
    static function asciiToImageCallback($m) {
        if((!is_array($m)) || (!isset($m[3])) || (empty($m[3]))) {
            return $m[0];
        }
        else {
            $shortname = html_entity_decode($m[3]);
            $unicode = self::$ascii_replace[$shortname];

            // unicode char or shortname for the alt tag? (unicode is better for copying and pasting the resulting text)
            if(self::$unicodeAlt) { $alt = self::convert($unicode); }
            else { $alt = htmlspecialchars($shortname); }

            if(self::$imageType == 'png') {
                if(self::$sprites) {
                    return $m[2].'<span class="emojione-'.strtoupper($unicode).'" title="'.htmlspecialchars($shortname).'">'.$alt.'</span>';
                }
                else {
                    return $m[2].'<img class="emojione" alt="'.$alt.'" src="'.self::$imagePathPNG.strtoupper($unicode).'.png'.self::$cacheBustParam.'"/>';
                }
            }

            if(self::$sprites) {
                return $m[2].'<svg class="emojione"><description>'.$alt.'</description><use xlink:href="'.self::$imagePathSVGSprites.'#emoji-'.strtoupper($unicode).'"></use></svg>';
            }
            else {
                return $m[2].'<object class="emojione" data="'.self::$imagePathSVG.strtoupper($unicode).'.svg'.self::$cacheBustParam.'" type="image/svg+xml" standby="'.$alt.'">'.$alt.'</object>';
            }
        }
    }
    static function toShortCallback($m) {
        if((!is_array($m)) || (!isset($m[1])) || (empty($m[1]))) {
            return $m[0];
        }
        else {
            $unicode = $m[1];
            if(!isset(self::$unicode_replace[$unicode])) {
                $unicode = substr($m[1], 0, 4);
                if(!isset(self::$unicode_replace[$unicode])) {
                    return $m[0];
                }
            }

            return self::$unicode_replace[$unicode];
        }
    }
    static function unicodeToImageCallback($m) {
        if((!is_array($m)) || (!isset($m[1])) || (empty($m[1]))) {
            return $m[0];
        }
        else {
            $unicode = $m[1];

            if(!isset(self::$unicode_replace[$unicode])) {
                $unicode = substr($m[1], 0, 4);
                if(!isset(self::$unicode_replace[$unicode])) {
                    return $m[0];
                }
            }

            $shortname = self::$unicode_replace[$unicode];
            $filename = strtoupper(self::$shortcode_replace[$shortname]);

            if(self::$unicodeAlt) { $alt = $unicode; }
            else { $alt = $shortname; }

            if(self::$imageType == 'png') {
                if(self::$sprites) {
                    return '<span class="emojione-'.strtoupper($unicode).'" title="'.htmlspecialchars($shortname).'">'.$alt.'</span>';
                }
                else {
                    return '<img class="emojione" alt="'.$alt.'" src="'.self::$imagePathPNG.$filename.'.png'.self::$cacheBustParam.'"/>';
                }
            }

            if(self::$sprites) {
                return '<svg class="emojione"><description>'.$alt.'</description><use xlink:href="'.self::$imagePathSVGSprites.'#emoji-'.strtoupper($unicode).'"></use></svg>';
            }
            else {
                return '<object class="emojione" data="'.self::$imagePathSVG.$filename.'.svg'.self::$cacheBustParam.'" type="image/svg+xml" standby="'.$alt.'">'.$alt.'</object>';
            }
        }
    }

    // ##########################################
    // ######## helper methods
    // ##########################################
    static function convert($unicode) {
        if(stristr($unicode,'-')) {
            $pairs = explode('-',$unicode);
            return '&#x'.implode(';&#x',$pairs).';';
        }
        else {
            return '&#x'.$unicode.';';
        }
    }
}
?>
