<?php
/* For licensing terms, see /license.txt */
/**
 * Code
 * @package chamilo.include.internationalization
 */
/**
 * Historical data about non UTF-8 encodings that might be used in Chamilo LMS.
 * The following list may have some inconsistencies.
 * Put the probably most used for your language encoding at the first place.
 */
return array(
    'afrikaans' => array('ISO-8859-15', 'WINDOWS-1252'),
    'albanian' => array('ISO-8859-15', 'WINDOWS-1252'),
    'alemannic' => array('ISO-8859-15', 'WINDOWS-1252'),
    'amharic' => array(),
    'armenian' => array('ARMSCII-8'),
    'arabic' => array('WINDOWS-1256', 'ISO-8859-6'),
    'asturian' => array('ISO-8859-15', 'WINDOWS-1252'),
    'belarusian' => array('WINDOWS-1251', 'ISO-8859-5'),
    'bosnian' => array('WINDOWS-1250', 'ISO-8859-2'),
    'brazilian' => array('ISO-8859-15', 'WINDOWS-1252'),
    'breton' => array('ISO-8859-15', 'WINDOWS-1252'),
    'bulgarian' => array('WINDOWS-1251', 'ISO-8859-5', 'KOI8-R'),
    'catalan' => array('ISO-8859-15', 'WINDOWS-1252'),
    'croatian' => array('WINDOWS-1250', 'ISO-8859-2'),
    'czech' => array('WINDOWS-1250', 'ISO-8859-2'),
    'danish' => array('ISO-8859-15', 'WINDOWS-1252'),
    'dari' => array(),
    'dutch' => array('ISO-8859-15', 'WINDOWS-1252'),
    'english' => array('ISO-8859-15', 'WINDOWS-1252'),
    'esperanto' => array('ISO-8859-3'),
    'estonian' => array('WINDOWS-1257', 'ISO-8859-13', 'ISO-8859-15'),
    'basque' => array('ISO-8859-15', 'WINDOWS-1252'),
    'finnish' => array('ISO-8859-15', 'WINDOWS-1252'),
    'french' => array('ISO-8859-15', 'WINDOWS-1252'),
    'frisian' => array('ISO-8859-15', 'WINDOWS-1252'),
    'friulian' => array('ISO-8859-15', 'WINDOWS-1252'),
    'galician' => array('ISO-8859-15', 'WINDOWS-1252'),
    'georgian' => array('GEORGIAN-ACADEMY', 'GEORGIAN-PS'),
    'german' => array('ISO-8859-15', 'WINDOWS-1252'),
    'greek' => array('WINDOWS-1253', 'ISO-8859-7'),
    'hawaiian' => array(),
    'hebrew' => array('ISO-8859-8', 'WINDOWS-1255'),
    'hindi' => array(),
    'hungarian' => array('WINDOWS-1250', 'ISO-8859-2'),
    'icelandic' => array('ISO-8859-15', 'WINDOWS-1252'),
    'indonesian' => array('ISO-8859-15', 'WINDOWS-1252'),
    'irish' =>  array('ISO-8859-15', 'WINDOWS-1252'),
    'italian' => array('ISO-8859-15', 'WINDOWS-1252'),
    'japanese' => array('EUC-JP', 'ISO-2022-JP', 'SHIFT-JIS'),
    'korean' => array('EUC-KR', 'ISO-2022-KR', 'CP949'),
    'latin' => array('ISO-8859-15', 'WINDOWS-1252'),
    'latvian' => array('WINDOWS-1257', 'ISO-8859-13'),
    'lithuanian' => array('WINDOWS-1257', 'ISO-8859-13'),
    'macedonian' => array('WINDOWS-1251'),
    'malay' => array('ISO-8859-15', 'WINDOWS-1252'),
    'manx' => array('ISO-8859-15', 'WINDOWS-1252'),
    'marathi' => array(),
    'middle_frisian' => array('ISO-8859-15', 'WINDOWS-1252'),
    'mingo' => array('ISO-8859-15', 'WINDOWS-1252'),
    'nepali' => array(),
    'norwegian' => array('ISO-8859-15', 'WINDOWS-1252'),
    'occitan' => array('ISO-8859-15', 'WINDOWS-1252'),
    'pashto' => array(),
    'persian' => array(),
    'polish' => array('WINDOWS-1250', 'ISO-8859-2'),
    'portuguese' => array('ISO-8859-15', 'WINDOWS-1252'),
    'quechua_cusco' => array('ISO-8859-15', 'WINDOWS-1252'),
    'romanian' => array('WINDOWS-1250', 'ISO-8859-2'),
    'rumantsch' => array(),
    'russian' => array('KOI8-R', 'WINDOWS-1251'),
    'sanskrit' => array(),
    'scots' => array('ISO-8859-15', 'WINDOWS-1252'),
    'scots_gaelic' => array('ISO-8859-15', 'WINDOWS-1252'),
    'serbian' => array('WINDOWS-1250', 'ISO-8859-2'),
    'serbian_cyrillic' => array('WINDOWS-1251'),
    'simpl_chinese' => array('GB2312', 'WINDOWS-936'),
    'slovak' => array('WINDOWS-1250', 'ISO-8859-2'),
    'slovenian' => array('WINDOWS-1250', 'ISO-8859-2'),
    'spanish' => array('ISO-8859-15', 'WINDOWS-1252'),
    'swahili' => array('ISO-8859-15', 'WINDOWS-1252'),
    'swedish' => array('ISO-8859-15', 'WINDOWS-1252'),
    'tagalog' => array(),
    'tamil' => array(),
    'thai' => array('WINDOWS-874', 'ISO-8859-11'),
    'trad_chinese' => array('BIG-5', 'EUC-TW'),
    'turkish' => array('WINDOWS-1254', 'ISO-8859-9'),
    'ukrainian' => array('KOI8-U'),
    'vietnamese' => array('WINDOWS-1258'),
    'welsh' => array('ISO-8859-15', 'WINDOWS-1252'),
    'yiddish' => array(),
    'yoruba' => array('ISO-8859-15', 'WINDOWS-1252')
);
