<?php

namespace Shibboleth;

/**
 * This file is autogenerated. Do not modifiy it.
 */

/**
 *
 * Model for table admin 
 *
 * @license see /license.txt
 * @author Laurent Opprecht <laurent@opprecht.info>, Nicolas Rod for the University of Geneva
 */
class _Admin
{

    /**
    * Store for Admin objects. Interact with the database.
    *
    * @return AdminStore 
    */
    public static function store()
    {
        static $result = false;
        if (empty($result))
        {
            $result = new AdminStore();
        }
        return $result;
    }
        
    /**
     *
     * @return Admin 
     */
    public static function create($data = null)
    {
        return self::store()->create_object($data);
    }   

    public $user_id = null;     
 
    
    /**
     *
     * @return bool 
     */
    public function save()
    {
        return self::store()->save($this);
    }
    
}

/**
 * Store for Admin objects. Interact with the database.
 *
 * @copyright (c) 2012 University of Geneva
 * @license GNU General Public License - http://www.gnu.org/copyleft/gpl.html
 * @author Laurent Opprecht <laurent@opprecht.info>
 */
class _AdminStore extends Store
{

    /**
     *
     * @return AdminStore 
     */
    public static function instance()
    {
        static $result = false;
        if (empty($result))
        {
            $result = new self();
        }
        return $result;
    }
    
    public function __construct()
    {
        parent::__construct('admin', '\Shibboleth\Admin', 'user_id');
    }
    
    /**
     *
     * @return Admin 
     */
    public function get($w)
    {
        $args = func_get_args();
        $f = array('parent', 'get');
        return call_user_func_array($f, $args);
    }    
    
    /**
     *
     * @return Admin 
     */
    public function create_object($data)
    {
        return parent::create_object($data);
    }    
    
    /**
     *
     * @return Admin 
     */
    public function get_by_user_id($value)
    {
        return $this->get(array('user_id' => $value));
    }    
    
    /**
     *
     * @return bool 
     */
    public function user_id_exists($value)
    {
        return $this->exist(array('user_id' => $value));
    }     
    
    /**
     *
     * @return bool 
     */
    public function delete_by_user_id($value)
    {
        return $this->delete(array('user_id' => $value));
    }    
    
     
}