/*
 * Decompiled with CFR 0.152.
 */
package com.hammurapi.jcapture;

import com.hammurapi.jcapture.AbstractCaptureApplet;
import com.hammurapi.jcapture.CaptureFrame;
import com.hammurapi.jcapture.VideoEncoder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class CaptureOptionsDialog
extends JDialog {
    private JRadioButton sampleSize16Button;
    private JTextField timeLineScaleTextField;
    private JCheckBox toobarCheckBox;
    private JCheckBox videoBorderCheckBox;
    private JTextField screenScaleTextField;
    private JLabel timelineScalingLabel;
    private JLabel screenScalingLabel;
    private JTextField fpsTextField;
    private JLabel fpsLabel;
    private ButtonGroup sampleSizeButtonGroup;
    private JComboBox<String> sampleRateComboBox;
    private JRadioButton sampleSize8Button;
    private JTextField inactivityIntervalTextField;
    private JLabel inactivityIntervalLabel;
    private JCheckBox inactivityCheckBox;
    private JPanel inactivityPanel;
    private JPanel scalingPanel;
    private JCheckBox stereoCheckBox;
    private JLabel sampleSizeLabel;
    private JTabbedPane recordingSettingsPane;
    private JCheckBox recordSoundCheckBox;
    private JLabel sampleRateLabel;
    private JComboBox<String> soundLineComboBox;
    private JLabel soundSourceLabel;
    private JPanel audioSettingsPanel;
    private JPanel videoSettingsPanel;
    private JButton cancelButton;
    private JButton okButton;
    private JPanel recordPanel;
    private JComboBox<VideoEncoder> encodersComboBox;
    private JTextField mp3Text;
    private AudioFormat audioFormat;
    private float[] sampleRates = new float[]{5512.0f, 11025.0f, 22050.0f, 44100.0f};
    private DefaultComboBoxModel<String> soundLineComboBoxModel;
    private JLabel imageFormatLabel;
    private JTextField imageFormatTextField;
    private JCheckBox mouseCheckBox;
    private JCheckBox playCheckBox;
    private JCheckBox loopCheckBox;
    private JLabel encoderLabel;

    public CaptureOptionsDialog(final CaptureFrame owner) {
        super(owner);
        this.setDefaultCloseOperation(2);
        BorderLayout thisLayout = new BorderLayout();
        this.setLayout(thisLayout);
        this.setPreferredSize(new Dimension(333, 186));
        this.recordPanel = new JPanel();
        this.add(this.recordPanel);
        GridBagLayout recordPanelLayout = new GridBagLayout();
        recordPanelLayout.rowWeights = new double[]{0.1, 0.0, 0.0, 0.0};
        recordPanelLayout.rowHeights = new int[]{7, 7, 20, 7};
        recordPanelLayout.columnWeights = new double[]{0.1, 0.0, 0.0, 0.0, 0.0};
        recordPanelLayout.columnWidths = new int[]{20, 7, 7, 7, 7};
        this.recordPanel.setLayout(recordPanelLayout);
        this.recordPanel.setPreferredSize(new Dimension(335, 297));
        this.okButton = new JButton();
        this.recordPanel.add((Component)this.okButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (CaptureOptionsDialog.this.recordSoundCheckBox.isSelected()) {
                        owner.getCaptureConfig().setAudioFormat(CaptureOptionsDialog.this.audioFormat);
                        owner.getCaptureConfig().setMixerName((String)CaptureOptionsDialog.this.soundLineComboBox.getSelectedItem());
                    } else {
                        owner.getCaptureConfig().setRemoveInactivity(CaptureOptionsDialog.this.inactivityCheckBox.isSelected());
                        if (owner.getCaptureConfig().isRemoveInactivity()) {
                            owner.getCaptureConfig().setInactivityInterval(Double.parseDouble(CaptureOptionsDialog.this.inactivityIntervalTextField.getText()));
                        }
                    }
                    owner.getCaptureConfig().setLoop(CaptureOptionsDialog.this.getLoopCheckBox().isSelected());
                    owner.getCaptureConfig().setPlay(CaptureOptionsDialog.this.getPlayCheckBox().isSelected());
                    owner.getCaptureConfig().setMouse(CaptureOptionsDialog.this.getMouseCheckBox().isSelected());
                    owner.getCaptureConfig().setSound(CaptureOptionsDialog.this.recordSoundCheckBox.isSelected());
                    owner.getCaptureConfig().setImageFormat(CaptureOptionsDialog.this.getImageFormatTextField().getText().trim());
                    owner.getCaptureConfig().setBorder(CaptureOptionsDialog.this.videoBorderCheckBox.isSelected());
                    owner.getCaptureConfig().setFramesPerSecond(Float.parseFloat(CaptureOptionsDialog.this.fpsTextField.getText()));
                    owner.getCaptureConfig().setScreenScale(Double.parseDouble(CaptureOptionsDialog.this.screenScaleTextField.getText()) / 100.0);
                    owner.getCaptureConfig().setSpeedScale((float)((double)Float.parseFloat(CaptureOptionsDialog.this.timeLineScaleTextField.getText()) / 100.0));
                    owner.getCaptureConfig().setToolBar(CaptureOptionsDialog.this.toobarCheckBox.isSelected());
                    owner.getApplet().storeConfig(owner.getCaptureConfig().store());
                    owner.getCaptureConfig().setMp3command(CaptureOptionsDialog.this.mp3Text.getText());
                    owner.getCaptureConfig().setEncoder((VideoEncoder)CaptureOptionsDialog.this.encodersComboBox.getSelectedItem());
                    owner.setRecordButtonState();
                    CaptureOptionsDialog.this.setVisible(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(CaptureOptionsDialog.this, e.toString(), "Error in configuration parameters", 0);
                }
            }
        });
        this.cancelButton = new JButton();
        this.recordPanel.add((Component)this.cancelButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaptureOptionsDialog.this.setVisible(false);
            }
        });
        this.recordingSettingsPane = new JTabbedPane();
        this.recordPanel.add((Component)this.recordingSettingsPane, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.videoSettingsPanel = new JPanel();
        GridBagLayout videoSettingsPanelLayout = new GridBagLayout();
        this.recordingSettingsPane.addTab("Video", null, this.videoSettingsPanel, null);
        this.videoSettingsPanel.setPreferredSize(new Dimension(112, 207));
        videoSettingsPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
        videoSettingsPanelLayout.rowHeights = new int[]{7, 7, 7, 7, 7, 7, 7, 20};
        videoSettingsPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
        videoSettingsPanelLayout.columnWidths = new int[]{115, 7, 40, 7, 20, 7, 20, 7, 20};
        this.videoSettingsPanel.setLayout(videoSettingsPanelLayout);
        this.scalingPanel = new JPanel();
        GridBagLayout scalingPanelLayout = new GridBagLayout();
        this.videoSettingsPanel.add((Component)this.scalingPanel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.scalingPanel.setBorder(BorderFactory.createTitledBorder("Scaling (%)"));
        scalingPanelLayout.rowWeights = new double[]{0.1, 0.0, 0.1};
        scalingPanelLayout.rowHeights = new int[]{7, 7, 7};
        scalingPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
        scalingPanelLayout.columnWidths = new int[]{7, 7, 7};
        this.scalingPanel.setLayout(scalingPanelLayout);
        this.scalingPanel.add((Component)this.getScreenScalingLabel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.scalingPanel.add((Component)this.getTimelineScalingLabel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.scalingPanel.add((Component)this.getScreenScaleTextField(), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.scalingPanel.add((Component)this.getTimeLineScaleTextField(), new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.inactivityPanel = new JPanel();
        GridBagLayout inactivityPanelLayout = new GridBagLayout();
        this.videoSettingsPanel.add((Component)this.inactivityPanel, new GridBagConstraints(2, 6, 8, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.videoSettingsPanel.add((Component)this.getFpsLabel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.videoSettingsPanel.add((Component)this.getFpsTextField(), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.videoSettingsPanel.add((Component)this.getImageFormatLabel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.videoSettingsPanel.add((Component)this.getImageFormatTextField(), new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.videoSettingsPanel.add((Component)this.getEncoderLabel(), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.videoSettingsPanel.add(this.getEncoderComboBox(), new GridBagConstraints(2, 4, 6, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.videoSettingsPanel.add((Component)this.getVideoBorderCheckBox(), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.videoSettingsPanel.add((Component)this.getLoopCheckBox(), new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.videoSettingsPanel.add((Component)this.getPlayCheckBox(), new GridBagConstraints(8, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.videoSettingsPanel.add((Component)this.getMouseCheckBox(), new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.videoSettingsPanel.add((Component)this.getJToobarCheckBox(), new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.inactivityPanel.setBorder(BorderFactory.createTitledBorder("Inactivity processing"));
        this.inactivityPanel.setToolTipText("Inactivity handling, enabled if audio is not being recorded.");
        inactivityPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
        inactivityPanelLayout.rowHeights = new int[]{7, 7, 7};
        inactivityPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
        inactivityPanelLayout.columnWidths = new int[]{7, 7, 7, 47, 7};
        this.inactivityPanel.setLayout(inactivityPanelLayout);
        this.inactivityPanel.setEnabled(false);
        this.inactivityCheckBox = new JCheckBox();
        this.inactivityPanel.add((Component)this.inactivityCheckBox, new GridBagConstraints(1, 0, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.inactivityCheckBox.setText("Remove inactivity");
        this.inactivityCheckBox.setEnabled(false);
        this.inactivityIntervalLabel = new JLabel();
        this.inactivityPanel.add((Component)this.inactivityIntervalLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.inactivityIntervalLabel.setText("Inactivity interval (sec)");
        this.inactivityIntervalLabel.setEnabled(false);
        this.inactivityIntervalTextField = new JTextField();
        this.inactivityPanel.add((Component)this.inactivityIntervalTextField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.inactivityIntervalTextField.setText("0.7");
        this.inactivityIntervalTextField.setEnabled(false);
        this.audioSettingsPanel = new JPanel();
        GridBagLayout audioSettingsPanelLayout = new GridBagLayout();
        this.recordingSettingsPane.addTab("Audio", null, this.audioSettingsPanel, null);
        audioSettingsPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
        audioSettingsPanelLayout.rowHeights = new int[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 20};
        audioSettingsPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
        audioSettingsPanelLayout.columnWidths = new int[]{7, 7, 49, 7, 135, 7, 20};
        this.audioSettingsPanel.setLayout(audioSettingsPanelLayout);
        this.sampleSize16Button = new JRadioButton();
        this.audioSettingsPanel.add((Component)this.sampleSize16Button, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.sampleSize16Button.setText("16");
        this.sampleSize16Button.setSelected(true);
        this.getSampleSizeButtonGroup().add(this.sampleSize16Button);
        this.sampleSize16Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CaptureOptionsDialog.this.selectSoundSource();
            }
        });
        this.recordSoundCheckBox = new JCheckBox();
        this.audioSettingsPanel.add((Component)this.recordSoundCheckBox, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.recordSoundCheckBox.setText("Record sound");
        this.recordSoundCheckBox.setSelected(true);
        this.recordSoundCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CaptureOptionsDialog.this.onSetSound();
            }
        });
        this.soundSourceLabel = new JLabel();
        this.audioSettingsPanel.add((Component)this.soundSourceLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.soundSourceLabel.setText("Source");
        this.soundLineComboBox = new JComboBox();
        this.audioSettingsPanel.add(this.soundLineComboBox, new GridBagConstraints(2, 6, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.audioSettingsPanel.add((Component)new JLabel("WAV2MP3 command"), new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mp3Text = new JTextField();
        this.audioSettingsPanel.add((Component)this.mp3Text, new GridBagConstraints(2, 8, 5, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.sampleRateLabel = new JLabel();
        this.audioSettingsPanel.add((Component)this.sampleRateLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.sampleRateLabel.setText("Sample rate (khz)");
        this.sampleSizeLabel = new JLabel();
        this.audioSettingsPanel.add((Component)this.sampleSizeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.sampleSizeLabel.setText("Sample size (bits)");
        this.stereoCheckBox = new JCheckBox();
        this.audioSettingsPanel.add((Component)this.stereoCheckBox, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.stereoCheckBox.setText("Stereo");
        this.stereoCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CaptureOptionsDialog.this.selectSoundSource();
            }
        });
        this.sampleSize8Button = new JRadioButton();
        this.audioSettingsPanel.add((Component)this.sampleSize8Button, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.sampleSize8Button.setText("8");
        this.getSampleSizeButtonGroup().add(this.sampleSize8Button);
        this.sampleSize8Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CaptureOptionsDialog.this.selectSoundSource();
            }
        });
        DefaultComboBoxModel<String> sampleRateComboBoxModel = new DefaultComboBoxModel<String>(new String[]{"5.5", "11", "22", "44"});
        this.sampleRateComboBox = new JComboBox();
        this.audioSettingsPanel.add(this.sampleRateComboBox, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.sampleRateComboBox.setModel(sampleRateComboBoxModel);
        this.sampleRateComboBox.setSelectedIndex(2);
        this.sampleRateComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CaptureOptionsDialog.this.selectSoundSource();
            }
        });
        this.getImageFormatTextField().setText(owner.getCaptureConfig().getImageFormat());
        this.recordSoundCheckBox.setSelected(owner.getCaptureConfig().isSound());
        this.stereoCheckBox.setSelected(owner.getCaptureConfig().getAudioFormat().getChannels() > 1);
        if (owner.getCaptureConfig().getAudioFormat().getSampleSizeInBits() == 8) {
            this.sampleSize8Button.setSelected(true);
        } else {
            this.sampleSize16Button.setSelected(true);
        }
        float sampleRate = owner.getCaptureConfig().getAudioFormat().getSampleRate();
        float proximity = Math.abs(sampleRate - this.sampleRates[0]);
        this.sampleRateComboBox.setSelectedIndex(0);
        for (int i = 1; i < this.sampleRates.length; ++i) {
            float prx = Math.abs(sampleRate - this.sampleRates[i]);
            if (!(prx < proximity)) continue;
            this.sampleRateComboBox.setSelectedIndex(i);
            proximity = prx;
        }
        this.inactivityCheckBox.setSelected(owner.getCaptureConfig().isRemoveInactivity());
        if (owner.getCaptureConfig().isRemoveInactivity()) {
            this.inactivityIntervalTextField.setText(String.valueOf(owner.getCaptureConfig().getInactivityInterval()));
        }
        this.onSetSound();
        this.videoBorderCheckBox.setSelected(owner.getCaptureConfig().isBorder());
        this.getMouseCheckBox().setSelected(owner.getCaptureConfig().isMouse());
        this.getLoopCheckBox().setSelected(owner.getCaptureConfig().isLoop());
        this.getPlayCheckBox().setSelected(owner.getCaptureConfig().isPlay());
        this.fpsTextField.setText(Float.toString(owner.getCaptureConfig().getFramesPerSecond()));
        this.screenScaleTextField.setText(Long.toString(Math.round(owner.getCaptureConfig().getScreenScale() * 100.0)));
        this.timeLineScaleTextField.setText(Long.toString(Math.round((double)owner.getCaptureConfig().getSpeedScale() * 100.0)));
        this.toobarCheckBox.setSelected(owner.getCaptureConfig().isToolBar());
        this.mp3Text.setText(owner.getCaptureConfig().getMp3command());
        this.selectSoundSource();
        this.soundLineComboBox.setSelectedItem(owner.getCaptureConfig().getMixerName());
        this.timeLineScaleTextField.setEnabled(!this.recordSoundCheckBox.isSelected());
        this.getEncoderComboBox().setSelectedItem(owner.getCaptureConfig().getEncoder());
        JPanel aboutPanel = new JPanel();
        aboutPanel.setLayout(new BorderLayout());
        this.recordingSettingsPane.addTab("About", aboutPanel);
        aboutPanel.add((Component)new JLabel("jCapture", 0), "North");
        aboutPanel.add((Component)new JLabel("by Hammurapi Group (http://www.hammurapi.com)", 0), "Center");
        aboutPanel.add((Component)new JLabel("Memory (available/max): " + AbstractCaptureApplet.formatByteSize(Runtime.getRuntime().freeMemory()) + "/" + AbstractCaptureApplet.formatByteSize(Runtime.getRuntime().maxMemory()), 0), "South");
        this.setSize(400, 300);
        this.setLocationRelativeTo(owner);
    }

    private void selectSoundSource() {
        this.audioFormat = new AudioFormat(this.sampleRates[this.sampleRateComboBox.getSelectedIndex()], this.sampleSize8Button.isSelected() ? 8 : 16, this.stereoCheckBox.isSelected() ? 2 : 1, true, false);
        String sourceName = (String)this.soundLineComboBox.getSelectedItem();
        if (this.soundLineComboBoxModel == null) {
            this.soundLineComboBoxModel = new DefaultComboBoxModel();
            this.soundLineComboBox.setModel(this.soundLineComboBoxModel);
        } else {
            this.soundLineComboBoxModel.removeAllElements();
        }
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.audioFormat);
        boolean hasSourceName = false;
        for (Mixer.Info mi : AudioSystem.getMixerInfo()) {
            Mixer mx = AudioSystem.getMixer(mi);
            if (!mx.isLineSupported(info)) continue;
            this.soundLineComboBoxModel.addElement(mi.getName());
            if (sourceName == null || !mi.getName().equals(sourceName)) continue;
            hasSourceName = true;
        }
        if (hasSourceName) {
            this.soundLineComboBoxModel.setSelectedItem(sourceName);
        }
    }

    private ButtonGroup getSampleSizeButtonGroup() {
        if (this.sampleSizeButtonGroup == null) {
            this.sampleSizeButtonGroup = new ButtonGroup();
        }
        return this.sampleSizeButtonGroup;
    }

    private JLabel getFpsLabel() {
        if (this.fpsLabel == null) {
            this.fpsLabel = new JLabel();
            this.fpsLabel.setText("Frames Per Second");
        }
        return this.fpsLabel;
    }

    private JTextField getFpsTextField() {
        if (this.fpsTextField == null) {
            this.fpsTextField = new JTextField();
            this.fpsTextField.setText("10");
            this.fpsTextField.setSize(30, 23);
        }
        return this.fpsTextField;
    }

    private JLabel getImageFormatLabel() {
        if (this.imageFormatLabel == null) {
            this.imageFormatLabel = new JLabel();
            this.imageFormatLabel.setText("Image format");
        }
        return this.imageFormatLabel;
    }

    private JTextField getImageFormatTextField() {
        if (this.imageFormatTextField == null) {
            this.imageFormatTextField = new JTextField();
            this.imageFormatTextField.setText("png");
            this.imageFormatTextField.setSize(30, 23);
        }
        return this.imageFormatTextField;
    }

    private JLabel getEncoderLabel() {
        if (this.encoderLabel == null) {
            this.encoderLabel = new JLabel();
            this.encoderLabel.setText("Video format");
        }
        return this.encoderLabel;
    }

    private JComboBox<VideoEncoder> getEncoderComboBox() {
        if (this.encodersComboBox == null) {
            List<VideoEncoder> el = ((CaptureFrame)this.getOwner()).getCaptureConfig().getEncoders();
            this.encodersComboBox = new JComboBox<VideoEncoder>(el.toArray(new VideoEncoder[el.size()]));
        }
        return this.encodersComboBox;
    }

    private JLabel getScreenScalingLabel() {
        if (this.screenScalingLabel == null) {
            this.screenScalingLabel = new JLabel();
            this.screenScalingLabel.setText("Graphics");
        }
        return this.screenScalingLabel;
    }

    private JLabel getTimelineScalingLabel() {
        if (this.timelineScalingLabel == null) {
            this.timelineScalingLabel = new JLabel();
            this.timelineScalingLabel.setText("Speed");
        }
        return this.timelineScalingLabel;
    }

    private JTextField getScreenScaleTextField() {
        if (this.screenScaleTextField == null) {
            this.screenScaleTextField = new JTextField();
            this.screenScaleTextField.setText("100");
        }
        return this.screenScaleTextField;
    }

    private JTextField getTimeLineScaleTextField() {
        if (this.timeLineScaleTextField == null) {
            this.timeLineScaleTextField = new JTextField();
            this.timeLineScaleTextField.setText("100");
        }
        return this.timeLineScaleTextField;
    }

    private JCheckBox getVideoBorderCheckBox() {
        if (this.videoBorderCheckBox == null) {
            this.videoBorderCheckBox = new JCheckBox();
            this.videoBorderCheckBox.setText("Border");
        }
        return this.videoBorderCheckBox;
    }

    private JCheckBox getMouseCheckBox() {
        if (this.mouseCheckBox == null) {
            this.mouseCheckBox = new JCheckBox();
            this.mouseCheckBox.setText("Mouse");
        }
        return this.mouseCheckBox;
    }

    private JCheckBox getLoopCheckBox() {
        if (this.loopCheckBox == null) {
            this.loopCheckBox = new JCheckBox();
            this.loopCheckBox.setText("Loop");
        }
        return this.loopCheckBox;
    }

    private JCheckBox getPlayCheckBox() {
        if (this.playCheckBox == null) {
            this.playCheckBox = new JCheckBox();
            this.playCheckBox.setText("Play");
        }
        return this.playCheckBox;
    }

    private JCheckBox getJToobarCheckBox() {
        if (this.toobarCheckBox == null) {
            this.toobarCheckBox = new JCheckBox();
            this.toobarCheckBox.setText("Toolbar");
            this.toobarCheckBox.setSelected(true);
        }
        return this.toobarCheckBox;
    }

    void onSetSound() {
        for (Component child : this.recordSoundCheckBox.getParent().getComponents()) {
            if (child == this.recordSoundCheckBox) continue;
            child.setEnabled(this.recordSoundCheckBox.isSelected());
        }
        this.inactivityPanel.setEnabled(!this.recordSoundCheckBox.isSelected());
        this.timeLineScaleTextField.setEnabled(!this.recordSoundCheckBox.isSelected());
        for (Component child : this.inactivityPanel.getComponents()) {
            child.setEnabled(!this.recordSoundCheckBox.isSelected());
        }
    }
}

