/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.movie;

import com.flagstone.transform.util.movie.Frame;
import java.util.ArrayList;
import java.util.List;

public final class Layer {
    private final transient int layerNumber;
    private final transient List<Frame> frames;

    public static List<Frame> merge(List<Layer> layers) {
        int lastFrame = 0;
        for (Layer layer : layers) {
            for (Frame frame : layer.getFrames()) {
                if (frame.getNumber() <= lastFrame) continue;
                lastFrame = frame.getNumber();
            }
        }
        ArrayList<Frame> merged = new ArrayList<Frame>(lastFrame);
        for (int i = 1; i <= lastFrame; ++i) {
            merged.add(new Frame(i));
        }
        for (Layer layer : layers) {
            for (Frame frame : layer.getFrames()) {
                Frame selected = merged.get(frame.getNumber() - 1);
                selected.setActions(frame.getActions());
                selected.setCommands(frame.getCommands());
                selected.setDefinitions(frame.getDefinitions());
                if (frame.getLabel() == null) continue;
                selected.setLabel(frame.getLabel());
            }
        }
        return merged;
    }

    public Layer(int number) {
        this.layerNumber = number;
        this.frames = new ArrayList<Frame>();
    }

    public int getLayer() {
        return this.layerNumber;
    }

    public List<Frame> getFrames() {
        return this.frames;
    }

    public Layer add(Frame frame) {
        this.frames.add(frame);
        frame.setNumber(this.frames.size());
        return this;
    }
}

