/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.font;

import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.font.CharacterFormat;
import com.flagstone.transform.font.DefineFont2;
import com.flagstone.transform.font.Kerning;
import com.flagstone.transform.shape.Shape;
import com.flagstone.transform.util.font.FontFace;
import com.flagstone.transform.util.font.Glyph;
import java.util.ArrayList;
import java.util.List;

public final class Font {
    private FontFace face;
    private CharacterFormat encoding;
    private int ascent;
    private int descent;
    private int leading;
    private transient int[] charToGlyph;
    private transient int[] glyphToChar;
    private transient Glyph[] glyphTable;
    private transient int glyphIndex;
    private transient int glyphCount;
    private transient int missingGlyph;
    private transient char highestChar;
    private final transient List<Kerning> kernings = new ArrayList<Kerning>();

    public FontFace getFace() {
        return this.face;
    }

    public void setFace(FontFace fontFace) {
        this.face = fontFace;
    }

    public CharacterFormat getEncoding() {
        return this.encoding;
    }

    public void setEncoding(CharacterFormat enc) {
        this.encoding = enc;
    }

    public int getAscent() {
        return this.ascent;
    }

    public void setAscent(int dist) {
        if (dist < Short.MIN_VALUE || dist > Short.MAX_VALUE) {
            throw new IllegalArgumentRangeException(Short.MIN_VALUE, Short.MAX_VALUE, dist);
        }
        this.ascent = dist;
    }

    public int getDescent() {
        return this.descent;
    }

    public void setDescent(int dist) {
        if (dist < Short.MIN_VALUE || dist > Short.MAX_VALUE) {
            throw new IllegalArgumentRangeException(Short.MIN_VALUE, Short.MAX_VALUE, dist);
        }
        this.descent = dist;
    }

    public int getLeading() {
        return this.leading;
    }

    public void setLeading(int dist) {
        if (dist < Short.MIN_VALUE || dist > Short.MAX_VALUE) {
            throw new IllegalArgumentRangeException(Short.MIN_VALUE, Short.MAX_VALUE, dist);
        }
        this.leading = dist;
    }

    public int getNumberOfGlyphs() {
        return this.glyphCount;
    }

    public void setNumberOfGlyphs(int count) {
        this.glyphTable = new Glyph[count];
        this.glyphToChar = new int[count];
        this.glyphIndex = 0;
    }

    public char getHighestChar() {
        return this.highestChar;
    }

    public void setHighestChar(char highest) {
        this.highestChar = highest;
        this.charToGlyph = new int[highest + '\u0001'];
    }

    public int getMissingGlyph() {
        return this.missingGlyph;
    }

    public void setMissingGlyph(int index) {
        this.missingGlyph = index;
    }

    public Glyph getGlyph(int index) {
        return this.glyphTable[index];
    }

    public void addGlyph(char code, Glyph glyph) {
        this.glyphTable[this.glyphIndex] = glyph;
        this.glyphToChar[this.glyphIndex] = code;
        this.charToGlyph[code] = this.glyphIndex++;
    }

    public void addMissingGlyph(char code) {
        this.charToGlyph[code] = this.missingGlyph;
    }

    public DefineFont2 defineFont(int identifier, List<Character> characters) {
        DefineFont2 fontDefinition = null;
        int count = characters.size();
        ArrayList<Shape> glyphsArray = new ArrayList<Shape>(count);
        ArrayList<Integer> codesArray = new ArrayList<Integer>(count);
        ArrayList<Integer> advancesArray = new ArrayList<Integer>(count);
        ArrayList<Bounds> boundsArray = new ArrayList<Bounds>(count);
        for (Character character : characters) {
            Glyph glyph = this.glyphTable[this.charToGlyph[character.charValue()]];
            glyphsArray.add(glyph.getShape());
            codesArray.add(Integer.valueOf(character.charValue()));
            advancesArray.add(glyph.getAdvance());
            if (glyph.getBounds() == null) continue;
            boundsArray.add(glyph.getBounds());
        }
        fontDefinition = new DefineFont2(identifier, this.face.getName());
        fontDefinition.setEncoding(this.encoding);
        fontDefinition.setItalic(this.face.isItalic());
        fontDefinition.setBold(this.face.isBold());
        fontDefinition.setAscent(this.ascent);
        fontDefinition.setDescent(this.descent);
        fontDefinition.setLeading(this.leading);
        fontDefinition.setShapes(glyphsArray);
        fontDefinition.setCodes(codesArray);
        fontDefinition.setAdvances(advancesArray);
        fontDefinition.setBounds(boundsArray);
        fontDefinition.setKernings(this.kernings);
        return fontDefinition;
    }

    public int canDisplay(String aString) {
        int firstMissingChar = -1;
        for (int i = 0; i < aString.length(); ++i) {
            if (this.canDisplay(aString.charAt(i))) continue;
            firstMissingChar = i;
            break;
        }
        return firstMissingChar;
    }

    public boolean canDisplay(char character) {
        boolean canDisplay = character < this.charToGlyph.length && (character == ' ' || this.charToGlyph[character] != 0);
        return canDisplay;
    }

    public int glyphForCharacter(char character) {
        return this.charToGlyph[character];
    }

    public char characterForGlyph(int index) {
        return (char)this.glyphToChar[index];
    }

    public int advanceForCharacter(char character) {
        return this.glyphTable[this.charToGlyph[character]].getAdvance();
    }
}

