/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.text;

import java.util.LinkedHashMap;
import java.util.Map;

public enum Language {
    NONE(0),
    TRADITIONAL_CHINESE(5),
    SIMPLIFIED_CHINESE(4),
    KOREAN(3),
    JAPANESE(2),
    LATIN(1);

    private static final Map<Integer, Language> TABLE;
    private final int value;

    public static Language fromInt(int code) {
        return TABLE.get(code);
    }

    private Language(int keyCode) {
        this.value = keyCode;
    }

    public int getValue() {
        return this.value;
    }

    static {
        TABLE = new LinkedHashMap<Integer, Language>();
        for (Language type : Language.values()) {
            TABLE.put(type.value, type);
        }
    }
}

