/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.image;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;
import java.util.Arrays;

public final class JPEGEncodingTable
implements MovieTag {
    private static final String FORMAT = "JPEGEncodingTable: { table=byte<%d> ...}";
    private byte[] table;
    private transient int length;

    public JPEGEncodingTable(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.table = coder.readBytes(new byte[this.length]);
        coder.check(this.length);
        coder.unmark();
    }

    public JPEGEncodingTable(byte[] bytes) {
        this.setTable(bytes);
    }

    public JPEGEncodingTable(JPEGEncodingTable object) {
        this.table = object.table;
    }

    public byte[] getTable() {
        return Arrays.copyOf(this.table, this.table.length);
    }

    public void setTable(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        this.table = Arrays.copyOf(bytes, bytes.length);
    }

    @Override
    public JPEGEncodingTable copy() {
        return new JPEGEncodingTable(this);
    }

    public String toString() {
        return String.format(FORMAT, this.table.length);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = this.table.length;
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(575);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x200 | this.length);
        }
        coder.mark();
        coder.writeBytes(this.table);
        coder.check(this.length);
        coder.unmark();
    }
}

