/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.font;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class FontName
implements MovieTag {
    private static final String FORMAT = "DefineFontName: { identifier=%d; name=%s; copyright=%s}";
    private int identifier;
    private String name;
    private String copyright;
    private transient int length;

    public FontName(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        this.name = coder.readString();
        this.copyright = coder.readString();
        coder.check(this.length);
        coder.unmark();
    }

    public FontName(int uid, String fontName, String copyrightNotice) {
        this.setIdentifier(uid);
        this.setName(fontName);
        this.setCopyright(copyrightNotice);
    }

    public FontName(FontName object) {
        this.identifier = object.identifier;
        this.name = object.name;
        this.copyright = object.copyright;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aString) {
        if (aString == null) {
            throw new IllegalArgumentException();
        }
        this.name = aString;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String notice) {
        if (notice == null) {
            throw new IllegalArgumentException();
        }
        this.copyright = notice;
    }

    @Override
    public FontName copy() {
        return new FontName(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.name, this.copyright);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 2 + context.strlen(this.name) + context.strlen(this.copyright);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(5695);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x1600 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        coder.writeString(this.name);
        coder.writeString(this.copyright);
        coder.check(this.length);
        coder.unmark();
    }
}

