/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.font;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.font.CharacterFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class FontInfo
implements MovieTag {
    private static final String FORMAT = "FontInfo: { identifier=%d; encoding=%s; small=%s; italic=%s; bold=%s; name=%s; codes=%s}";
    private int identifier;
    private String name;
    private int encoding;
    private boolean small;
    private boolean italic;
    private boolean bold;
    private List<Integer> codes;
    private transient int length;
    private transient boolean wideCodes = false;

    public FontInfo(SWFDecoder coder) throws IOException {
        int bits;
        this.codes = new ArrayList<Integer>();
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        int nameLength = coder.readByte();
        this.name = coder.readString(nameLength);
        if (this.name.length() > 0) {
            while (this.name.charAt(this.name.length() - 1) == '\u0000') {
                this.name = this.name.substring(0, this.name.length() - 1);
            }
        }
        this.small = ((bits = coder.readByte()) & 0x20) != 0;
        this.encoding = bits >> 3 & 7;
        this.italic = (bits & 4) != 0;
        this.bold = (bits & 2) != 0;
        boolean bl = this.wideCodes = (bits & 1) != 0;
        if (this.wideCodes) {
            while (coder.bytesRead() < this.length) {
                this.codes.add(coder.readUnsignedShort());
            }
        } else {
            while (coder.bytesRead() < this.length) {
                this.codes.add(coder.readByte());
            }
        }
        coder.check(this.length);
        coder.unmark();
    }

    public FontInfo(int uid, String fontName, boolean isBold, boolean isItalic) {
        this.setIdentifier(uid);
        this.setName(fontName);
        this.setItalic(isItalic);
        this.setBold(isBold);
        this.small = false;
        this.encoding = 0;
        this.codes = new ArrayList<Integer>();
    }

    public FontInfo(FontInfo object) {
        this.identifier = object.identifier;
        this.name = object.name;
        this.italic = object.italic;
        this.bold = object.bold;
        this.small = object.small;
        this.encoding = object.encoding;
        this.codes = new ArrayList<Integer>(object.codes);
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public CharacterFormat getEncoding() {
        CharacterFormat value;
        switch (this.encoding) {
            case 0: {
                value = CharacterFormat.UCS2;
                break;
            }
            case 1: {
                value = CharacterFormat.ANSI;
                break;
            }
            case 2: {
                value = CharacterFormat.SJIS;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return value;
    }

    public boolean isSmall() {
        return this.small;
    }

    public void setSmall(boolean aBool) {
        this.small = aBool;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isBold() {
        return this.bold;
    }

    public List<Integer> getCodes() {
        return this.codes;
    }

    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public void setName(String aString) {
        if (aString == null) {
            throw new IllegalArgumentException();
        }
        this.name = aString;
    }

    public void setEncoding(CharacterFormat anEncoding) {
        switch (anEncoding) {
            case UCS2: {
                this.encoding = 0;
                break;
            }
            case ANSI: {
                this.encoding = 1;
                break;
            }
            case SJIS: {
                this.encoding = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setItalic(boolean aBool) {
        this.italic = aBool;
    }

    public void setBold(boolean aBool) {
        this.bold = aBool;
    }

    public void addCode(int aCode) {
        if (aCode < 0 || aCode > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, aCode);
        }
        this.codes.add(aCode);
    }

    public void setCodes(List<Integer> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.codes = list;
    }

    @Override
    public FontInfo copy() {
        return new FontInfo(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.encoding, this.small, this.italic, this.bold, this.name, this.codes);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 4;
        this.length += context.strlen(this.name);
        this.wideCodes = false;
        for (Integer code : this.codes) {
            if (code <= 255) continue;
            this.wideCodes = true;
        }
        this.length += this.codes.size() * (this.wideCodes ? 2 : 1);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(895);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x340 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        coder.writeByte(context.strlen(this.name));
        coder.writeString(this.name);
        int bits = 0;
        bits |= this.small ? 32 : 0;
        bits |= this.encoding << 3;
        bits |= this.italic ? 4 : 0;
        bits |= this.bold ? 2 : 0;
        coder.writeByte(bits |= this.wideCodes ? 1 : 0);
        if (this.wideCodes) {
            for (Integer code : this.codes) {
                coder.writeShort(code);
            }
        } else {
            for (Integer code : this.codes) {
                coder.writeByte(code);
            }
        }
        coder.check(this.length);
        coder.unmark();
    }
}

