/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.font;

import com.flagstone.transform.DefineTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.shape.Shape;
import com.flagstone.transform.shape.ShapeData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DefineFont
implements DefineTag {
    private static final String FORMAT = "DefineFont: { identifier=%d; shapes=%s}";
    private int identifier;
    private List<Shape> shapes;
    private transient int length;
    private transient int[] table;

    public DefineFont(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        this.shapes = new ArrayList<Shape>();
        int first = coder.readUnsignedShort();
        int count = first >> 1;
        this.table = new int[count + 1];
        this.table[0] = first;
        for (int i = 1; i < count; ++i) {
            this.table[i] = coder.readUnsignedShort();
        }
        this.table[count] = this.length - 2;
        for (int i = 0; i < count; ++i) {
            Shape shape = new Shape();
            shape.add(new ShapeData(this.table[i + 1] - this.table[i], coder));
            this.shapes.add(shape);
        }
        coder.check(this.length);
        coder.unmark();
    }

    public DefineFont(int uid, List<Shape> list) {
        this.setIdentifier(uid);
        this.setShapes(list);
    }

    public DefineFont(DefineFont object) {
        this.identifier = object.identifier;
        this.shapes = new ArrayList<Shape>(object.shapes.size());
        for (Shape shape : object.shapes) {
            this.shapes.add(shape.copy());
        }
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public DefineFont add(Shape obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        this.shapes.add(obj);
        return this;
    }

    public List<Shape> getShapes() {
        return this.shapes;
    }

    public void setShapes(List<Shape> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.shapes = list;
    }

    @Override
    public DefineFont copy() {
        return new DefineFont(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.shapes);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 2;
        context.put(11, 1);
        context.put(12, context.contains(9) ? 1 : 0);
        int count = this.shapes.size();
        int index = 0;
        int tableEntry = count << 1;
        this.table = new int[count + 1];
        this.length += count << 1;
        this.table[index++] = tableEntry;
        for (Shape shape : this.shapes) {
            int shapeLength = shape.prepareToEncode(context);
            this.table[index++] = tableEntry += shapeLength;
            this.length += shapeLength;
        }
        context.put(11, 0);
        context.put(12, 0);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(703);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x280 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        context.put(11, 1);
        context.put(12, context.contains(9) ? 1 : 0);
        for (int i = 0; i < this.table.length - 1; ++i) {
            coder.writeShort(this.table[i]);
        }
        for (Shape shape : this.shapes) {
            shape.encode(coder, context);
        }
        context.put(11, 0);
        context.put(12, 0);
        coder.check(this.length);
        coder.unmark();
    }
}

