/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.filter;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.filter.Filter;
import java.io.IOException;
import java.util.Arrays;

public final class ColorMatrixFilter
implements Filter {
    private static final String FORMAT = "ColorMatrix: { matrix=[[%f %f %f %f %f];[%f %f %f %f %f];[%f %f %f %f %f];[%f %f %f %f %f];]}";
    private static final int MATRIX_SIZE = 20;
    private final transient float[] matrix;

    public ColorMatrixFilter(SWFDecoder coder) throws IOException {
        this.matrix = new float[20];
        for (int i = 0; i < 20; ++i) {
            this.matrix[i] = Float.intBitsToFloat(coder.readInt());
        }
    }

    public ColorMatrixFilter(float[] aMatrix) {
        if (aMatrix == null || aMatrix.length != 20) {
            throw new IllegalArgumentException("Value not set");
        }
        this.matrix = Arrays.copyOf(aMatrix, aMatrix.length);
    }

    public float[] getMatrix() {
        return Arrays.copyOf(this.matrix, this.matrix.length);
    }

    public String toString() {
        return String.format(FORMAT, Float.valueOf(this.matrix[0]), Float.valueOf(this.matrix[1]), Float.valueOf(this.matrix[2]), Float.valueOf(this.matrix[3]), Float.valueOf(this.matrix[4]), Float.valueOf(this.matrix[5]), Float.valueOf(this.matrix[6]), Float.valueOf(this.matrix[7]), Float.valueOf(this.matrix[8]), Float.valueOf(this.matrix[9]), Float.valueOf(this.matrix[10]), Float.valueOf(this.matrix[11]), Float.valueOf(this.matrix[12]), Float.valueOf(this.matrix[13]), Float.valueOf(this.matrix[14]), Float.valueOf(this.matrix[15]), Float.valueOf(this.matrix[16]), Float.valueOf(this.matrix[17]), Float.valueOf(this.matrix[18]), Float.valueOf(this.matrix[19]));
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == null) {
            result = false;
        } else if (object == this) {
            result = true;
        } else if (object instanceof ColorMatrixFilter) {
            ColorMatrixFilter filter = (ColorMatrixFilter)object;
            result = Arrays.equals(this.matrix, filter.matrix);
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return Arrays.hashCode(this.matrix);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 81;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(6);
        for (float value : this.matrix) {
            coder.writeInt(Float.floatToIntBits(value));
        }
    }
}

