/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.coder;

import com.flagstone.transform.CharacterEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Stack;

public final class SWFDecoder {
    public static final int BUFFER_SIZE = 4096;
    private static final int STR_BUFFER_SIZE = 1024;
    private static final int BYTE_MASK = 255;
    private static final int TO_BYTE1 = 8;
    private static final int TO_BYTE2 = 16;
    private static final int TO_BYTE3 = 24;
    private static final int BITS_PER_INT = 32;
    private static final int BITS_PER_BYTE = 8;
    private static final int BITS_TO_BYTES = 3;
    private static final int BYTES_TO_BITS = 3;
    private final transient InputStream stream;
    private final transient byte[] buffer;
    private transient byte[] stringBuffer;
    private transient String encoding;
    private final transient Stack<Integer> locations;
    private transient int pos;
    private transient int index;
    private transient int offset;
    private transient int size;
    private transient int location;
    private transient int expected;
    private transient int delta;
    private static final int HALF_SIGN_SHIFT = 15;
    private static final int HALF_EXP_SHIFT = 10;
    private static final int HALF_EXP_OFFSET = 15;
    private static final int HALF_EXP_MAX = 31;
    private static final int SIGN_SHIFT = 31;
    private static final int EXP_SHIFT = 23;
    private static final int EXP_MAX = 127;
    private static final int MANT_SHIFT = 13;
    private static final int INFINITY = 2139095040;

    public SWFDecoder(InputStream streamIn, int length) {
        this.stream = streamIn;
        this.buffer = new byte[length];
        this.stringBuffer = new byte[1024];
        this.encoding = CharacterEncoding.UTF8.getEncoding();
        this.locations = new Stack();
    }

    public SWFDecoder(InputStream streamIn) {
        this.stream = streamIn;
        this.buffer = new byte[4096];
        this.stringBuffer = new byte[4096];
        this.encoding = CharacterEncoding.UTF8.getEncoding();
        this.locations = new Stack();
    }

    public void fill() throws IOException {
        int diff = this.size - this.index;
        this.pos += this.index;
        if (this.index < this.size) {
            for (int i = 0; i < diff; ++i) {
                this.buffer[i] = this.buffer[this.index++];
            }
        }
        int bytesRead = 0;
        int bytesToRead = this.buffer.length - diff;
        this.index = diff;
        this.size = diff;
        do {
            if ((bytesRead = this.stream.read(this.buffer, this.index, bytesToRead)) == -1) {
                bytesToRead = 0;
                continue;
            }
            this.index += bytesRead;
            this.size += bytesRead;
            bytesToRead -= bytesRead;
        } while (bytesToRead > 0);
        this.index = 0;
    }

    public int mark() {
        return this.locations.push(this.pos + this.index);
    }

    public void unmark() {
        this.locations.pop();
    }

    public void reset() throws IOException {
        int last = this.locations.isEmpty() ? 0 : this.locations.peek();
        if (last - this.pos < 0) {
            throw new IOException();
        }
        this.index = last - this.pos;
    }

    public void check(int count) {
        this.expected = count;
        this.location = this.locations.peek();
        this.delta = count - (this.pos + this.index - this.location);
    }

    public int getLocation() {
        return this.location;
    }

    public int getExpected() {
        return this.expected;
    }

    public int getDelta() {
        return this.delta;
    }

    public int bytesRead() {
        return this.pos + this.index - this.locations.peek();
    }

    public void alignToByte() {
        if (this.offset > 0) {
            ++this.index;
            this.offset = 0;
        }
    }

    public void skip(int count) throws IOException {
        if (this.size - this.index == 0) {
            this.fill();
        }
        if (count < this.size - this.index) {
            this.index += count;
        } else {
            int toSkip = count;
            while (toSkip > 0) {
                int diff = this.size - this.index;
                if (toSkip <= diff) {
                    this.index += toSkip;
                    toSkip = 0;
                    continue;
                }
                this.index += diff;
                toSkip -= diff;
                this.fill();
                if (this.size - this.index != 0) continue;
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public int readBits(int numberOfBits, boolean signed) throws IOException {
        int pointer = (this.index << 3) + this.offset;
        if ((this.size << 3) - pointer < numberOfBits) {
            this.fill();
            pointer = (this.index << 3) + this.offset;
        }
        int value = 0;
        if (numberOfBits > 0) {
            if (pointer + numberOfBits > this.size << 3) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (int i = 32; i > 0 && this.index < this.buffer.length; i -= 8) {
                value |= (this.buffer[this.index++] & 0xFF) << i - 8;
            }
            value <<= this.offset;
            value = signed ? (value >>= 32 - numberOfBits) : (value >>>= 32 - numberOfBits);
            this.index = (pointer += numberOfBits) >>> 3;
            this.offset = pointer & 7;
        }
        return value;
    }

    public int scanBits(int numberOfBits, boolean signed) throws IOException {
        int pointer = (this.index << 3) + this.offset;
        if ((this.size << 3) - pointer < numberOfBits) {
            this.fill();
            pointer = (this.index << 3) + this.offset;
        }
        int value = 0;
        if (numberOfBits > 0) {
            if (pointer + numberOfBits > this.size << 3) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (int i = 32; i > 0 && this.index < this.buffer.length; i -= 8) {
                value |= (this.buffer[this.index++] & 0xFF) << i - 8;
            }
            value <<= this.offset;
            value = signed ? (value >>= 32 - numberOfBits) : (value >>>= 32 - numberOfBits);
            this.index = pointer >>> 3;
            this.offset = pointer & 7;
        }
        return value;
    }

    public int scanByte() throws IOException {
        if (this.size - this.index < 1) {
            this.fill();
        }
        if (this.index + 1 > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.buffer[this.index] & 0xFF;
    }

    public int readByte() throws IOException {
        if (this.size - this.index < 1) {
            this.fill();
        }
        if (this.index + 1 > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.buffer[this.index++] & 0xFF;
    }

    public byte[] readBytes(byte[] bytes) throws IOException {
        int wanted = bytes.length;
        int dest = 0;
        int read = 0;
        while (read < wanted) {
            int available = this.size - this.index;
            int remaining = wanted - read;
            if (available > remaining) {
                available = remaining;
            }
            System.arraycopy(this.buffer, this.index, bytes, dest, available);
            read += available;
            this.index += available;
            dest += available;
            if (this.index != this.size) continue;
            this.fill();
        }
        return bytes;
    }

    public void setEncoding(CharacterEncoding enc) {
        this.encoding = enc.getEncoding();
    }

    public String readString(int length) throws IOException {
        byte[] bytes = new byte[length];
        this.readBytes(bytes);
        int len = bytes[length - 1] == 0 ? length - 1 : length;
        return new String(bytes, 0, len, this.encoding);
    }

    public String readString() throws IOException {
        int start = this.index;
        int length = 0;
        int dest = 0;
        boolean finished = false;
        while (!finished) {
            int available = this.size - this.index;
            if (available == 0) {
                this.fill();
                available = this.size - this.index;
            }
            start = this.index;
            int count = 0;
            for (int i = 0; i < available; ++i) {
                if (this.buffer[this.index++] == 0) {
                    finished = true;
                    break;
                }
                ++length;
                ++count;
            }
            if (this.stringBuffer.length < length) {
                this.stringBuffer = Arrays.copyOf(this.stringBuffer, length << 2);
            }
            System.arraycopy(this.buffer, start, this.stringBuffer, dest, count);
            dest += length;
        }
        return new String(this.stringBuffer, 0, length, this.encoding);
    }

    public int scanUnsignedShort() throws IOException {
        if (this.size - this.index < 2) {
            this.fill();
        }
        if (this.index + 2 > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int value = this.buffer[this.index] & 0xFF;
        return value |= (this.buffer[this.index + 1] & 0xFF) << 8;
    }

    public int readUnsignedShort() throws IOException {
        if (this.size - this.index < 2) {
            this.fill();
        }
        if (this.index + 2 > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int value = this.buffer[this.index++] & 0xFF;
        return value |= (this.buffer[this.index++] & 0xFF) << 8;
    }

    public int readSignedShort() throws IOException {
        if (this.size - this.index < 2) {
            this.fill();
        }
        if (this.index + 2 > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int value = this.buffer[this.index++] & 0xFF;
        return value |= this.buffer[this.index++] << 8;
    }

    public int readInt() throws IOException {
        if (this.size - this.index < 4) {
            this.fill();
        }
        if (this.index + 4 > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int value = this.buffer[this.index++] & 0xFF;
        value |= (this.buffer[this.index++] & 0xFF) << 8;
        value |= (this.buffer[this.index++] & 0xFF) << 16;
        return value |= (this.buffer[this.index++] & 0xFF) << 24;
    }

    public int readVarInt() throws IOException {
        if (this.size - this.index < 5) {
            this.fill();
        }
        int value = this.buffer[this.index++] & 0xFF;
        int mask = -1;
        int test = 128;
        int step = 7;
        while ((value & test) != 0) {
            value = ((this.buffer[this.index++] & 0xFF) << step) + (value & -1 >>> 32 - step);
            test <<= 7;
            step += 7;
        }
        return value;
    }

    public float readHalf() throws IOException {
        float value;
        int bits = this.readUnsignedShort();
        int sign = bits >> 15 & 1;
        int exp = bits >> 10 & 0x1F;
        int mantissa = bits & 0x3FF;
        if (exp == 0) {
            if (mantissa == 0) {
                value = Float.intBitsToFloat(sign << 31);
            } else {
                while ((mantissa & 0x400) == 0) {
                    mantissa <<= 1;
                    --exp;
                }
                ++exp;
                mantissa &= 0xFFFFFBFF;
                value = Float.intBitsToFloat(sign << 31 | (exp += 112) << 23 | (mantissa <<= 13));
            }
        } else {
            value = exp == 31 ? (mantissa == 0 ? Float.intBitsToFloat(sign << 31 | 0x7F800000) : Float.intBitsToFloat(sign << 31 | 0x7F800000 | mantissa << 13)) : Float.intBitsToFloat(sign << 31 | (exp += 112) << 23 | (mantissa <<= 13));
        }
        return value;
    }
}

