/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.action;

import com.flagstone.transform.action.Action;
import com.flagstone.transform.action.Null;
import com.flagstone.transform.action.Property;
import com.flagstone.transform.action.RegisterIndex;
import com.flagstone.transform.action.TableIndex;
import com.flagstone.transform.action.Void;
import com.flagstone.transform.coder.CoderException;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Push
implements Action {
    private static final int BITS_PER_INT = 32;
    private static final int LAST_REGISTER = 255;
    private static final long MASK_32 = 0xFFFFFFFFL;
    private static final long WORD_ALIGN = 32L;
    private static final String FORMAT = "Push: %s";
    private static final int TYPE_STRING = 0;
    private static final int TYPE_PROPERTY = 1;
    private static final int TYPE_NULL = 2;
    private static final int TYPE_VOID = 3;
    private static final int TYPE_REGISTER = 4;
    private static final int TYPE_BOOLEAN = 5;
    private static final int TYPE_DOUBLE = 6;
    private static final int TYPE_INTEGER = 7;
    private static final int TYPE_TINDEX = 8;
    private static final int TYPE_LARGE_TINDEX = 9;
    private static final int LENGTH_PROPERTY = 5;
    private static final int LENGTH_NULL = 1;
    private static final int LENGTH_VOID = 1;
    private static final int LENGTH_RINDEX = 2;
    private static final int LENGTH_BOOLEAN = 2;
    private static final int LENGTH_DOUBLE = 9;
    private static final int LENGTH_INTEGER = 5;
    private static final int LENGTH_TINDEX = 2;
    private static final int LENGTH_LTINDEX = 3;
    private final transient List<Object> values;
    private transient int length;

    public Push(SWFDecoder coder, Context context) throws IOException {
        this.length = coder.readUnsignedShort();
        this.values = new ArrayList<Object>();
        int valuesLength = this.length;
        while (valuesLength > 0) {
            int dataType = coder.readByte();
            switch (dataType) {
                case 0: {
                    String str = coder.readString();
                    this.values.add(str);
                    valuesLength -= 1 + context.strlen(str);
                    break;
                }
                case 1: {
                    if (context.get(1) < 5) {
                        this.values.add(new Property((int)Float.intBitsToFloat(coder.readInt())));
                    } else {
                        this.values.add(new Property(coder.readInt()));
                    }
                    valuesLength -= 5;
                    break;
                }
                case 2: {
                    this.values.add(Null.getInstance());
                    --valuesLength;
                    break;
                }
                case 3: {
                    this.values.add(Void.getInstance());
                    --valuesLength;
                    break;
                }
                case 4: {
                    this.values.add(new RegisterIndex(coder.readByte()));
                    valuesLength -= 2;
                    break;
                }
                case 5: {
                    this.values.add(coder.readByte() != 0);
                    valuesLength -= 2;
                    break;
                }
                case 6: {
                    long longValue = (long)coder.readInt() << 32;
                    this.values.add(Double.longBitsToDouble(longValue |= (long)coder.readInt() & 0xFFFFFFFFL));
                    valuesLength -= 9;
                    break;
                }
                case 7: {
                    this.values.add(coder.readInt());
                    valuesLength -= 5;
                    break;
                }
                case 8: {
                    this.values.add(new TableIndex(coder.readByte()));
                    valuesLength -= 2;
                    break;
                }
                case 9: {
                    this.values.add(new TableIndex(coder.readUnsignedShort()));
                    valuesLength -= 3;
                    break;
                }
            }
        }
    }

    public Push(List<Object> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.values = new ArrayList<Object>(list);
    }

    public Push(Push object) {
        this.values = new ArrayList<Object>(object.values);
    }

    public List<Object> getValues() {
        return new ArrayList<Object>(this.values);
    }

    @Override
    public Push copy() {
        return this;
    }

    public String toString() {
        return String.format(FORMAT, this.values);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 0;
        for (Object obj : this.values) {
            if (obj instanceof Boolean) {
                this.length += 2;
                continue;
            }
            if (obj instanceof Property) {
                this.length += 5;
                continue;
            }
            if (obj instanceof Integer) {
                this.length += 5;
                continue;
            }
            if (obj instanceof Double) {
                this.length += 9;
                continue;
            }
            if (obj instanceof String) {
                this.length += 1 + context.strlen(obj.toString());
                continue;
            }
            if (obj instanceof Null) {
                ++this.length;
                continue;
            }
            if (obj instanceof Void) {
                ++this.length;
                continue;
            }
            if (obj instanceof TableIndex) {
                if (((TableIndex)obj).getIndex() <= 255) {
                    this.length += 2;
                    continue;
                }
                this.length += 3;
                continue;
            }
            if (!(obj instanceof RegisterIndex)) continue;
            this.length += 2;
        }
        return 3 + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(150);
        coder.writeShort(this.length);
        for (Object obj : this.values) {
            if (obj instanceof Boolean) {
                coder.writeByte(5);
                if (((Boolean)obj).booleanValue()) {
                    coder.writeByte(1);
                    continue;
                }
                coder.writeByte(0);
                continue;
            }
            if (obj instanceof Integer) {
                coder.writeByte(7);
                coder.writeInt((Integer)obj);
                continue;
            }
            if (obj instanceof Property) {
                coder.writeByte(1);
                coder.writeInt(((Property)obj).getValue(context.get(1)));
                continue;
            }
            if (obj instanceof Double) {
                coder.writeByte(6);
                long longValue = Double.doubleToLongBits((Double)obj);
                coder.writeInt((int)(longValue >> 32));
                coder.writeInt((int)longValue);
                continue;
            }
            if (obj instanceof String) {
                coder.writeByte(0);
                coder.writeString(obj.toString());
                continue;
            }
            if (obj instanceof Null) {
                coder.writeByte(2);
                continue;
            }
            if (obj instanceof Void) {
                coder.writeByte(3);
                continue;
            }
            if (obj instanceof TableIndex) {
                if (((TableIndex)obj).getIndex() <= 255) {
                    coder.writeByte(8);
                    coder.writeByte(((TableIndex)obj).getIndex());
                    continue;
                }
                coder.writeByte(9);
                coder.writeShort(((TableIndex)obj).getIndex());
                continue;
            }
            if (obj instanceof RegisterIndex) {
                coder.writeByte(4);
                coder.writeByte(((RegisterIndex)obj).getNumber());
                continue;
            }
            throw new CoderException(0, "Unsupported type: " + obj.getClass().getName());
        }
    }

    public static final class Builder {
        private final transient List<Object> objects = new ArrayList<Object>();

        public Builder add(Object value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            this.objects.add(value);
            return this;
        }

        public Builder clear() {
            this.objects.clear();
            return this;
        }

        public Push build() {
            return new Push(this.objects);
        }
    }
}

