/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;

public final class MovieMetaData
implements MovieTag {
    private static final String FORMAT = "MetaData: { metadata=%s}";
    private String metaData;
    private transient int length;

    public MovieMetaData(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.metaData = coder.readString(this.length - 1);
        coder.readByte();
        coder.check(this.length);
        coder.unmark();
    }

    public MovieMetaData(String aString) {
        this.setMetaData(aString);
    }

    public MovieMetaData(MovieMetaData object) {
        this.metaData = object.metaData;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String aString) {
        if (aString == null) {
            throw new IllegalArgumentException();
        }
        this.metaData = aString;
    }

    @Override
    public MovieMetaData copy() {
        return new MovieMetaData(this);
    }

    public String toString() {
        return String.format(FORMAT, this.metaData);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = context.strlen(this.metaData);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(4991);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x1340 | this.length);
        }
        coder.writeString(this.metaData);
    }
}

