/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.awt.Point;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import org.openoffice.java.accessibility.AbstractButton;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.Build;
import org.openoffice.java.accessibility.Component;

public class Menu
extends AbstractButton
implements Accessible {
    private Vector children;
    protected XAccessibleSelection unoAccessibleSelection;

    private /* synthetic */ void finit$() {
        this.unoAccessibleSelection = null;
    }

    static /* synthetic */ Vector access$4(Menu menu, Vector vector) {
        menu.children = vector;
        return menu.children;
    }

    protected Menu(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
        this.finit$();
        try {
            int n = this.unoAccessibleContext.getAccessibleChildCount();
            this.children = new Vector(n);
            for (int i = 0; i < n; ++i) {
                Component component = this.getComponent(this.unoAccessibleContext.getAccessibleChild(i));
                if (component == null) continue;
                this.children.add(component);
            }
        }
        catch (RuntimeException runtimeException) {
            if (Build.DEBUG) {
                System.err.println("RuntimeException caught during menu initialization: " + runtimeException.getMessage());
            }
            if (this.children == null) {
                this.children = new Vector(0);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected synchronized void add(XAccessible xAccessible) {
        Component component = this.getComponent(xAccessible);
        if (component != null) {
            try {
                this.children.add(xAccessible.getAccessibleContext().getAccessibleIndexInParent(), component);
                this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    protected synchronized void remove(XAccessible xAccessible) {
        Component component = this.getComponent(xAccessible);
        if (component != null) {
            try {
                this.children.remove(component);
                this.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    protected void add(Object object) {
        try {
            this.add((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void remove(Object object) {
        try {
            this.remove((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected synchronized int indexOf(Object object) {
        return this.children.indexOf(object);
    }

    protected Component getComponent(XAccessible xAccessible) {
        Component component = AccessibleObjectFactory.getAccessibleComponent(xAccessible);
        if (component == null && (component = AccessibleObjectFactory.createAccessibleComponent(xAccessible)) instanceof Accessible) {
            ((Accessible)((Object)component)).getAccessibleContext().setAccessibleParent(this);
        }
        return component;
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleMenuListener(this);
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleMenu(this);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleMenu
    extends AbstractButton.AccessibleAbstractButton
    implements AccessibleSelection {
        private /* synthetic */ Menu this$0;

        protected AccessibleMenu(Menu menu) {
            this.this$0 = menu;
            super(menu);
            menu.unoAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface((Class)Menu.class$("com.sun.star.accessibility.XAccessibleSelection"), (Object)menu.unoAccessibleContext);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        public int getAccessibleIndexInParent() {
            if (this.getAccessibleParent() instanceof Menu) {
                return ((Menu)this.getAccessibleParent()).indexOf(this.this$0);
            }
            return super.getAccessibleIndexInParent();
        }

        public synchronized int getAccessibleChildrenCount() {
            return this.this$0.children.size();
        }

        public synchronized Accessible getAccessibleChild(int n) {
            try {
                if (n < this.this$0.children.size()) {
                    return (Accessible)this.this$0.children.get(n);
                }
                return null;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleAt(java.awt.Point point) {
            try {
                Component component = AccessibleObjectFactory.getAccessibleComponent(this.this$0.unoAccessibleComponent.getAccessibleAtPoint(new Point(point.x, point.y)));
                return (Accessible)((Object)component);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public Accessible getAccessibleSelection(int n) {
            try {
                return (Accessible)((Object)this.this$0.getComponent(this.this$0.unoAccessibleSelection.getSelectedAccessibleChild(n)));
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void addAccessibleSelection(int n) {
            try {
                this.this$0.unoAccessibleSelection.selectAccessibleChild(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void clearAccessibleSelection() {
            try {
                this.this$0.unoAccessibleSelection.clearAccessibleSelection();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        public int getAccessibleSelectionCount() {
            try {
                return this.this$0.unoAccessibleSelection.getSelectedAccessibleChildCount();
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        public boolean isAccessibleChildSelected(int n) {
            try {
                return this.this$0.unoAccessibleSelection.isAccessibleChildSelected(n);
            }
            catch (Exception exception) {
                return false;
            }
        }

        public void removeAccessibleSelection(int n) {
            if (this.isAccessibleChildSelected(n)) {
                this.clearAccessibleSelection();
            }
        }

        public void selectAllAccessibleSelection() {
        }
    }

    protected class AccessibleMenuListener
    extends Component.AccessibleUNOComponentListener {
        private /* synthetic */ Menu this$0;

        protected AccessibleMenuListener(Menu menu) {
            this.this$0 = menu;
            super(menu);
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            switch (accessibleEventObject.EventId) {
                case 7: {
                    if (AnyConverter.isObject((Object)accessibleEventObject.OldValue)) {
                        this.this$0.remove(accessibleEventObject.OldValue);
                    }
                    if (!AnyConverter.isObject((Object)accessibleEventObject.NewValue)) break;
                    this.this$0.add(accessibleEventObject.NewValue);
                    break;
                }
                case 9: {
                    this.this$0.firePropertyChange("AccessibleSelection", null, null);
                    break;
                }
                default: {
                    super.notifyEvent(accessibleEventObject);
                }
            }
        }
    }
}

