/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.AccessibleSelectionImpl;
import org.openoffice.java.accessibility.AccessibleStateAdapter;
import org.openoffice.java.accessibility.AccessibleTextImpl;
import org.openoffice.java.accessibility.Build;

public class Container
extends java.awt.Container
implements Accessible {
    protected XAccessible unoAccessible;
    protected XAccessibleContext unoAccessibleContext;
    protected XAccessibleComponent unoAccessibleComponent;
    protected AccessibleRole accessibleRole;
    protected AccessibleText accessibleText;
    protected boolean disposed;
    protected AccessibleContext accessibleContext;

    private /* synthetic */ void finit$() {
        this.unoAccessibleComponent = null;
        this.disposed = false;
        this.accessibleContext = null;
    }

    protected Container(AccessibleRole accessibleRole, XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        this.finit$();
        this.accessibleRole = accessibleRole;
        this.unoAccessible = xAccessible;
        this.unoAccessibleContext = xAccessibleContext;
        this.unoAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface((Class)Container.class$("com.sun.star.accessibility.XAccessibleComponent"), (Object)xAccessibleContext);
        XAccessibleEventBroadcaster xAccessibleEventBroadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface((Class)Container.class$("com.sun.star.accessibility.XAccessibleEventBroadcaster"), (Object)this.unoAccessibleContext);
        if (xAccessibleEventBroadcaster != null) {
            xAccessibleEventBroadcaster.addEventListener(this.createEventListener());
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean isShowing() {
        if (this.isVisible()) {
            java.awt.Container container = this.getParent();
            return container == null || container.isShowing();
        }
        return false;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    public void requestFocus() {
    }

    public boolean requestFocus(boolean bl) {
        return true;
    }

    public boolean requestFocusInWindow() {
        return this.requestFocusInWindow(false);
    }

    protected boolean requestFocusInWindow(boolean bl) {
        if (this.isFocusable() && this.isVisible()) {
            this.getEventQueue().postEvent(new FocusEvent(this, 1004, bl));
            return true;
        }
        return false;
    }

    public Object[] getAccessibleComponents(Object[] objectArray) {
        try {
            ArrayList<Component> arrayList = new ArrayList<Component>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                Component component = AccessibleObjectFactory.getAccessibleComponent((XAccessible)UnoRuntime.queryInterface((Class)Container.class$("com.sun.star.accessibility.XAccessible"), (Object)objectArray[i]));
                if (component == null) continue;
                arrayList.add(component);
            }
            arrayList.trimToSize();
            return arrayList.toArray();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    protected EventQueue getEventQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueue();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        EventQueue.invokeLater(new PropertyChangeBroadcaster(this, string, object, object2));
    }

    protected void fireStatePropertyChange(AccessibleState accessibleState, boolean bl) {
        PropertyChangeBroadcaster propertyChangeBroadcaster = bl ? new PropertyChangeBroadcaster(this, "AccessibleState", null, accessibleState) : new PropertyChangeBroadcaster(this, "AccessibleState", accessibleState, null);
        EventQueue.invokeLater(propertyChangeBroadcaster);
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleContainerListener(this);
    }

    protected AccessibleContext createAccessibleContext() {
        return new AccessibleContainer(this);
    }

    public final AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            try {
                AccessibleContext accessibleContext = this.createAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(this.unoAccessibleContext.getAccessibleName());
                    accessibleContext.setAccessibleDescription(this.unoAccessibleContext.getAccessibleDescription());
                    this.accessibleContext = accessibleContext;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.accessibleContext;
    }

    public String toString() {
        return UnoRuntime.generateOid((Object)this.unoAccessible);
    }

    protected class AccessibleContainer
    extends Container.AccessibleAWTContainer {
        private /* synthetic */ Container this$0;
        protected ComponentListener accessibleComponentHandler;
        protected FocusListener accessibleFocusHandler;
        protected ContainerListener accessibleContainerHandler;
        protected int propertyChangeListenerCount;

        private /* synthetic */ void finit$() {
            this.accessibleComponentHandler = null;
            this.accessibleFocusHandler = null;
            this.accessibleContainerHandler = null;
            this.propertyChangeListenerCount = 0;
        }

        protected AccessibleContainer(Container container) {
            this.this$0 = container;
            super(container);
            this.finit$();
            container.accessibleText = AccessibleTextImpl.get((XInterface)container.unoAccessibleContext);
        }

        protected AccessibleContainer(Container container, boolean bl) {
            this.this$0 = container;
            super(container);
            this.finit$();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propertyChangeListenerCount++ == 0) {
                this.accessibleFocusHandler = new AccessibleFocusHandler(this);
                this.this$0.addFocusListener(this.accessibleFocusHandler);
                this.accessibleContainerHandler = new AccessibleContainerHandler(this);
                this.this$0.addContainerListener(this.accessibleContainerHandler);
                this.accessibleComponentHandler = new AccessibleComponentHandler(this);
                this.this$0.addComponentListener(this.accessibleComponentHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (--this.propertyChangeListenerCount == 0) {
                this.this$0.removeComponentListener(this.accessibleComponentHandler);
                this.accessibleComponentHandler = null;
                this.this$0.removeContainerListener(this.accessibleContainerHandler);
                this.accessibleContainerHandler = null;
                this.this$0.removeFocusListener(this.accessibleFocusHandler);
                this.accessibleFocusHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        public AccessibleRole getAccessibleRole() {
            return this.this$0.accessibleRole;
        }

        public AccessibleText getAccessibleText() {
            if (this.this$0.disposed) {
                return null;
            }
            return this.this$0.accessibleText;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            if (this.this$0.disposed) {
                return AccessibleStateAdapter.getDefunctStateSet();
            }
            try {
                return AccessibleStateAdapter.getAccessibleStateSet(this.this$0, this.this$0.unoAccessibleContext.getAccessibleStateSet());
            }
            catch (RuntimeException runtimeException) {
                return AccessibleStateAdapter.getDefunctStateSet();
            }
        }

        public AccessibleSelection getAccessibleSelection() {
            try {
                XAccessibleSelection xAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface((Class)Container.class$("com.sun.star.accessibility.XAccessibleSelection"), (Object)this.this$0.unoAccessibleContext);
                if (xAccessibleSelection != null) {
                    return new AccessibleSelectionImpl(xAccessibleSelection);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return null;
        }

        public java.util.Locale getLocale() throws IllegalComponentStateException {
            try {
                Locale locale = this.this$0.unoAccessible.getAccessibleContext().getLocale();
                return new java.util.Locale(locale.Language, locale.Country);
            }
            catch (IllegalAccessibleComponentStateException illegalAccessibleComponentStateException) {
                throw new IllegalComponentStateException(illegalAccessibleComponentStateException.getMessage());
            }
            catch (RuntimeException runtimeException) {
                return super.getLocale();
            }
        }

        public Color getBackground() {
            try {
                return new Color(this.this$0.unoAccessibleComponent.getBackground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setBackground(Color color) {
        }

        public Color getForeground() {
            try {
                return new Color(this.this$0.unoAccessibleComponent.getForeground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setForeground(Color color) {
        }

        public Cursor getCursor() {
            return null;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return null;
        }

        public void setFont(Font font) {
        }

        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        public boolean isEnabled() {
            return this.this$0.isEnabled();
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isVisible() {
            return this.this$0.isVisible();
        }

        public void setVisible(boolean bl) {
        }

        public boolean isShowing() {
            return this.this$0.isShowing();
        }

        public boolean contains(java.awt.Point point) {
            try {
                return this.this$0.unoAccessibleComponent.containsPoint(new Point(point.x, point.y));
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        public java.awt.Point getLocationOnScreen() {
            try {
                Point point = this.this$0.unoAccessibleComponent.getLocationOnScreen();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public java.awt.Point getLocation() {
            try {
                Point point = this.this$0.unoAccessibleComponent.getLocation();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setLocation(java.awt.Point point) {
        }

        public java.awt.Rectangle getBounds() {
            try {
                Rectangle rectangle = this.this$0.unoAccessibleComponent.getBounds();
                return new java.awt.Rectangle(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setBounds(java.awt.Rectangle rectangle) {
        }

        public Dimension getSize() {
            try {
                Size size = this.this$0.unoAccessibleComponent.getSize();
                return new Dimension(size.Width, size.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(java.awt.Point point) {
            try {
                Component component = AccessibleObjectFactory.getAccessibleComponent(this.this$0.unoAccessibleComponent.getAccessibleAtPoint(new Point(point.x, point.y)));
                return (Accessible)((Object)component);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public boolean isFocusTraversable() {
            return this.this$0.isFocusable();
        }

        public void requestFocus() {
            this.this$0.unoAccessibleComponent.grabFocus();
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            private /* synthetic */ AccessibleContainer this$1;

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    this.this$1.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    this.this$1.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
                }
            }

            protected AccessibleContainerHandler(AccessibleContainer accessibleContainer) {
                this.this$1 = accessibleContainer;
            }
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            private /* synthetic */ AccessibleContainer this$1;

            public void focusGained(FocusEvent focusEvent) {
                this.this$1.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                if (Build.DEBUG) {
                    System.err.println("[" + this.this$1.getAccessibleRole() + "] " + ((Component.AccessibleAWTComponent)((Object)this)).getAccessibleName() + " is now focused");
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                this.this$1.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                if (Build.DEBUG) {
                    System.err.println("[" + this.this$1.getAccessibleRole() + "] " + ((Component.AccessibleAWTComponent)((Object)this)).getAccessibleName() + " is no longer focused");
                }
            }

            protected AccessibleFocusHandler(AccessibleContainer accessibleContainer) {
                this.this$1 = accessibleContainer;
            }
        }

        protected class AccessibleComponentHandler
        implements ComponentListener {
            private /* synthetic */ AccessibleContainer this$1;

            public void componentHidden(ComponentEvent componentEvent) {
                this.this$1.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent componentEvent) {
                this.this$1.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }

            protected AccessibleComponentHandler(AccessibleContainer accessibleContainer) {
                this.this$1 = accessibleContainer;
            }
        }
    }

    protected class AccessibleContainerListener
    implements XAccessibleEventListener {
        private /* synthetic */ Container this$0;

        protected AccessibleContainerListener(Container container) {
            this.this$0 = container;
        }

        protected EventQueue getEventQueue() {
            return Toolkit.getDefaultToolkit().getSystemEventQueue();
        }

        protected void setComponentState(short s, boolean bl) {
            switch (s) {
                case 1: {
                    break;
                }
                case 7: {
                    this.this$0.setEnabled(bl);
                    this.this$0.fireStatePropertyChange(AccessibleState.ENABLED, bl);
                    break;
                }
                case 11: {
                    this.getEventQueue().postEvent(new FocusEvent(this.this$0, bl ? 1004 : 1005));
                    break;
                }
                case 23: {
                    this.this$0.fireStatePropertyChange(AccessibleState.SELECTED, bl);
                    break;
                }
                case 25: 
                case 30: {
                    this.this$0.setVisible(bl);
                    break;
                }
                default: {
                    if (!Build.DEBUG) break;
                    System.err.println(this.this$0 + "unexpected state change " + s);
                }
            }
        }

        protected void handleNameChangedEvent(Object object) {
            try {
                if (this.this$0.accessibleContext != null) {
                    this.this$0.accessibleContext.setAccessibleName(AnyConverter.toString((Object)object));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleDescriptionChangedEvent(Object object) {
            try {
                if (this.this$0.accessibleContext != null) {
                    this.this$0.accessibleContext.setAccessibleDescription(AnyConverter.toString((Object)object));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleStateChangedEvent(Object object, Object object2) {
            try {
                if (AnyConverter.isShort((Object)object)) {
                    this.setComponentState(AnyConverter.toShort((Object)object), false);
                }
                if (AnyConverter.isShort((Object)object2)) {
                    this.setComponentState(AnyConverter.toShort((Object)object2), true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleAllChildrenChangedEvent() {
            AccessibleContext accessibleContext;
            Accessible accessible = (Accessible)((Object)this.this$0.getParent());
            if (accessible != null && (accessibleContext = accessible.getAccessibleContext()) != null) {
                accessibleContext.firePropertyChange("AccessibleChild", this.this$0, null);
                AccessibleObjectFactory.clearContainer(this.this$0);
                AccessibleObjectFactory.populateContainer(this.this$0, this.this$0.unoAccessibleContext);
                accessibleContext.firePropertyChange("AccessibleChild", null, this.this$0);
            }
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            if (!this.this$0.disposed) {
                switch (accessibleEventObject.EventId) {
                    case 1: {
                        this.handleNameChangedEvent(accessibleEventObject.NewValue);
                        break;
                    }
                    case 2: {
                        this.handleDescriptionChangedEvent(accessibleEventObject.NewValue);
                        break;
                    }
                    case 4: {
                        this.handleStateChangedEvent(accessibleEventObject.OldValue, accessibleEventObject.NewValue);
                        break;
                    }
                    case 22: {
                        this.this$0.firePropertyChange("AccessibleText", AccessibleTextImpl.convertTextSegment(accessibleEventObject.OldValue), AccessibleTextImpl.convertTextSegment(accessibleEventObject.NewValue));
                        break;
                    }
                    case 7: {
                        if (AnyConverter.isObject((Object)accessibleEventObject.OldValue)) {
                            AccessibleObjectFactory.removeChild(this.this$0, accessibleEventObject.OldValue);
                            break;
                        }
                        if (!AnyConverter.isObject((Object)accessibleEventObject.NewValue)) break;
                        AccessibleObjectFactory.addChild((java.awt.Container)this.this$0, accessibleEventObject.NewValue);
                        break;
                    }
                    case 6: 
                    case 10: {
                        this.this$0.firePropertyChange("AccessibleVisibleData", null, null);
                        break;
                    }
                    case 9: {
                        this.this$0.firePropertyChange("AccessibleSelection", null, null);
                        break;
                    }
                    case 8: {
                        this.handleAllChildrenChangedEvent();
                        break;
                    }
                    default: {
                        if (!Build.DEBUG) break;
                        System.out.println(this + ": unhandled accessibility event id=" + accessibleEventObject.EventId);
                    }
                }
            }
        }

        public void disposing(EventObject eventObject) {
            this.this$0.disposed = true;
            AccessibleObjectFactory.disposing(this.this$0);
        }
    }

    protected class PropertyChangeBroadcaster
    implements Runnable {
        private /* synthetic */ Container this$0;
        String propertyName;
        Object oldValue;
        Object newValue;

        public PropertyChangeBroadcaster(Container container, String string, Object object, Object object2) {
            this.this$0 = container;
            this.propertyName = string;
            this.oldValue = object;
            this.newValue = object2;
        }

        public void run() {
            block3: {
                try {
                    AccessibleContext accessibleContext = this.this$0.accessibleContext;
                    if (accessibleContext != null) {
                        accessibleContext.firePropertyChange(this.propertyName, this.oldValue, this.newValue);
                    }
                }
                catch (Exception exception) {
                    if (!Build.DEBUG) break block3;
                    System.err.println(exception.getClass().getName() + " caught propagating " + this.propertyName + " event: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
    }
}

