/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleExtendedComponent;
import com.sun.star.accessibility.XAccessibleKeyBinding;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import org.openoffice.java.accessibility.AccessibleKeyBinding;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.AccessibleStateAdapter;
import org.openoffice.java.accessibility.AccessibleTextImpl;
import org.openoffice.java.accessibility.Build;

public abstract class Component
extends java.awt.Component {
    public static final Type RectangleType = new Type(Component.class$("com.sun.star.awt.Rectangle"));
    public static final Type SelectionType = new Type(Component.class$("com.sun.star.awt.Selection"));
    protected XAccessible unoAccessible;
    protected XAccessibleContext unoAccessibleContext;
    protected XAccessibleComponent unoAccessibleComponent;
    protected boolean disposed;
    protected AccessibleContext accessibleContext;

    private /* synthetic */ void finit$() {
        this.disposed = false;
        this.accessibleContext = null;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Component(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        this.finit$();
        this.unoAccessible = xAccessible;
        this.unoAccessibleContext = xAccessibleContext;
        this.unoAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface((Class)Component.class$("com.sun.star.accessibility.XAccessibleComponent"), (Object)xAccessibleContext);
        XAccessibleEventBroadcaster xAccessibleEventBroadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface((Class)Component.class$("com.sun.star.accessibility.XAccessibleEventBroadcaster"), (Object)this.unoAccessibleComponent);
        if (xAccessibleEventBroadcaster != null) {
            xAccessibleEventBroadcaster.addEventListener(this.createEventListener());
        }
    }

    public boolean isShowing() {
        if (this.isVisible()) {
            Container container = this.getParent();
            return container == null || container.isShowing();
        }
        return false;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    public void requestFocus() {
    }

    public boolean requestFocus(boolean bl) {
        return true;
    }

    public boolean requestFocusInWindow() {
        return this.requestFocusInWindow(false);
    }

    protected boolean requestFocusInWindow(boolean bl) {
        if (this.isFocusable() && this.isVisible()) {
            this.getEventQueue().postEvent(new FocusEvent(this, 1004, bl));
            return true;
        }
        return false;
    }

    public Object[] getAccessibleComponents(Object[] objectArray) {
        try {
            ArrayList<java.awt.Component> arrayList = new ArrayList<java.awt.Component>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                java.awt.Component component = AccessibleObjectFactory.getAccessibleComponent((XAccessible)UnoRuntime.queryInterface((Class)Component.class$("com.sun.star.accessibility.XAccessible"), (Object)objectArray[i]));
                if (component == null) continue;
                arrayList.add(component);
            }
            arrayList.trimToSize();
            return arrayList.toArray();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    protected EventQueue getEventQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueue();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        EventQueue.invokeLater(new PropertyChangeBroadcaster(this, string, object, object2));
    }

    protected void fireStatePropertyChange(AccessibleState accessibleState, boolean bl) {
        PropertyChangeBroadcaster propertyChangeBroadcaster = bl ? new PropertyChangeBroadcaster(this, "AccessibleState", null, accessibleState) : new PropertyChangeBroadcaster(this, "AccessibleState", accessibleState, null);
        EventQueue.invokeLater(propertyChangeBroadcaster);
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleUNOComponentListener(this);
    }

    protected AccessibleContext createAccessibleContext() {
        return null;
    }

    public final AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            try {
                AccessibleContext accessibleContext = this.createAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(this.unoAccessibleContext.getAccessibleName());
                    accessibleContext.setAccessibleDescription(this.unoAccessibleContext.getAccessibleDescription());
                    this.accessibleContext = accessibleContext;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.accessibleContext;
    }

    public static Number toNumber(Object object) {
        try {
            if (AnyConverter.isByte((Object)object)) {
                return new Byte(AnyConverter.toByte((Object)object));
            }
            if (AnyConverter.isShort((Object)object)) {
                return new Short(AnyConverter.toShort((Object)object));
            }
            if (AnyConverter.isInt((Object)object)) {
                return new Integer(AnyConverter.toInt((Object)object));
            }
            if (AnyConverter.isLong((Object)object)) {
                return new Long(AnyConverter.toLong((Object)object));
            }
            if (AnyConverter.isFloat((Object)object)) {
                return new Float(AnyConverter.toFloat((Object)object));
            }
            if (AnyConverter.isDouble((Object)object)) {
                return new Double(AnyConverter.toDouble((Object)object));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new java.lang.IllegalArgumentException(illegalArgumentException.getMessage());
        }
        return null;
    }

    public String toString() {
        return UnoRuntime.generateOid((Object)this.unoAccessible);
    }

    protected abstract class AccessibleUNOComponent
    extends Component.AccessibleAWTComponent
    implements AccessibleExtendedComponent {
        private /* synthetic */ Component this$0;
        protected ComponentListener accessibleComponentHandler;
        protected FocusListener accessibleFocusHandler;
        protected int propertyChangeListenerCount;

        private /* synthetic */ void finit$() {
            this.accessibleComponentHandler = null;
            this.accessibleFocusHandler = null;
            this.propertyChangeListenerCount = 0;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propertyChangeListenerCount++ == 0) {
                this.accessibleComponentHandler = new AccessibleComponentHandler(this);
                this.this$0.addComponentListener(this.accessibleComponentHandler);
                this.accessibleFocusHandler = new AccessibleFocusHandler(this);
                this.this$0.addFocusListener(this.accessibleFocusHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (--this.propertyChangeListenerCount == 0) {
                this.this$0.removeComponentListener(this.accessibleComponentHandler);
                this.accessibleComponentHandler = null;
                this.this$0.removeFocusListener(this.accessibleFocusHandler);
                this.accessibleFocusHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            if (this.this$0.disposed) {
                return AccessibleStateAdapter.getDefunctStateSet();
            }
            try {
                return AccessibleStateAdapter.getAccessibleStateSet(this.this$0, this.this$0.unoAccessibleContext.getAccessibleStateSet());
            }
            catch (RuntimeException runtimeException) {
                return AccessibleStateAdapter.getDefunctStateSet();
            }
        }

        public java.util.Locale getLocale() throws IllegalComponentStateException {
            try {
                Locale locale = this.this$0.unoAccessible.getAccessibleContext().getLocale();
                return new java.util.Locale(locale.Language, locale.Country);
            }
            catch (IllegalAccessibleComponentStateException illegalAccessibleComponentStateException) {
                throw new IllegalComponentStateException(illegalAccessibleComponentStateException.getMessage());
            }
            catch (RuntimeException runtimeException) {
                return java.util.Locale.getDefault();
            }
        }

        public Color getBackground() {
            try {
                return new Color(this.this$0.unoAccessibleComponent.getBackground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setBackground(Color color) {
        }

        public Color getForeground() {
            try {
                return new Color(this.this$0.unoAccessibleComponent.getForeground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setForeground(Color color) {
        }

        public Cursor getCursor() {
            return null;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return null;
        }

        public void setFont(Font font) {
        }

        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        public boolean isEnabled() {
            return this.this$0.isEnabled();
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isVisible() {
            return this.this$0.isVisible();
        }

        public void setVisible(boolean bl) {
        }

        public boolean isShowing() {
            return this.this$0.isShowing();
        }

        public boolean contains(java.awt.Point point) {
            try {
                return this.this$0.unoAccessibleComponent.containsPoint(new Point(point.x, point.y));
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        public java.awt.Point getLocationOnScreen() {
            try {
                Point point = this.this$0.unoAccessibleComponent.getLocationOnScreen();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public java.awt.Point getLocation() {
            try {
                Point point = this.this$0.unoAccessibleComponent.getLocation();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setLocation(java.awt.Point point) {
        }

        public java.awt.Rectangle getBounds() {
            try {
                Rectangle rectangle = this.this$0.unoAccessibleComponent.getBounds();
                return new java.awt.Rectangle(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setBounds(java.awt.Rectangle rectangle) {
        }

        public Dimension getSize() {
            try {
                Size size = this.this$0.unoAccessibleComponent.getSize();
                return new Dimension(size.Width, size.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(java.awt.Point point) {
            return null;
        }

        public boolean isFocusTraversable() {
            return this.this$0.isFocusable();
        }

        public void requestFocus() {
            this.this$0.unoAccessibleComponent.grabFocus();
        }

        public String getToolTipText() {
            try {
                XAccessibleExtendedComponent xAccessibleExtendedComponent = (XAccessibleExtendedComponent)UnoRuntime.queryInterface((Class)Component.class$("com.sun.star.accessibility.XAccessibleExtendedComponent"), (Object)this.this$0.unoAccessibleComponent);
                if (xAccessibleExtendedComponent != null) {
                    return xAccessibleExtendedComponent.getToolTipText();
                }
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
            return null;
        }

        public String getTitledBorderText() {
            try {
                XAccessibleExtendedComponent xAccessibleExtendedComponent = (XAccessibleExtendedComponent)UnoRuntime.queryInterface((Class)Component.class$("com.sun.star.accessibility.XAccessibleExtendedComponent"), (Object)this.this$0.unoAccessibleComponent);
                if (xAccessibleExtendedComponent != null) {
                    return xAccessibleExtendedComponent.getTitledBorderText();
                }
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
            return null;
        }

        public javax.accessibility.AccessibleKeyBinding getAccessibleKeyBinding() {
            try {
                XAccessibleKeyBinding xAccessibleKeyBinding;
                XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface((Class)Component.class$("com.sun.star.accessibility.XAccessibleAction"), (Object)this.this$0.unoAccessibleComponent);
                if (xAccessibleAction != null && (xAccessibleKeyBinding = xAccessibleAction.getAccessibleActionKeyBinding(0)) != null) {
                    return new AccessibleKeyBinding(xAccessibleKeyBinding);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
            return null;
        }

        protected AccessibleUNOComponent(Component component) {
            this.this$0 = component;
            super(component);
            this.finit$();
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            private /* synthetic */ AccessibleUNOComponent this$1;

            public void focusGained(FocusEvent focusEvent) {
                this.this$1.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                if (Build.DEBUG) {
                    System.err.println("[" + ((Component.AccessibleAWTComponent)((Object)this)).getAccessibleRole() + "] " + ((Component.AccessibleAWTComponent)((Object)this)).getAccessibleName() + " is now focused");
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                this.this$1.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                if (Build.DEBUG) {
                    System.err.println("[" + ((Component.AccessibleAWTComponent)((Object)this)).getAccessibleRole() + "] " + ((Component.AccessibleAWTComponent)((Object)this)).getAccessibleName() + " is no longer focused");
                }
            }

            protected AccessibleFocusHandler(AccessibleUNOComponent accessibleUNOComponent) {
                this.this$1 = accessibleUNOComponent;
            }
        }

        protected class AccessibleComponentHandler
        implements ComponentListener {
            private /* synthetic */ AccessibleUNOComponent this$1;

            public void componentHidden(ComponentEvent componentEvent) {
                this.this$1.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent componentEvent) {
                this.this$1.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }

            protected AccessibleComponentHandler(AccessibleUNOComponent accessibleUNOComponent) {
                this.this$1 = accessibleUNOComponent;
            }
        }
    }

    protected class AccessibleUNOComponentListener
    implements XAccessibleEventListener {
        private /* synthetic */ Component this$0;

        protected AccessibleUNOComponentListener(Component component) {
            this.this$0 = component;
        }

        protected void setComponentState(short s, boolean bl) {
            switch (s) {
                case 1: {
                    break;
                }
                case 2: {
                    this.this$0.fireStatePropertyChange(AccessibleState.ARMED, bl);
                    break;
                }
                case 4: {
                    this.this$0.fireStatePropertyChange(AccessibleState.CHECKED, bl);
                    break;
                }
                case 7: {
                    this.this$0.setEnabled(bl);
                    this.this$0.fireStatePropertyChange(AccessibleState.ENABLED, bl);
                    break;
                }
                case 11: {
                    this.this$0.getEventQueue().postEvent(new FocusEvent(this.this$0, bl ? 1004 : 1005));
                    break;
                }
                case 20: {
                    this.this$0.fireStatePropertyChange(AccessibleState.PRESSED, bl);
                    break;
                }
                case 23: {
                    this.this$0.fireStatePropertyChange(AccessibleState.SELECTED, bl);
                    break;
                }
                case 25: {
                    break;
                }
                case 30: {
                    this.this$0.setVisible(bl);
                    break;
                }
                default: {
                    if (!Build.DEBUG) break;
                    System.err.println("[component]: " + this.this$0.getName() + "unexpected state change " + s);
                }
            }
        }

        protected void handleNameChangedEvent(Object object) {
            try {
                if (this.this$0.accessibleContext != null) {
                    this.this$0.accessibleContext.setAccessibleName(AnyConverter.toString((Object)object));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleDescriptionChangedEvent(Object object) {
            try {
                if (this.this$0.accessibleContext != null) {
                    this.this$0.accessibleContext.setAccessibleDescription(AnyConverter.toString((Object)object));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleStateChangedEvent(Object object, Object object2) {
            try {
                if (AnyConverter.isShort((Object)object)) {
                    this.setComponentState(AnyConverter.toShort((Object)object), false);
                }
                if (AnyConverter.isShort((Object)object2)) {
                    this.setComponentState(AnyConverter.toShort((Object)object2), true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            if (!this.this$0.disposed) {
                switch (accessibleEventObject.EventId) {
                    case 3: {
                        this.this$0.firePropertyChange("accessibleActionProperty", Component.toNumber(accessibleEventObject.OldValue), Component.toNumber(accessibleEventObject.NewValue));
                        break;
                    }
                    case 1: {
                        this.handleNameChangedEvent(accessibleEventObject.NewValue);
                        break;
                    }
                    case 2: {
                        this.handleDescriptionChangedEvent(accessibleEventObject.NewValue);
                        break;
                    }
                    case 7: {
                        if (!Build.DEBUG) break;
                        System.out.println("Unexpected child event for object of role " + this.this$0.getAccessibleContext().getAccessibleRole());
                        break;
                    }
                    case 4: {
                        this.handleStateChangedEvent(accessibleEventObject.OldValue, accessibleEventObject.NewValue);
                        break;
                    }
                    case 6: 
                    case 10: {
                        this.this$0.firePropertyChange("AccessibleVisibleData", null, null);
                        break;
                    }
                    case 22: {
                        this.this$0.firePropertyChange("AccessibleText", AccessibleTextImpl.convertTextSegment(accessibleEventObject.OldValue), AccessibleTextImpl.convertTextSegment(accessibleEventObject.NewValue));
                        break;
                    }
                    case 20: {
                        this.this$0.firePropertyChange("AccessibleCaret", Component.toNumber(accessibleEventObject.OldValue), Component.toNumber(accessibleEventObject.NewValue));
                        break;
                    }
                    case 11: {
                        this.this$0.firePropertyChange("AccessibleValue", Component.toNumber(accessibleEventObject.OldValue), Component.toNumber(accessibleEventObject.NewValue));
                    }
                    default: {
                        if (!Build.DEBUG) break;
                        System.out.println(this + ": unhandled accessibility event id=" + accessibleEventObject.EventId);
                    }
                }
            }
        }

        public void disposing(EventObject eventObject) {
            this.this$0.disposed = true;
            AccessibleObjectFactory.disposing(this.this$0);
        }
    }

    protected class PropertyChangeBroadcaster
    implements Runnable {
        private /* synthetic */ Component this$0;
        String propertyName;
        Object oldValue;
        Object newValue;

        public PropertyChangeBroadcaster(Component component, String string, Object object, Object object2) {
            this.this$0 = component;
            this.propertyName = string;
            this.oldValue = object;
            this.newValue = object2;
        }

        public void run() {
            block3: {
                try {
                    AccessibleContext accessibleContext = this.this$0.accessibleContext;
                    if (accessibleContext != null) {
                        accessibleContext.firePropertyChange(this.propertyName, this.oldValue, this.newValue);
                    }
                }
                catch (Exception exception) {
                    if (!Build.DEBUG) break block3;
                    System.err.println(exception.getClass().getName() + " caught propagating " + this.propertyName + " event: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
    }
}

