/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.XAccessibleStateSet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import java.awt.Component;
import java.awt.Window;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import org.openoffice.java.accessibility.AccessibleExtendedState;
import org.openoffice.java.accessibility.Build;

public class AccessibleStateAdapter {
    private static final AccessibleState[] stateTypeMap = new AccessibleState[]{null, AccessibleState.ACTIVE, AccessibleState.ARMED, AccessibleState.BUSY, AccessibleState.CHECKED, AccessibleExtendedState.DEFUNCT, AccessibleState.EDITABLE, AccessibleState.ENABLED, AccessibleState.EXPANDABLE, AccessibleState.EXPANDED, AccessibleState.FOCUSABLE, AccessibleState.FOCUSED, AccessibleState.HORIZONTAL, AccessibleState.ICONIFIED, AccessibleExtendedState.INDETERMINATE, AccessibleExtendedState.MANAGES_DESCENDANTS, AccessibleState.MODAL, AccessibleState.MULTI_LINE, AccessibleState.MULTISELECTABLE, AccessibleState.OPAQUE, AccessibleState.PRESSED, AccessibleState.RESIZABLE, AccessibleState.SELECTABLE, AccessibleState.SELECTED, AccessibleExtendedState.SENSITIVE, AccessibleState.SHOWING, AccessibleState.SINGLE_LINE, AccessibleExtendedState.STALE, AccessibleState.TRANSIENT, AccessibleState.VERTICAL, AccessibleState.VISIBLE};

    private static void printToplevelStateMessage(AccessibleState accessibleState, Component component) {
        System.err.println("*** ERROR *** " + accessibleState + " state is a toplevel window state " + component);
    }

    private static void printOutOfSyncMessage(AccessibleState accessibleState, Component component) {
        System.err.println("*** ERROR *** " + accessibleState + " state out of sync for " + component);
    }

    public static AccessibleState getAccessibleState(Object object) {
        try {
            if (AnyConverter.isShort((Object)object)) {
                return AccessibleStateAdapter.getAccessibleState(AnyConverter.toShort((Object)object));
            }
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static AccessibleState getAccessibleState(short s) {
        if (s > 0 && s < stateTypeMap.length) {
            return stateTypeMap[s];
        }
        return null;
    }

    public static AccessibleStateSet getDefunctStateSet() {
        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
        accessibleStateSet.add(AccessibleExtendedState.DEFUNCT);
        return accessibleStateSet;
    }

    public static AccessibleStateSet getAccessibleStateSet(Component component, XAccessibleStateSet xAccessibleStateSet) {
        try {
            if (xAccessibleStateSet != null) {
                int n;
                AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
                short[] sArray = xAccessibleStateSet.getStates();
                for (n = 0; n < sArray.length; ++n) {
                    if (sArray[n] <= 0 || sArray[n] >= stateTypeMap.length) continue;
                    accessibleStateSet.add(stateTypeMap[sArray[n]]);
                }
                if (accessibleStateSet.contains(AccessibleState.EXPANDABLE) && !accessibleStateSet.contains(AccessibleState.EXPANDED)) {
                    accessibleStateSet.add(AccessibleState.COLLAPSED);
                }
                n = component.isFocusOwner() ? accessibleStateSet.add(AccessibleState.FOCUSED) ^ 1 : accessibleStateSet.remove(AccessibleState.FOCUSED) ^ 1;
                boolean bl = component instanceof Window && ((Window)component).isActive() ? accessibleStateSet.add(AccessibleState.ACTIVE) ^ true : accessibleStateSet.remove(AccessibleState.ACTIVE) ^ true;
                if (!Build.PRODUCT) {
                    if (n == 0) {
                        AccessibleStateAdapter.printOutOfSyncMessage(AccessibleState.FOCUSED, component);
                    }
                    if (!bl) {
                        AccessibleStateAdapter.printOutOfSyncMessage(AccessibleState.ACTIVE, component);
                    }
                    if (accessibleStateSet.contains(AccessibleState.ENABLED) != component.isEnabled()) {
                        AccessibleStateAdapter.printOutOfSyncMessage(AccessibleState.ENABLED, component);
                    }
                    if (accessibleStateSet.contains(AccessibleState.FOCUSABLE) != component.isFocusable()) {
                        AccessibleStateAdapter.printOutOfSyncMessage(AccessibleState.FOCUSABLE, component);
                    }
                    if (accessibleStateSet.contains(AccessibleState.SHOWING) != component.isShowing()) {
                        AccessibleStateAdapter.printOutOfSyncMessage(AccessibleState.SHOWING, component);
                    }
                    if (accessibleStateSet.contains(AccessibleState.VISIBLE) != component.isVisible()) {
                        AccessibleStateAdapter.printOutOfSyncMessage(AccessibleState.VISIBLE, component);
                    }
                    if (!(component instanceof Window)) {
                        if (accessibleStateSet.contains(AccessibleState.ACTIVE)) {
                            AccessibleStateAdapter.printToplevelStateMessage(AccessibleState.ACTIVE, component);
                        }
                        if (accessibleStateSet.contains(AccessibleState.ICONIFIED)) {
                            AccessibleStateAdapter.printToplevelStateMessage(AccessibleState.ICONIFIED, component);
                        }
                        if (accessibleStateSet.contains(AccessibleState.MODAL)) {
                            AccessibleStateAdapter.printToplevelStateMessage(AccessibleState.MODAL, component);
                        }
                    }
                }
                return accessibleStateSet;
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return AccessibleStateAdapter.getDefunctStateSet();
        }
    }
}

